/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.OptimizerOptions;
import org.apache.flink.testutils.TestConfigUtils;
import org.apache.flink.testutils.TestFileSystem;
import org.apache.flink.testutils.TestFileUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.IntValue;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class DelimitedInputFormatSamplingTest {
    private static final String TEST_DATA1 = "123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n";
    private static final String TEST_DATA2 = "12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n";
    private static final int TEST_DATA_1_LINES = "123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n".split("\n").length;
    private static final int TEST_DATA_1_LINEWIDTH = "123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n".split("\n")[0].length();
    private static final int TEST_DATA_2_LINEWIDTH = "12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n".split("\n")[0].length();
    private static final int TOTAL_SIZE = "123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n".length() + "12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n".length();
    private static final int DEFAULT_NUM_SAMPLES = 4;
    private static Configuration CONFIG;
    @TempDir
    private static Path tempDir;
    private static File testTempFolder;

    DelimitedInputFormatSamplingTest() {
    }

    @BeforeAll
    static void initialize() {
        try {
            testTempFolder = TempDirUtils.newFolder((Path)tempDir);
            CONFIG = TestConfigUtils.loadGlobalConf(new String[]{OptimizerOptions.DELIMITED_FORMAT_MIN_LINE_SAMPLES.key(), OptimizerOptions.DELIMITED_FORMAT_MAX_LINE_SAMPLES.key()}, new String[]{"4", "4"}, testTempFolder);
        }
        catch (Throwable t) {
            Fail.fail((String)"Could not load the global configuration.");
        }
    }

    @Test
    void testNumSamplesOneFile() throws IOException {
        String tempFile = TestFileUtils.createTempFile(TEST_DATA1);
        Configuration conf = new Configuration();
        TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
        format.setFilePath(tempFile.replace("file", "test"));
        format.configure(conf);
        TestFileSystem.resetStreamOpenCounter();
        format.getStatistics(null);
        ((AbstractIntegerAssert)Assertions.assertThat((int)TestFileSystem.getNumtimeStreamOpened()).as("Wrong number of samples taken.", new Object[0])).isEqualTo(4);
        TestDelimitedInputFormat format2 = new TestDelimitedInputFormat(CONFIG);
        format2.setFilePath(tempFile.replace("file", "test"));
        format2.setNumLineSamples(8);
        format2.configure(conf);
        TestFileSystem.resetStreamOpenCounter();
        format2.getStatistics(null);
        ((AbstractIntegerAssert)Assertions.assertThat((int)TestFileSystem.getNumtimeStreamOpened()).as("Wrong number of samples taken.", new Object[0])).isEqualTo(8);
    }

    @Test
    void testNumSamplesMultipleFiles() throws IOException {
        String tempFile = TestFileUtils.createTempFileDir(testTempFolder, TEST_DATA1, TEST_DATA1, TEST_DATA1, TEST_DATA1);
        Configuration conf = new Configuration();
        TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
        format.setFilePath(tempFile.replace("file", "test"));
        format.configure(conf);
        TestFileSystem.resetStreamOpenCounter();
        format.getStatistics(null);
        ((AbstractIntegerAssert)Assertions.assertThat((int)TestFileSystem.getNumtimeStreamOpened()).as("Wrong number of samples taken.", new Object[0])).isEqualTo(4);
        TestDelimitedInputFormat format2 = new TestDelimitedInputFormat(CONFIG);
        format2.setFilePath(tempFile.replace("file", "test"));
        format2.setNumLineSamples(8);
        format2.configure(conf);
        TestFileSystem.resetStreamOpenCounter();
        format2.getStatistics(null);
        ((AbstractIntegerAssert)Assertions.assertThat((int)TestFileSystem.getNumtimeStreamOpened()).as("Wrong number of samples taken.", new Object[0])).isEqualTo(8);
    }

    @Test
    void testSamplingOneFile() throws IOException {
        String tempFile = TestFileUtils.createTempFile(TEST_DATA1);
        Configuration conf = new Configuration();
        TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
        format.setFilePath(tempFile);
        format.configure(conf);
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        int numLines = TEST_DATA_1_LINES;
        float avgWidth = (float)TEST_DATA1.length() / (float)TEST_DATA_1_LINES;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(stats.getNumberOfRecords() < (long)(numLines + 1) & stats.getNumberOfRecords() > (long)(numLines - 1))).as("Wrong record count.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(stats.getAverageRecordWidth() < avgWidth + 1.0f & stats.getAverageRecordWidth() > avgWidth - 1.0f)).as("Wrong avg record size.", new Object[0])).isTrue();
    }

    @Test
    void testSamplingDirectory() throws IOException {
        String tempFile = TestFileUtils.createTempFileDir(testTempFolder, TEST_DATA1, TEST_DATA2);
        Configuration conf = new Configuration();
        TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
        format.setFilePath(tempFile);
        format.configure(conf);
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        int maxNumLines = (int)Math.ceil((double)TOTAL_SIZE / (double)Math.min(TEST_DATA_1_LINEWIDTH, TEST_DATA_2_LINEWIDTH));
        int minNumLines = (int)((double)TOTAL_SIZE / (double)Math.max(TEST_DATA_1_LINEWIDTH, TEST_DATA_2_LINEWIDTH));
        float maxAvgWidth = (float)TOTAL_SIZE / (float)minNumLines;
        float minAvgWidth = (float)TOTAL_SIZE / (float)maxNumLines;
        if (!(stats.getNumberOfRecords() <= (long)maxNumLines & stats.getNumberOfRecords() >= (long)minNumLines)) {
            System.err.println("Records: " + stats.getNumberOfRecords() + " out of (" + minNumLines + ", " + maxNumLines + ").");
            Fail.fail((String)"Wrong record count.");
        }
        if (!(stats.getAverageRecordWidth() <= maxAvgWidth & stats.getAverageRecordWidth() >= minAvgWidth)) {
            Fail.fail((String)"Wrong avg record size.");
        }
    }

    @Test
    void testDifferentDelimiter() throws IOException {
        String DELIMITER = "12345678-";
        String testData = TEST_DATA1.replace("\n", "12345678-");
        String tempFile = TestFileUtils.createTempFile(testData);
        Configuration conf = new Configuration();
        TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
        format.setFilePath(tempFile);
        format.setDelimiter("12345678-");
        format.configure(conf);
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        int numLines = TEST_DATA_1_LINES;
        float avgWidth = (float)testData.length() / (float)TEST_DATA_1_LINES;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(stats.getNumberOfRecords() < (long)(numLines + 1) & stats.getNumberOfRecords() > (long)(numLines - 1))).as("Wrong record count.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(stats.getAverageRecordWidth() < avgWidth + 1.0f & stats.getAverageRecordWidth() > avgWidth - 1.0f)).as("Wrong avg record size.", new Object[0])).isTrue();
    }

    @Test
    void testSamplingOverlyLongRecord() throws IOException {
        String tempFile = TestFileUtils.createTempFile(2L * (long)((Integer)OptimizerOptions.DELIMITED_FORMAT_MAX_SAMPLE_LEN.defaultValue()).intValue());
        Configuration conf = new Configuration();
        TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
        format.setFilePath(tempFile);
        format.configure(conf);
        ((ObjectAssert)Assertions.assertThat((Object)format.getStatistics(null)).as("Expected exception due to overly long record.", new Object[0])).isNull();
    }

    @Test
    void testCachedStatistics() throws IOException {
        String tempFile = TestFileUtils.createTempFile(TEST_DATA1);
        Configuration conf = new Configuration();
        TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
        format.setFilePath("test://" + tempFile);
        format.configure(conf);
        TestFileSystem.resetStreamOpenCounter();
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((AbstractIntegerAssert)Assertions.assertThat((int)TestFileSystem.getNumtimeStreamOpened()).as("Wrong number of samples taken.", new Object[0])).isEqualTo(4);
        TestDelimitedInputFormat format2 = new TestDelimitedInputFormat(CONFIG);
        format2.setFilePath("test://" + tempFile);
        format2.configure(conf);
        TestFileSystem.resetStreamOpenCounter();
        FileInputFormat.FileBaseStatistics stats2 = format2.getStatistics((BaseStatistics)stats);
        ((AbstractIntegerAssert)Assertions.assertThat((int)TestFileSystem.getNumtimeStreamOpened()).as("Using cached statistics should cicumvent sampling.", new Object[0])).isZero();
        ((ObjectAssert)Assertions.assertThat((Object)stats2).as("Using cached statistics should cicumvent sampling.", new Object[0])).isSameAs((Object)stats);
    }

    private static final class TestDelimitedInputFormat
    extends DelimitedInputFormat<IntValue> {
        private static final long serialVersionUID = 1L;

        TestDelimitedInputFormat(Configuration configuration) {
            super(null, configuration);
        }

        public IntValue readRecord(IntValue reuse, byte[] bytes, int offset, int numBytes) {
            throw new UnsupportedOperationException();
        }
    }
}

