/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.io.DelimitedInputFormatTest;
import org.apache.flink.api.common.io.GenericCsvInputFormat;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class GenericCsvInputFormatTest {
    private TestCsvInputFormat format;

    GenericCsvInputFormatTest() {
    }

    @BeforeEach
    void setup() {
        this.format = new TestCsvInputFormat();
        this.format.setFilePath("file:///some/file/that/will/not/be/read");
    }

    @AfterEach
    void setdown() throws Exception {
        if (this.format != null) {
            this.format.close();
        }
    }

    @Test
    void testSparseFieldArray() {
        Class[] originalTypes = new Class[]{IntValue.class, null, null, StringValue.class, null, DoubleValue.class};
        this.format.setFieldTypesGeneric(originalTypes);
        Assertions.assertThat((int)this.format.getNumberOfNonNullFields()).isEqualTo(3);
        Assertions.assertThat((int)this.format.getNumberOfFieldsTotal()).isEqualTo(6);
        Assertions.assertThat((Object[])this.format.getGenericFieldTypes()).isEqualTo((Object)originalTypes);
    }

    @Test
    void testReadNoPosAll() throws IOException {
        String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444|555\n666|777|888|999|000|");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createIntValues(5);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(222);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(333);
        Assertions.assertThat((int)((IntValue)values[3]).getValue()).isEqualTo(444);
        Assertions.assertThat((int)((IntValue)values[4]).getValue()).isEqualTo(555);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(666);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(777);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(888);
        Assertions.assertThat((int)((IntValue)values[3]).getValue()).isEqualTo(999);
        Assertions.assertThat((int)((IntValue)values[4]).getValue()).isEqualTo(0);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testReadNoPosAllDeflate() throws IOException {
        String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
        FileInputSplit split = this.createTempDeflateFile("111|222|333|444|555\n666|777|888|999|000|");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createIntValues(5);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(222);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(333);
        Assertions.assertThat((int)((IntValue)values[3]).getValue()).isEqualTo(444);
        Assertions.assertThat((int)((IntValue)values[4]).getValue()).isEqualTo(555);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(666);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(777);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(888);
        Assertions.assertThat((int)((IntValue)values[3]).getValue()).isEqualTo(999);
        Assertions.assertThat((int)((IntValue)values[4]).getValue()).isEqualTo(0);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testReadNoPosAllGzip() throws IOException {
        String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
        FileInputSplit split = this.createTempGzipFile("111|222|333|444|555\n666|777|888|999|000|");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createIntValues(5);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(222);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(333);
        Assertions.assertThat((int)((IntValue)values[3]).getValue()).isEqualTo(444);
        Assertions.assertThat((int)((IntValue)values[4]).getValue()).isEqualTo(555);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(666);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(777);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(888);
        Assertions.assertThat((int)((IntValue)values[3]).getValue()).isEqualTo(999);
        Assertions.assertThat((int)((IntValue)values[4]).getValue()).isEqualTo(0);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testReadNoPosAllZStandard() throws IOException {
        String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
        FileInputSplit split = this.createTempZStandardFile("111|222|333|444|555\n666|777|888|999|000|");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createIntValues(5);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(222);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(333);
        Assertions.assertThat((int)((IntValue)values[3]).getValue()).isEqualTo(444);
        Assertions.assertThat((int)((IntValue)values[4]).getValue()).isEqualTo(555);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(666);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(777);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(888);
        Assertions.assertThat((int)((IntValue)values[3]).getValue()).isEqualTo(999);
        Assertions.assertThat((int)((IntValue)values[4]).getValue()).isEqualTo(0);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testReadNoPosFirstN() throws IOException {
        String fileContent = "111|222|333|444|555|\n666|777|888|999|000|";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444|555|\n666|777|888|999|000|");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createIntValues(2);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(222);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(666);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(777);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testSparseParse() throws IOException {
        String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, null, null, IntValue.class, null, null, null, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createIntValues(3);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(444);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(888);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(0);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(777);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(333);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testLongLongLong() throws IOException {
        String fileContent = "1,2,3\n3,2,1";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("1,2,3\n3,2,1");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter(",");
        this.format.setFieldTypesGeneric(new Class[]{LongValue.class, LongValue.class, LongValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createLongValues(3);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((long)((LongValue)values[0]).getValue()).isEqualTo(1L);
        Assertions.assertThat((long)((LongValue)values[1]).getValue()).isEqualTo(2L);
        Assertions.assertThat((long)((LongValue)values[2]).getValue()).isEqualTo(3L);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((long)((LongValue)values[0]).getValue()).isEqualTo(3L);
        Assertions.assertThat((long)((LongValue)values[1]).getValue()).isEqualTo(2L);
        Assertions.assertThat((long)((LongValue)values[2]).getValue()).isEqualTo(1L);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testSparseParseWithIndices() throws IOException {
        String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldsGeneric(new int[]{0, 3, 7}, new Class[]{IntValue.class, IntValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createIntValues(3);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(444);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(888);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(0);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(777);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(333);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testSparseParseWithIndicesMultiCharDelimiter() throws IOException {
        String fileContent = "111|-|222|-|333|-|444|-|555|-|666|-|777|-|888|-|999|-|000|-|\n000|-|999|-|888|-|777|-|666|-|555|-|444|-|333|-|222|-|111\n555|-|999|-|888|-|111|-|666|-|555|-|444|-|777|-|222|-|111|-|\n22222|-|99999|-|8|-|99999999|-|6666666|-|5|-|4444|-|8|-|22222|-|1\n";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|-|222|-|333|-|444|-|555|-|666|-|777|-|888|-|999|-|000|-|\n000|-|999|-|888|-|777|-|666|-|555|-|444|-|333|-|222|-|111\n555|-|999|-|888|-|111|-|666|-|555|-|444|-|777|-|222|-|111|-|\n22222|-|99999|-|8|-|99999999|-|6666666|-|5|-|4444|-|8|-|22222|-|1\n");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|-|");
        this.format.setFieldsGeneric(new int[]{0, 3, 7}, new Class[]{IntValue.class, IntValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = this.createIntValues(3);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(444);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(888);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(0);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(777);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(333);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(555);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(111);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(777);
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((int)((IntValue)values[0]).getValue()).isEqualTo(22222);
        Assertions.assertThat((int)((IntValue)values[1]).getValue()).isEqualTo(99999999);
        Assertions.assertThat((int)((IntValue)values[2]).getValue()).isEqualTo(8);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void testReadTooShortInput() throws IOException {
        String fileContent = "111|222|333|444\n666|777|888|999";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444\n666|777|888|999");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Value[] values = this.createIntValues(5);
        Assertions.assertThatThrownBy(() -> {
            Value[] cfr_ignored_0 = (Value[])this.format.nextRecord(values);
        }).isInstanceOf(ParseException.class);
    }

    @Test
    void testReadTooShortInputLenient() throws IOException {
        String fileContent = "666|777|888|999|555\n111|222|333|444\n666|777|888|999|555";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("666|777|888|999|555\n111|222|333|444\n666|777|888|999|555");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
        this.format.setLenient(true);
        this.format.configure(parameters);
        this.format.open(split);
        Value[] values = this.createIntValues(5);
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNotNull();
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNotNull();
    }

    @Test
    void testReadInvalidContents() throws IOException {
        String fileContent = "abc|222|def|444\nkkz|777|888|hhg";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("abc|222|def|444\nkkz|777|888|hhg");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{StringValue.class, IntValue.class, StringValue.class, IntValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Value[] values = new Value[]{new StringValue(), new IntValue(), new StringValue(), new IntValue()};
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNotNull();
        Assertions.assertThatThrownBy(() -> {
            Value[] cfr_ignored_0 = (Value[])this.format.nextRecord(values);
        }).isInstanceOf(ParseException.class);
    }

    @Test
    void testReadInvalidContentsLenient() throws IOException {
        String fileContent = "abc|222|def|444\nkkz|777|888|hhg";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("abc|222|def|444\nkkz|777|888|hhg");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{StringValue.class, IntValue.class, StringValue.class, IntValue.class});
        this.format.setLenient(true);
        this.format.configure(parameters);
        this.format.open(split);
        Value[] values = new Value[]{new StringValue(), new IntValue(), new StringValue(), new IntValue()};
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNotNull();
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
    }

    @Test
    void testReadInvalidContentsLenientWithSkipping() throws IOException {
        String fileContent = "abc|dfgsdf|777|444\nkkz|777|foobar|hhg\nkkz|777foobarhhg  \nxyx|ignored|42|\n";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("abc|dfgsdf|777|444\nkkz|777|foobar|hhg\nkkz|777foobarhhg  \nxyx|ignored|42|\n");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{StringValue.class, null, IntValue.class});
        this.format.setLenient(true);
        this.format.configure(parameters);
        this.format.open(split);
        Value[] values = new Value[]{new StringValue(), new IntValue()};
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNotNull();
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNotNull();
    }

    @Test
    void testReadWithCharset() throws IOException {
        Object[] records = new String[]{"\u020e\u021f", "Flink", "\u020b\u020f"};
        String delimiter = "\u05c0\u05c0";
        String fileContent = StringUtils.join((Object[])records, (String)delimiter);
        GenericCsvInputFormat<String[]> format = new GenericCsvInputFormat<String[]>(){

            public String[] readRecord(String[] target, byte[] bytes, int offset, int numBytes) {
                return this.parseRecord(target, bytes, offset, numBytes) ? target : null;
            }
        };
        format.setFilePath("file:///some/file/that/will/not/be/read");
        for (String charset : new String[]{"UTF-8", "UTF-16BE", "UTF-16LE"}) {
            File tempFile = File.createTempFile("test_contents", "tmp");
            tempFile.deleteOnExit();
            try (OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]), charset);){
                out.write(fileContent);
            }
            FileInputSplit split = new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
            format.setFieldDelimiter(delimiter);
            format.setFieldTypesGeneric(new Class[]{String.class, String.class, String.class});
            format.setCharset(charset);
            format.configure(new Configuration());
            format.open(split);
            Object[] values = new String[]{"", "", ""};
            values = (String[])format.nextRecord((Object)values);
            Assertions.assertThat((Object[])values).isNotNull();
            for (int i = 0; i < records.length; ++i) {
                Assertions.assertThat((String)values[i]).isEqualTo((String)records[i]);
            }
            Assertions.assertThat((Object[])((Object[])format.nextRecord((Object)values))).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        format.close();
    }

    @Test
    void readWithEmptyField() throws IOException {
        String fileContent = "abc|def|ghijk\nabc||hhg\n|||";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("abc|def|ghijk\nabc||hhg\n|||");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{StringValue.class, StringValue.class, StringValue.class});
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = new Value[]{new StringValue(), new StringValue(), new StringValue()};
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((String)((StringValue)values[0]).getValue()).isEqualTo("abc");
        Assertions.assertThat((String)((StringValue)values[1]).getValue()).isEqualTo("def");
        Assertions.assertThat((String)((StringValue)values[2]).getValue()).isEqualTo("ghijk");
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((String)((StringValue)values[0]).getValue()).isEqualTo("abc");
        Assertions.assertThat((String)((StringValue)values[1]).getValue()).isEqualTo("");
        Assertions.assertThat((String)((StringValue)values[2]).getValue()).isEqualTo("hhg");
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((String)((StringValue)values[0]).getValue()).isEqualTo("");
        Assertions.assertThat((String)((StringValue)values[1]).getValue()).isEqualTo("");
        Assertions.assertThat((String)((StringValue)values[2]).getValue()).isEqualTo("");
    }

    @Test
    void readWithParseQuotedStrings() throws IOException {
        String fileContent = "\"ab\\\"c\"|\"def\"\n\"ghijk\"|\"abc\"";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("\"ab\\\"c\"|\"def\"\n\"ghijk\"|\"abc\"");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{StringValue.class, StringValue.class});
        this.format.enableQuotedStringParsing('\"');
        this.format.configure(parameters);
        this.format.open(split);
        Object[] values = new Value[]{new StringValue(), new StringValue()};
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((String)((StringValue)values[0]).getValue()).isEqualTo("ab\\\"c");
        Assertions.assertThat((String)((StringValue)values[1]).getValue()).isEqualTo("def");
        values = (Value[])this.format.nextRecord(values);
        Assertions.assertThat((Object[])values).isNotNull();
        Assertions.assertThat((String)((StringValue)values[0]).getValue()).isEqualTo("ghijk");
        Assertions.assertThat((String)((StringValue)values[1]).getValue()).isEqualTo("abc");
    }

    @Test
    void readWithHeaderLine() throws IOException {
        String fileContent = "colname-1|colname-2|some name 3|column four|\n123|abc|456|def|\n987|xyz|654|pqr|\n";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("colname-1|colname-2|some name 3|column four|\n123|abc|456|def|\n987|xyz|654|pqr|\n");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, StringValue.class, IntValue.class, StringValue.class});
        this.format.setSkipFirstLineAsHeader(true);
        this.format.configure(parameters);
        this.format.open(split);
        Value[] values = new Value[]{new IntValue(), new StringValue(), new IntValue(), new StringValue()};
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values)));
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values)));
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values))).isNull();
        Assertions.assertThat((boolean)this.format.reachedEnd()).isTrue();
    }

    @Test
    void readWithHeaderLineAndInvalidIntermediate() throws IOException {
        String fileContent = "colname-1|colname-2|some name 3|column four|\n123|abc|456|def|\ncolname-1|colname-2|some name 3|column four|\n987|xyz|654|pqr|\n";
        FileInputSplit split = DelimitedInputFormatTest.createTempFile("colname-1|colname-2|some name 3|column four|\n123|abc|456|def|\ncolname-1|colname-2|some name 3|column four|\n987|xyz|654|pqr|\n");
        Configuration parameters = new Configuration();
        this.format.setFieldDelimiter("|");
        this.format.setFieldTypesGeneric(new Class[]{IntValue.class, StringValue.class, IntValue.class, StringValue.class});
        this.format.setSkipFirstLineAsHeader(true);
        this.format.configure(parameters);
        this.format.open(split);
        Value[] values = new Value[]{new IntValue(), new StringValue(), new IntValue(), new StringValue()};
        Assertions.assertThat((Object[])((Object[])this.format.nextRecord(values)));
        Assertions.assertThatThrownBy(() -> {
            Value[] cfr_ignored_0 = (Value[])this.format.nextRecord(values);
        }).isInstanceOf(ParseException.class);
    }

    private FileInputSplit createTempDeflateFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp.deflate");
        tempFile.deleteOnExit();
        DataOutputStream dos = new DataOutputStream(new DeflaterOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0])));
        dos.writeBytes(content);
        dos.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    private FileInputSplit createTempGzipFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp.gz");
        tempFile.deleteOnExit();
        DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0])));
        dos.writeBytes(content);
        dos.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    private FileInputSplit createTempZStandardFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp.zst");
        tempFile.deleteOnExit();
        DataOutputStream dos = new DataOutputStream((OutputStream)new ZstdCompressorOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0])));
        dos.writeBytes(content);
        dos.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    private Value[] createIntValues(int num) {
        Value[] v = new Value[num];
        for (int i = 0; i < num; ++i) {
            v[i] = new IntValue();
        }
        return v;
    }

    private Value[] createLongValues(int num) {
        Value[] v = new Value[num];
        for (int i = 0; i < num; ++i) {
            v[i] = new LongValue();
        }
        return v;
    }

    private static final class TestCsvInputFormat
    extends GenericCsvInputFormat<Value[]> {
        private static final long serialVersionUID = 2653609265252951059L;

        private TestCsvInputFormat() {
        }

        public Value[] readRecord(Value[] target, byte[] bytes, int offset, int numBytes) {
            return this.parseRecord(target, bytes, offset, numBytes) ? target : null;
        }
    }
}

