/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.util.TestIOData;
import org.apache.flink.api.common.operators.util.TestNonRichInputFormat;
import org.apache.flink.api.common.operators.util.TestRichInputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericDataSourceBaseTest
implements Serializable {
    GenericDataSourceBaseTest() {
    }

    @Test
    void testDataSourcePlain() throws Exception {
        TestNonRichInputFormat in = new TestNonRichInputFormat();
        GenericDataSourceBase source = new GenericDataSourceBase((InputFormat)in, new OperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), "testSource");
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.disableObjectReuse();
        List resultMutableSafe = source.executeOnCollections(null, executionConfig);
        in.reset();
        executionConfig.enableObjectReuse();
        List resultRegular = source.executeOnCollections(null, executionConfig);
        Assertions.assertThat((List)resultMutableSafe).isEqualTo(Arrays.asList(TestIOData.NAMES));
        Assertions.assertThat((List)resultRegular).isEqualTo(Arrays.asList(TestIOData.NAMES));
    }

    @Test
    void testDataSourceWithRuntimeContext() throws Exception {
        TestRichInputFormat in = new TestRichInputFormat();
        GenericDataSourceBase source = new GenericDataSourceBase((InputFormat)in, new OperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), "testSource");
        HashMap accumulatorMap = new HashMap();
        HashMap cpTasks = new HashMap();
        TaskInfoImpl taskInfo = new TaskInfoImpl("test_source", 1, 0, 1, 0);
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.disableObjectReuse();
        Assertions.assertThat((boolean)in.hasBeenClosed()).isFalse();
        Assertions.assertThat((boolean)in.hasBeenOpened()).isFalse();
        List resultMutableSafe = source.executeOnCollections((RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
        Assertions.assertThat((boolean)in.hasBeenClosed()).isTrue();
        Assertions.assertThat((boolean)in.hasBeenOpened()).isTrue();
        in.reset();
        executionConfig.enableObjectReuse();
        Assertions.assertThat((boolean)in.hasBeenClosed()).isFalse();
        Assertions.assertThat((boolean)in.hasBeenOpened()).isFalse();
        List resultRegular = source.executeOnCollections((RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
        Assertions.assertThat((boolean)in.hasBeenClosed()).isTrue();
        Assertions.assertThat((boolean)in.hasBeenOpened()).isTrue();
        Assertions.assertThat((List)resultMutableSafe).isEqualTo(Arrays.asList(TestIOData.RICH_NAMES));
        Assertions.assertThat((List)resultRegular).isEqualTo(Arrays.asList(TestIOData.RICH_NAMES));
    }
}

