/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ValueStateDescriptorTest {
    ValueStateDescriptorTest() {
    }

    @Test
    void testHashCodeEquals() throws Exception {
        String name = "testName";
        ValueStateDescriptor original = new ValueStateDescriptor("testName", String.class);
        ValueStateDescriptor same = new ValueStateDescriptor("testName", String.class);
        ValueStateDescriptor sameBySerializer = new ValueStateDescriptor("testName", (TypeSerializer)StringSerializer.INSTANCE);
        Assertions.assertThat((Object)same).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)sameBySerializer).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
        Assertions.assertThat((Object)sameBySerializer).isEqualTo((Object)original);
        ValueStateDescriptor clone = (ValueStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
    }

    @Test
    void testVeryLargeDefaultValue() throws Exception {
        KryoSerializer serializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        byte[] data = new byte[200000];
        for (int i = 0; i < 200000; ++i) {
            data[i] = 65;
        }
        data[199000] = 0;
        String defaultValue = new String(data, ConfigConstants.DEFAULT_CHARSET);
        ValueStateDescriptor descr = new ValueStateDescriptor("testName", (TypeSerializer)serializer, (Object)defaultValue);
        Assertions.assertThat((String)descr.getName()).isEqualTo("testName");
        Assertions.assertThat((String)((String)descr.getDefaultValue())).isEqualTo(defaultValue);
        Assertions.assertThat((Object)descr.getSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getSerializer()).isEqualTo((Object)serializer);
        ValueStateDescriptor copy = (ValueStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)descr);
        Assertions.assertThat((String)copy.getName()).isEqualTo("testName");
        Assertions.assertThat((String)((String)copy.getDefaultValue())).isEqualTo(defaultValue);
        Assertions.assertThat((Object)copy.getSerializer()).isNotNull();
        Assertions.assertThat((Object)copy.getSerializer()).isEqualTo((Object)serializer);
    }
}

