/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.util.FlinkRuntimeException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeHintTest {
    TypeHintTest() {
    }

    @Test
    void testTypeInfoDirect() {
        TypeHint<String> stringInfo1 = new TypeHint<String>(){};
        TypeHint<String> stringInfo2 = new TypeHint<String>(){};
        Assertions.assertThat((Object)stringInfo1.getTypeInfo()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)stringInfo2).hasSameHashCodeAs((Object)stringInfo1);
        Assertions.assertThat((Object)stringInfo2).isEqualTo((Object)stringInfo1);
        Assertions.assertThat((Object)stringInfo2).hasToString(stringInfo1.toString());
        TypeHint<Tuple3<String, Double, Boolean>> generic = new TypeHint<Tuple3<String, Double, Boolean>>(){};
        TupleTypeInfo tupleInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO});
        Assertions.assertThat((Object)generic.getTypeInfo()).isEqualTo((Object)tupleInfo);
    }

    @Test
    <T> void testWithGenericParameter() {
        Assertions.assertThatThrownBy(() -> new TypeHint<T>(){}).isInstanceOf(FlinkRuntimeException.class);
        new TypeHint<List<T>>(){};
    }
}

