/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.util.FlinkRuntimeException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeInformationTest {
    TypeInformationTest() {
    }

    @Test
    void testOfClass() {
        Assertions.assertThat((Object)TypeInformation.of(String.class)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testOfGenericClassForFlink() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInformation.of(Tuple3.class)).isInstanceOf(FlinkRuntimeException.class)).hasMessageContaining("TypeHint");
    }

    @Test
    void testOfGenericClassForGenericType() {
        Assertions.assertThat((Object)TypeInformation.of(List.class)).isEqualTo((Object)new GenericTypeInfo(List.class));
    }

    @Test
    void testOfTypeHint() {
        Assertions.assertThat((Object)TypeInformation.of(String.class)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)TypeInformation.of((TypeHint)new TypeHint<String>(){})).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        TupleTypeInfo tupleInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO});
        Assertions.assertThat((Object)TypeInformation.of((TypeHint)new TypeHint<Tuple3<String, Double, Boolean>>(){})).isEqualTo((Object)tupleInfo);
    }
}

