/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.CyclicBarrier;
import java.util.function.Predicate;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.java.typeutils.runtime.NullableSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.testutils.CustomEqualityMatcher;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public abstract class SerializerTestBase<T> {
    private final DeeplyEqualsChecker checker;

    protected SerializerTestBase() {
        this.checker = new DeeplyEqualsChecker();
    }

    protected SerializerTestBase(DeeplyEqualsChecker checker) {
        this.checker = checker;
    }

    protected abstract TypeSerializer<T> createSerializer();

    protected abstract int getLength();

    protected abstract Class<T> getTypeClass();

    protected abstract T[] getTestData();

    protected boolean allowNullInstances(TypeSerializer<T> serializer) {
        return serializer.getClass().getName().endsWith("KryoSerializer");
    }

    @Test
    protected void testInstantiate() {
        TypeSerializer<T> serializer = this.getSerializer();
        Object instance = serializer.createInstance();
        if (instance == null && this.allowNullInstances(serializer)) {
            return;
        }
        ((ObjectAssert)Assertions.assertThat((Object)instance).as("The created instance must not be null.", new Object[0])).isNotNull();
        Class<T> type = this.getTypeClass();
        ((ClassAssert)Assertions.assertThat(type).as("The test is corrupt: type class is null.", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)instance).as("Type of the instantiated object is wrong.", new Object[0])).isInstanceOf(type);
    }

    @Test
    protected void testConfigSnapshotInstantiation() {
        TypeSerializerSnapshot configSnapshot = this.getSerializer().snapshotConfiguration();
        InstantiationUtil.instantiate(configSnapshot.getClass());
    }

    @Test
    protected void testSnapshotConfigurationAndReconfigure() throws Exception {
        TypeSerializer restoreSerializer;
        TypeSerializerSnapshot restoredConfig;
        byte[] serializedConfig;
        TypeSerializer<T> serializer = this.getSerializer();
        TypeSerializerSnapshot configSnapshot = serializer.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)configSnapshot);
            serializedConfig = out.toByteArray();
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            restoredConfig = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        TypeSerializerSchemaCompatibility strategy = this.getSerializer().snapshotConfiguration().resolveSchemaCompatibility(restoredConfig);
        if (strategy.isCompatibleAsIs()) {
            restoreSerializer = restoredConfig.restoreSerializer();
        } else if (strategy.isCompatibleWithReconfiguredSerializer()) {
            restoreSerializer = strategy.getReconfiguredSerializer();
        } else {
            throw new AssertionError((Object)("Unable to restore serializer with " + strategy));
        }
        Assertions.assertThat((Object)restoreSerializer).hasSameClassAs(serializer);
    }

    @Test
    void testGetLength() {
        int len = this.getLength();
        if (len == 0) {
            Fail.fail((String)"Broken serializer test base - zero length cannot be the expected length");
        }
        TypeSerializer<T> serializer = this.getSerializer();
        Assertions.assertThat((int)serializer.getLength()).isEqualTo(len);
    }

    @Test
    protected void testCopy() {
        this.testCopy(this.getSerializer());
    }

    protected void testCopy(TypeSerializer<T> serializer) {
        T[] testData;
        for (T datum : testData = this.getData()) {
            Object copy = serializer.copy(datum);
            SerializerTestBase.checkToString(copy);
            this.deepEquals("Copied element is not equal to the original element.", datum, copy);
        }
    }

    @Test
    void testCopyIntoNewElements() {
        T[] testData;
        TypeSerializer<T> serializer = this.getSerializer();
        for (T datum : testData = this.getData()) {
            Object copy = serializer.copy(datum, serializer.createInstance());
            SerializerTestBase.checkToString(copy);
            this.deepEquals("Copied element is not equal to the original element.", datum, copy);
        }
    }

    @Test
    void testCopyIntoReusedElements() {
        TypeSerializer<T> serializer = this.getSerializer();
        T[] testData = this.getData();
        Object target = serializer.createInstance();
        for (T datum : testData) {
            Object copy = serializer.copy(datum, target);
            SerializerTestBase.checkToString(copy);
            this.deepEquals("Copied element is not equal to the original element.", datum, copy);
            target = copy;
        }
    }

    @Test
    void testSerializeIndividually() throws IOException {
        T[] testData;
        TypeSerializer<T> serializer = this.getSerializer();
        for (T value : testData = this.getData()) {
            TestOutputView out = new TestOutputView();
            serializer.serialize(value, (DataOutputView)out);
            TestInputView in = out.getInputView();
            ((AbstractBooleanAssert)Assertions.assertThat((in.available() > 0 ? 1 : 0) != 0).as("No data available during deserialization.", new Object[0])).isTrue();
            Object deserialized = serializer.deserialize(serializer.createInstance(), (DataInputView)in);
            SerializerTestBase.checkToString(deserialized);
            this.deepEquals("Deserialized value if wrong.", value, deserialized);
            ((AbstractIntegerAssert)Assertions.assertThat((int)in.available()).as("Trailing data available after deserialization.", new Object[0])).isZero();
        }
    }

    @Test
    void testSerializeIndividuallyReusingValues() throws IOException {
        TypeSerializer<T> serializer = this.getSerializer();
        T[] testData = this.getData();
        Object reuseValue = serializer.createInstance();
        for (T value : testData) {
            TestOutputView out = new TestOutputView();
            serializer.serialize(value, (DataOutputView)out);
            TestInputView in = out.getInputView();
            ((AbstractBooleanAssert)Assertions.assertThat((in.available() > 0 ? 1 : 0) != 0).as("No data available during deserialization.", new Object[0])).isTrue();
            Object deserialized = serializer.deserialize(reuseValue, (DataInputView)in);
            SerializerTestBase.checkToString(deserialized);
            this.deepEquals("Deserialized value if wrong.", value, deserialized);
            ((AbstractIntegerAssert)Assertions.assertThat((int)in.available()).as("Trailing data available after deserialization.", new Object[0])).isZero();
            reuseValue = deserialized;
        }
    }

    @Test
    void testSerializeAsSequenceNoReuse() throws IOException {
        TypeSerializer<T> serializer = this.getSerializer();
        T[] testData = this.getData();
        TestOutputView out = new TestOutputView();
        for (T value : testData) {
            serializer.serialize(value, (DataOutputView)out);
        }
        TestInputView in = out.getInputView();
        int num = 0;
        while (in.available() > 0) {
            Object deserialized = serializer.deserialize((DataInputView)in);
            SerializerTestBase.checkToString(deserialized);
            this.deepEquals("Deserialized value if wrong.", testData[num], deserialized);
            ++num;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)num).as("Wrong number of elements deserialized.", new Object[0])).isEqualTo(testData.length);
    }

    @Test
    void testSerializeAsSequenceReusingValues() throws IOException {
        TypeSerializer<T> serializer = this.getSerializer();
        T[] testData = this.getData();
        TestOutputView out = new TestOutputView();
        for (T value : testData) {
            serializer.serialize(value, (DataOutputView)out);
        }
        TestInputView in = out.getInputView();
        Object reuseValue = serializer.createInstance();
        int num = 0;
        while (in.available() > 0) {
            Object deserialized = serializer.deserialize(reuseValue, (DataInputView)in);
            SerializerTestBase.checkToString(deserialized);
            this.deepEquals("Deserialized value if wrong.", testData[num], deserialized);
            reuseValue = deserialized;
            ++num;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)num).as("Wrong number of elements deserialized.", new Object[0])).isEqualTo(testData.length);
    }

    @Test
    void testSerializedCopyIndividually() throws IOException {
        T[] testData;
        TypeSerializer<T> serializer = this.getSerializer();
        for (T value : testData = this.getData()) {
            TestOutputView out = new TestOutputView();
            serializer.serialize(value, (DataOutputView)out);
            TestInputView source = out.getInputView();
            TestOutputView target = new TestOutputView();
            serializer.copy((DataInputView)source, (DataOutputView)target);
            TestInputView toVerify = target.getInputView();
            ((AbstractBooleanAssert)Assertions.assertThat((toVerify.available() > 0 ? 1 : 0) != 0).as("No data available copying.", new Object[0])).isTrue();
            Object deserialized = serializer.deserialize(serializer.createInstance(), (DataInputView)toVerify);
            SerializerTestBase.checkToString(deserialized);
            this.deepEquals("Deserialized value if wrong.", value, deserialized);
            ((AbstractIntegerAssert)Assertions.assertThat((int)toVerify.available()).as("Trailing data available after deserialization.", new Object[0])).isZero();
        }
    }

    @Test
    void testSerializedCopyAsSequence() throws IOException {
        TypeSerializer<T> serializer = this.getSerializer();
        T[] testData = this.getData();
        TestOutputView out = new TestOutputView();
        for (T value : testData) {
            serializer.serialize(value, (DataOutputView)out);
        }
        TestInputView source = out.getInputView();
        TestOutputView target = new TestOutputView();
        for (int i = 0; i < testData.length; ++i) {
            serializer.copy((DataInputView)source, (DataOutputView)target);
        }
        TestInputView toVerify = target.getInputView();
        int num = 0;
        while (toVerify.available() > 0) {
            Object deserialized = serializer.deserialize(serializer.createInstance(), (DataInputView)toVerify);
            SerializerTestBase.checkToString(deserialized);
            this.deepEquals("Deserialized value if wrong.", testData[num], deserialized);
            ++num;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)num).as("Wrong number of elements copied.", new Object[0])).isEqualTo(testData.length);
    }

    @Test
    void testSerializabilityAndEquals() {
        TypeSerializer ser2;
        TypeSerializer<T> ser1 = this.getSerializer();
        try {
            ser2 = (TypeSerializer)SerializationUtils.clone(ser1);
        }
        catch (SerializationException e) {
            Fail.fail((String)("The serializer is not serializable: " + (Object)((Object)e)));
            return;
        }
        ((ObjectAssert)Assertions.assertThat((Object)ser2).as("The copy of the serializer is not equal to the original one.", new Object[0])).isEqualTo(ser1);
        this.testCopy(ser2);
    }

    @Test
    void testNullability() {
        TypeSerializer<T> serializer = this.getSerializer();
        try {
            NullableSerializer.checkIfNullSupported(serializer);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace();
            Fail.fail((String)("Unexpected failure of null value handling: " + t.getMessage()));
        }
    }

    @Test
    void testDuplicate() throws Exception {
        int numThreads = 10;
        TypeSerializer<T> serializer = this.getSerializer();
        CyclicBarrier startLatch = new CyclicBarrier(10);
        ArrayList<SerializerRunner<T>> concurrentRunners = new ArrayList<SerializerRunner<T>>(10);
        Assertions.assertThat((Object)serializer.duplicate()).isEqualTo(serializer);
        T[] testData = this.getData();
        for (int i = 0; i < 10; ++i) {
            SerializerRunner<T> serializerRunner = new SerializerRunner<T>(startLatch, serializer.duplicate(), testData, 120L, this.checker);
            serializerRunner.start();
            concurrentRunners.add(serializerRunner);
        }
        for (SerializerRunner serializerRunner : concurrentRunners) {
            serializerRunner.join();
            serializerRunner.checkResult();
        }
    }

    private void deepEquals(String message, T should, T is) {
        ((ObjectAssert)Assertions.assertThat(is).as(message, new Object[0])).matches((Predicate)CustomEqualityMatcher.deeplyEquals(should).withChecker(this.checker));
    }

    protected TypeSerializer<T> getSerializer() {
        TypeSerializer<T> serializer = this.createSerializer();
        if (serializer == null) {
            throw new RuntimeException("Test case corrupt. Returns null as serializer.");
        }
        return serializer;
    }

    private T[] getData() {
        T[] data = this.getTestData();
        if (data == null) {
            throw new RuntimeException("Test case corrupt. Returns null as test data.");
        }
        return data;
    }

    private static <T> void checkToString(T value) {
        if (value != null) {
            value.toString();
        }
    }

    private static final class TestInputView
    extends DataInputStream
    implements DataInputView {
        public TestInputView(byte[] data) {
            super(new ByteArrayInputStream(data));
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            while (numBytes > 0) {
                int skipped = this.skipBytes(numBytes);
                numBytes -= skipped;
            }
        }
    }

    static class SerializerRunner<T>
    extends Thread {
        final CyclicBarrier allReadyBarrier;
        final TypeSerializer<T> serializer;
        final T[] testData;
        final long durationLimitMillis;
        Throwable failure;
        final DeeplyEqualsChecker checker;

        SerializerRunner(CyclicBarrier allReadyBarrier, TypeSerializer<T> serializer, T[] testData, long testTargetDurationMillis, DeeplyEqualsChecker checker) {
            this.allReadyBarrier = allReadyBarrier;
            this.serializer = serializer;
            this.testData = testData;
            this.durationLimitMillis = testTargetDurationMillis;
            this.checker = checker;
            this.failure = null;
        }

        @Override
        public void run() {
            DataInputDeserializer dataInputDeserializer = new DataInputDeserializer();
            DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(128);
            try {
                this.allReadyBarrier.await();
                long endTimeNanos = System.nanoTime() + this.durationLimitMillis * 1000000L;
                block2: while (true) {
                    T[] TArray = this.testData;
                    int n = TArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block2;
                        T testItem = TArray[n2];
                        this.serializer.serialize(testItem, (DataOutputView)dataOutputSerializer);
                        dataInputDeserializer.setBuffer(dataOutputSerializer.getSharedBuffer(), 0, dataOutputSerializer.length());
                        Object serdeTestItem = this.serializer.deserialize((DataInputView)dataInputDeserializer);
                        Object copySerdeTestItem = this.serializer.copy(serdeTestItem);
                        dataOutputSerializer.clear();
                        ((ObjectAssert)Assertions.assertThat((Object)copySerdeTestItem).as("Serialization/Deserialization cycle resulted in an object that are not equal to the original.", new Object[0])).matches((Predicate)CustomEqualityMatcher.deeplyEquals(testItem).withChecker(this.checker));
                        if (System.nanoTime() >= endTimeNanos) {
                            return;
                        }
                        ++n2;
                    }
                    break;
                }
            }
            catch (Throwable ex) {
                this.failure = ex;
                return;
            }
        }

        void checkResult() throws Exception {
            if (this.failure != null) {
                if (this.failure instanceof AssertionError) {
                    throw (AssertionError)((Object)this.failure);
                }
                throw (Exception)this.failure;
            }
        }
    }

    private static final class TestOutputView
    extends DataOutputStream
    implements DataOutputView {
        public TestOutputView() {
            super(new ByteArrayOutputStream(4096));
        }

        public TestInputView getInputView() {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
            return new TestInputView(baos.toByteArray());
        }

        public void skipBytesToWrite(int numBytes) throws IOException {
            for (int i = 0; i < numBytes; ++i) {
                this.write(0);
            }
        }

        public void write(DataInputView source, int numBytes) throws IOException {
            byte[] buffer = new byte[numBytes];
            source.readFully(buffer);
            this.write(buffer);
        }
    }
}

