/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnumSerializerTest {
    EnumSerializerTest() {
    }

    @Test
    void testPublicEnum() {
        this.testEnumSerializer(new PrivateEnum[]{PrivateEnum.ONE, PrivateEnum.TWO, PrivateEnum.THREE});
    }

    @Test
    void testPrivateEnum() {
        this.testEnumSerializer(new PublicEnum[]{PublicEnum.FOO, PublicEnum.BAR, PublicEnum.PETER, PublicEnum.NATHANIEL, PublicEnum.EMMA, PublicEnum.PAULA});
    }

    @Test
    void testEmptyEnum() {
        Assertions.assertThatThrownBy(() -> new EnumSerializer(EmptyEnum.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testReconfiguration() {
        Enum[] mockPreviousOrder = new PublicEnum[]{PublicEnum.BAR, PublicEnum.PAULA, PublicEnum.NATHANIEL};
        EnumSerializer serializer = new EnumSerializer(PublicEnum.class);
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO))).isEqualTo(PublicEnum.FOO.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR))).isEqualTo(PublicEnum.BAR.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER))).isEqualTo(PublicEnum.PETER.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL))).isEqualTo(PublicEnum.NATHANIEL.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA))).isEqualTo(PublicEnum.EMMA.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA))).isEqualTo(PublicEnum.PAULA.ordinal());
        EnumSerializer.EnumSerializerSnapshot serializerSnapshot = new EnumSerializer.EnumSerializerSnapshot(PublicEnum.class, mockPreviousOrder);
        TypeSerializerSchemaCompatibility compatibility = serializer.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)serializerSnapshot);
        Assertions.assertThat((boolean)compatibility.isCompatibleWithReconfiguredSerializer()).isTrue();
        PublicEnum[] expectedOrder = new PublicEnum[]{PublicEnum.BAR, PublicEnum.PAULA, PublicEnum.NATHANIEL, PublicEnum.FOO, PublicEnum.PETER, PublicEnum.EMMA};
        EnumSerializer configuredSerializer = (EnumSerializer)compatibility.getReconfiguredSerializer();
        int i = 0;
        for (PublicEnum constant : expectedOrder) {
            Assertions.assertThat((int)((Integer)configuredSerializer.getValueToOrdinal().get((Object)constant))).isEqualTo(i);
            ++i;
        }
        Assertions.assertThat((Object[])configuredSerializer.getValues()).isEqualTo((Object)expectedOrder);
    }

    @Test
    void testConfigurationSnapshotSerialization() throws Exception {
        TypeSerializerSnapshot restoredConfig;
        byte[] serializedConfig;
        EnumSerializer serializer = new EnumSerializer(PublicEnum.class);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)serializer.snapshotConfiguration());
            serializedConfig = out.toByteArray();
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            restoredConfig = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        TypeSerializerSchemaCompatibility compatResult = serializer.snapshotConfiguration().resolveSchemaCompatibility(restoredConfig);
        Assertions.assertThat((boolean)compatResult.isCompatibleAsIs()).isTrue();
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO))).isEqualTo(PublicEnum.FOO.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR))).isEqualTo(PublicEnum.BAR.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER))).isEqualTo(PublicEnum.PETER.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL))).isEqualTo(PublicEnum.NATHANIEL.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA))).isEqualTo(PublicEnum.EMMA.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA))).isEqualTo(PublicEnum.PAULA.ordinal());
        Assertions.assertThat((Object[])serializer.getValues()).isEqualTo((Object)PublicEnum.values());
    }

    @Test
    void testSerializeEnumSerializer() throws Exception {
        EnumSerializer serializer = new EnumSerializer(PublicEnum.class);
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO))).isEqualTo(PublicEnum.FOO.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR))).isEqualTo(PublicEnum.BAR.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER))).isEqualTo(PublicEnum.PETER.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL))).isEqualTo(PublicEnum.NATHANIEL.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA))).isEqualTo(PublicEnum.EMMA.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA))).isEqualTo(PublicEnum.PAULA.ordinal());
        Assertions.assertThat((Object[])serializer.getValues()).isEqualTo((Object)PublicEnum.values());
        byte[] serializedSerializer = InstantiationUtil.serializeObject((Object)serializer);
        serializer = (EnumSerializer)InstantiationUtil.deserializeObject((byte[])serializedSerializer, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO))).isEqualTo(PublicEnum.FOO.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR))).isEqualTo(PublicEnum.BAR.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER))).isEqualTo(PublicEnum.PETER.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL))).isEqualTo(PublicEnum.NATHANIEL.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA))).isEqualTo(PublicEnum.EMMA.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA))).isEqualTo(PublicEnum.PAULA.ordinal());
        Assertions.assertThat((Object[])serializer.getValues()).isEqualTo((Object)PublicEnum.values());
    }

    @Test
    void testSerializeReconfiguredEnumSerializer() {
        Enum[] mockPreviousOrder = new PublicEnum[]{PublicEnum.BAR, PublicEnum.PAULA, PublicEnum.NATHANIEL};
        EnumSerializer serializer = new EnumSerializer(PublicEnum.class);
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO))).isEqualTo(PublicEnum.FOO.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR))).isEqualTo(PublicEnum.BAR.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER))).isEqualTo(PublicEnum.PETER.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL))).isEqualTo(PublicEnum.NATHANIEL.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA))).isEqualTo(PublicEnum.EMMA.ordinal());
        Assertions.assertThat((int)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA))).isEqualTo(PublicEnum.PAULA.ordinal());
        EnumSerializer.EnumSerializerSnapshot serializerSnapshot = new EnumSerializer.EnumSerializerSnapshot(PublicEnum.class, mockPreviousOrder);
        TypeSerializerSchemaCompatibility compatibility = serializer.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)serializerSnapshot);
        Assertions.assertThat((boolean)compatibility.isCompatibleWithReconfiguredSerializer()).isTrue();
        PublicEnum[] expectedOrder = new PublicEnum[]{PublicEnum.BAR, PublicEnum.PAULA, PublicEnum.NATHANIEL, PublicEnum.FOO, PublicEnum.PETER, PublicEnum.EMMA};
        EnumSerializer configuredSerializer = (EnumSerializer)compatibility.getReconfiguredSerializer();
        int i = 0;
        for (PublicEnum constant : expectedOrder) {
            Assertions.assertThat((int)((Integer)configuredSerializer.getValueToOrdinal().get((Object)constant))).isEqualTo(i);
            ++i;
        }
        Assertions.assertThat((Object[])configuredSerializer.getValues()).isEqualTo((Object)expectedOrder);
    }

    @SafeVarargs
    public final <T extends Enum<T>> void testEnumSerializer(T ... data) {
        Class<?> clazz = data.getClass().getComponentType();
        SerializerTestInstance tester = new SerializerTestInstance<T>((TypeSerializer)new EnumSerializer(clazz), (Class)clazz, 4, (Enum[])data){};
        tester.testAll();
    }

    private static enum PrivateEnum {
        ONE,
        TWO,
        THREE;

    }

    public static enum EmptyEnum {

    }

    public static enum PublicEnum {
        FOO,
        BAR,
        PETER,
        NATHANIEL,
        EMMA,
        PAULA;

    }
}

