/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.assertj.core.api.Condition;

class MapSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Map<Integer, String>, Map<Integer, String>> {
    private static final String SPEC_NAME = "map-serializer";

    MapSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, MapSerializerSetup.class, MapSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class MapSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Map<Integer, String>> {
        @Override
        public TypeSerializer<Map<Integer, String>> createUpgradedSerializer() {
            return new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public Condition<Map<Integer, String>> testDataCondition() {
            HashMap<Integer, String> data = new HashMap<Integer, String>(3);
            for (int i = 0; i < 3; ++i) {
                data.put(i, String.valueOf(i));
            }
            return new Condition(data::equals, "is equal to " + data, new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<Map<Integer, String>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class MapSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Map<Integer, String>> {
        @Override
        public TypeSerializer<Map<Integer, String>> createPriorSerializer() {
            return new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public Map<Integer, String> createTestData() {
            HashMap<Integer, String> data = new HashMap<Integer, String>(3);
            for (int i = 0; i < 3; ++i) {
                data.put(i, String.valueOf(i));
            }
            return data;
        }
    }
}

