/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SecurityOptionsTest {
    SecurityOptionsTest() {
    }

    @Test
    void checkEnableSSL() {
        Configuration oldConf = new Configuration();
        oldConf.set(SecurityOptions.SSL_ENABLED, (Object)true);
        Assertions.assertThat((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)oldConf)).isTrue();
        Assertions.assertThat((boolean)SecurityOptions.isRestSSLEnabled((Configuration)oldConf)).isTrue();
        Configuration newOptions = new Configuration();
        newOptions.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)true);
        newOptions.set(SecurityOptions.SSL_REST_ENABLED, (Object)false);
        Assertions.assertThat((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)newOptions)).isTrue();
        Assertions.assertThat((boolean)SecurityOptions.isRestSSLEnabled((Configuration)newOptions)).isFalse();
        Configuration precedence = new Configuration();
        precedence.set(SecurityOptions.SSL_ENABLED, (Object)true);
        precedence.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)false);
        precedence.set(SecurityOptions.SSL_REST_ENABLED, (Object)false);
        Assertions.assertThat((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)precedence)).isFalse();
        Assertions.assertThat((boolean)SecurityOptions.isRestSSLEnabled((Configuration)precedence)).isFalse();
    }

    @Test
    void checkEnableRestSSLAuthentication() {
        Configuration noSSLOptions = new Configuration();
        noSSLOptions.set(SecurityOptions.SSL_REST_ENABLED, (Object)false);
        noSSLOptions.set(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, (Object)true);
        Assertions.assertThat((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)noSSLOptions)).isFalse();
        Configuration defaultOptions = new Configuration();
        defaultOptions.set(SecurityOptions.SSL_REST_ENABLED, (Object)true);
        Assertions.assertThat((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)defaultOptions)).isFalse();
        Configuration options = new Configuration();
        options.set(SecurityOptions.SSL_REST_ENABLED, (Object)true);
        options.set(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, (Object)true);
        Assertions.assertThat((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)options)).isTrue();
    }
}

