/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OperationsOnFreedSegmentTest {
    private static final int PAGE_SIZE = (int)(Math.random() * 10000.0 + 1000.0);

    OperationsOnFreedSegmentTest() {
    }

    @Test
    void testSingleSegmentOperationsHeapSegment() throws Exception {
        for (MemorySegment segment : OperationsOnFreedSegmentTest.createTestSegments()) {
            this.testOpsOnFreedSegment(segment);
        }
    }

    @Test
    void testCompare() {
        MemorySegment aliveHeap = MemorySegmentFactory.wrap((byte[])new byte[PAGE_SIZE]);
        MemorySegment aliveOffHeap = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)PAGE_SIZE);
        MemorySegment freedHeap = MemorySegmentFactory.wrap((byte[])new byte[PAGE_SIZE]);
        MemorySegment freedOffHeap = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)PAGE_SIZE);
        freedHeap.free();
        freedOffHeap.free();
        MemorySegment[] alive = new MemorySegment[]{aliveHeap, aliveOffHeap};
        MemorySegment[] free = new MemorySegment[]{freedHeap, freedOffHeap};
        for (MemorySegment seg1 : alive) {
            for (MemorySegment seg2 : free) {
                this.testCompare(seg1, seg2);
            }
        }
        for (MemorySegment seg1 : free) {
            for (MemorySegment seg2 : alive) {
                this.testCompare(seg1, seg2);
            }
        }
        for (MemorySegment seg1 : free) {
            for (MemorySegment seg2 : free) {
                this.testCompare(seg1, seg2);
            }
        }
    }

    @Test
    void testCopyTo() {
        OperationsOnFreedSegmentTest.testAliveVsFree(this::testCopy);
    }

    @Test
    void testSwap() {
        OperationsOnFreedSegmentTest.testAliveVsFree(this::testSwap);
    }

    private static void testAliveVsFree(BiConsumer<MemorySegment, MemorySegment> testOperation) {
        MemorySegment[] free;
        MemorySegment[] alive = OperationsOnFreedSegmentTest.createTestSegments();
        for (MemorySegment segment : free = OperationsOnFreedSegmentTest.createTestSegments()) {
            segment.free();
        }
        for (MemorySegment seg1 : alive) {
            for (MemorySegment seg2 : free) {
                testOperation.accept(seg1, seg2);
            }
        }
        for (MemorySegment seg1 : free) {
            for (MemorySegment seg2 : alive) {
                testOperation.accept(seg1, seg2);
            }
        }
        for (MemorySegment seg1 : free) {
            for (MemorySegment seg2 : free) {
                testOperation.accept(seg1, seg2);
            }
        }
    }

    private static MemorySegment[] createTestSegments() {
        MemorySegment heap = MemorySegmentFactory.wrap((byte[])new byte[PAGE_SIZE]);
        MemorySegment offHeap = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)PAGE_SIZE);
        MemorySegment offHeapUnsafe = MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)PAGE_SIZE);
        return new MemorySegment[]{heap, offHeap, offHeapUnsafe};
    }

    private void testOpsOnFreedSegment(MemorySegment segment) throws Exception {
        segment.free();
        Assertions.assertThat((boolean)segment.isFreed()).isTrue();
        Assertions.assertThatThrownBy(() -> segment.get(0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(-1)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.get(1)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(-segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MAX_VALUE)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MIN_VALUE)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(0, (byte)0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(-1, (byte)0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(1, (byte)0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(segment.size(), (byte)0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(-segment.size(), (byte)0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, (byte)0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, (byte)0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.getBoolean(0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.getBoolean(-1)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getBoolean(1)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.getBoolean(segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.getBoolean(-segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getBoolean(Integer.MAX_VALUE)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.getBoolean(Integer.MIN_VALUE)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.putBoolean(0, true)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.putBoolean(-1, true)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putBoolean(1, true)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.putBoolean(segment.size(), true)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.putBoolean(-segment.size(), true)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putBoolean(Integer.MAX_VALUE, true)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.putBoolean(Integer.MIN_VALUE, true)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.getChar(0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(-1)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getChar(1)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(segment.size())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(-segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getChar(Integer.MAX_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(Integer.MIN_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(0, 'a')).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(-1, 'a')).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putChar(1, 'a')).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(segment.size(), 'a')).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(-segment.size(), 'a')).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putChar(Integer.MAX_VALUE, 'a')).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(Integer.MIN_VALUE, 'a')).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(-1)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getShort(1)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(segment.size())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(-segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getShort(Integer.MAX_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(Integer.MIN_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(0, (short)42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(-1, (short)42)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putShort(1, (short)42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(segment.size(), (short)42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(-segment.size(), (short)42)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putShort(Integer.MAX_VALUE, (short)42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(Integer.MIN_VALUE, (short)42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(-1)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getInt(1)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(segment.size())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(-segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getInt(Integer.MAX_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(Integer.MIN_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(0, 42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(-1, 42)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putInt(1, 42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(segment.size(), 42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(-segment.size(), 42)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putInt(Integer.MAX_VALUE, 42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(Integer.MIN_VALUE, 42)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(-1)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getLong(1)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(segment.size())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(-segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getLong(Integer.MAX_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(Integer.MIN_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(0, 42L)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(-1, 42L)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putLong(1, 42L)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(segment.size(), 42L)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(-segment.size(), 42L)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putLong(Integer.MAX_VALUE, 42L)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(Integer.MIN_VALUE, 42L)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(-1)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getFloat(1)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(segment.size())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(-segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getFloat(Integer.MAX_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(Integer.MIN_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(0, 42.0f)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(-1, 42.0f)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putFloat(1, 42.0f)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(segment.size(), 42.0f)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(-segment.size(), 42.0f)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putFloat(Integer.MAX_VALUE, 42.0f)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(Integer.MIN_VALUE, 42.0f)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(-1)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getDouble(1)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(segment.size())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(-segment.size())).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.getDouble(Integer.MAX_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(Integer.MIN_VALUE)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(0, 42.0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(-1, 42.0)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putDouble(1, 42.0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(segment.size(), 42.0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(-segment.size(), 42.0)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.putDouble(Integer.MAX_VALUE, 42.0)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(Integer.MIN_VALUE, 42.0)).isInstanceOf(IllegalStateException.class);
        byte[] array = new byte[55];
        Assertions.assertThatThrownBy(() -> segment.get(0, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(-1, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.get(1, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(segment.size(), array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(-segment.size(), array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MAX_VALUE, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MIN_VALUE, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(0, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(-1, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(1, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(segment.size(), array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(-segment.size(), array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, array, 3, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        for (ByteBuffer bbuf : new ByteBuffer[]{ByteBuffer.allocate(55), ByteBuffer.allocateDirect(55)}) {
            Assertions.assertThatThrownBy(() -> segment.get(0, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
            Assertions.assertThatThrownBy(() -> segment.get(-1, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
            Assertions.assertThatThrownBy(() -> segment.get(1, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
            Assertions.assertThatThrownBy(() -> segment.get(segment.size(), bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
            Assertions.assertThatThrownBy(() -> segment.get(-segment.size(), bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
            Assertions.assertThatThrownBy(() -> segment.get(Integer.MAX_VALUE, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
            Assertions.assertThatThrownBy(() -> segment.get(Integer.MIN_VALUE, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
            Assertions.assertThatThrownBy(() -> segment.put(0, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
            Assertions.assertThatThrownBy(() -> segment.put(-1, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
            Assertions.assertThatThrownBy(() -> segment.put(1, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
            Assertions.assertThatThrownBy(() -> segment.put(segment.size(), bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
            Assertions.assertThatThrownBy(() -> segment.put(-segment.size(), bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
            Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
            Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, bbuf, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        }
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[100]));
        DataOutputStream dout = new DataOutputStream(new ByteArrayOutputStream());
        Assertions.assertThatThrownBy(() -> segment.get(dout, 0, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(dout, -1, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.get(dout, 1, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(dout, segment.size(), 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.get(dout, -segment.size(), 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.get(dout, Integer.MAX_VALUE, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.get(dout, Integer.MIN_VALUE, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(din, 0, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(din, -1, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(din, 1, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(din, segment.size(), 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> segment.put(din, -segment.size(), 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(din, Integer.MAX_VALUE, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
        Assertions.assertThatThrownBy(() -> segment.put(din, Integer.MIN_VALUE, 17)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class, IndexOutOfBoundsException.class});
    }

    private void testCompare(MemorySegment seg1, MemorySegment seg2) {
        int[] offsetsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] lengthsToTest = new int[]{1, seg1.size(), Integer.MAX_VALUE};
        for (int off1 : offsetsToTest) {
            for (int off2 : offsetsToTest) {
                for (int len : lengthsToTest) {
                    Assertions.assertThatThrownBy(() -> seg1.compare(seg2, off1, off2, len)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class, NullPointerException.class});
                }
            }
        }
    }

    private void testCopy(MemorySegment seg1, MemorySegment seg2) {
        int[] offsetsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] lengthsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (int off1 : offsetsToTest) {
            for (int off2 : offsetsToTest) {
                for (int len : lengthsToTest) {
                    Assertions.assertThatThrownBy(() -> seg1.copyTo(off1, seg2, off2, len)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class, NullPointerException.class});
                }
            }
        }
    }

    private void testSwap(MemorySegment seg1, MemorySegment seg2) {
        int[] offsetsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] lengthsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        byte[] swapBuffer = new byte[seg1.size()];
        for (int off1 : offsetsToTest) {
            for (int off2 : offsetsToTest) {
                for (int len : lengthsToTest) {
                    Assertions.assertThatThrownBy(() -> seg1.swapBytes(swapBuffer, seg2, off1, off2, len)).isInstanceOfAny(new Class[]{IllegalStateException.class, IndexOutOfBoundsException.class, NullPointerException.class});
                }
            }
        }
    }
}

