/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.FileUtils;
import org.assertj.core.api.Assertions;

public class TestingUtils {
    private static final UUID ZERO_UUID = new UUID(0L, 0L);
    public static final Duration TESTING_DURATION = Duration.ofMinutes(2L);
    public static final Time TIMEOUT = Time.minutes((long)1L);
    public static final Duration DEFAULT_ASK_TIMEOUT = Duration.ofSeconds(200L);

    public static Time infiniteTime() {
        return Time.milliseconds((long)Integer.MAX_VALUE);
    }

    public static Duration infiniteDuration() {
        return Duration.ofDays(365L);
    }

    public static TestExecutorExtension<ScheduledExecutorService> defaultExecutorExtension() {
        return new TestExecutorExtension(Executors::newSingleThreadScheduledExecutor);
    }

    public static TestExecutorResource<ScheduledExecutorService> defaultExecutorResource() {
        return new TestExecutorResource(Executors::newSingleThreadScheduledExecutor);
    }

    public static UUID zeroUUID() {
        return ZERO_UUID;
    }

    public static File getClassFile(Class<?> cls) {
        String className = String.format("%s.class", cls.getSimpleName());
        URL url = cls.getResource(className);
        Assertions.assertThat((URL)url).isNotNull();
        return new File(url.getPath());
    }

    public static File getFileFromTargetDir(Class<?> cls, Predicate<Path> fileFilter) throws IOException {
        String pathStr = cls.getProtectionDomain().getCodeSource().getLocation().getPath();
        Path mvnTargetDir = Paths.get(pathStr, new String[0]).getParent();
        Collection jarPaths = FileUtils.listFilesInDirectory((Path)mvnTargetDir, fileFilter);
        Assertions.assertThat((Collection)jarPaths).isNotEmpty();
        return ((Path)jarPaths.iterator().next()).toFile();
    }
}

