/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.RowUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RowTest {
    RowTest() {
    }

    @Test
    void testRowNamed() {
        Row row = Row.withNames((RowKind)RowKind.DELETE);
        row.setField("a", (Object)42);
        row.setField("b", (Object)true);
        row.setField("c", null);
        Assertions.assertThat((Collection)row.getFieldNames(false)).contains((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Comparable)row.getKind()).isEqualTo((Object)RowKind.DELETE);
        Assertions.assertThat((Object)row.getField("a")).isEqualTo((Object)42);
        Assertions.assertThat((Boolean)((Boolean)row.getField("b"))).isTrue();
        Assertions.assertThat((Object)row.getField("c")).isNull();
        Assertions.assertThat((Object)row).hasToString("-D{a=42, b=true, c=null}");
        row.setField("a", (Object)13);
        row.setField("c", (Object)"Hello");
        Assertions.assertThat((Object)row.getField("a")).isEqualTo((Object)13);
        Assertions.assertThat((Boolean)((Boolean)row.getField("b"))).isTrue();
        Assertions.assertThat((Object)row.getField("c")).isEqualTo((Object)"Hello");
        Row otherRow1 = Row.withNames((RowKind)RowKind.DELETE);
        otherRow1.setField("a", (Object)13);
        otherRow1.setField("b", (Object)true);
        otherRow1.setField("c", (Object)"Hello");
        Assertions.assertThat((Object)row).hasSameHashCodeAs((Object)otherRow1);
        Assertions.assertThat((Object)row).isEqualTo((Object)otherRow1);
        Row otherRow2 = Row.withNames((RowKind)RowKind.DELETE);
        otherRow2.setField("a", (Object)13);
        otherRow2.setField("b", (Object)false);
        otherRow2.setField("c", (Object)"Hello");
        Assertions.assertThat((Object)row).doesNotHaveSameHashCodeAs((Object)otherRow2);
        Assertions.assertThat((Object)row).isNotEqualTo((Object)otherRow2);
        row.clear();
        Assertions.assertThat((int)row.getArity()).isZero();
        Assertions.assertThat((Collection)row.getFieldNames(false)).isEmpty();
        Assertions.assertThat((Object)row).hasToString("-D{}");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> row.setField(0, (Object)13)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("not supported in name-based field mode");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> row.getField(0)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("not supported in name-based field mode");
    }

    @Test
    void testRowPositioned() {
        Row row = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        row.setField(0, (Object)42);
        row.setField(1, (Object)true);
        row.setField(2, null);
        Assertions.assertThat((Collection)row.getFieldNames(false)).isNull();
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Comparable)row.getKind()).isEqualTo((Object)RowKind.DELETE);
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)42);
        Assertions.assertThat((Boolean)((Boolean)row.getField(1))).isTrue();
        Assertions.assertThat((Object)row.getField(2)).isNull();
        Assertions.assertThat((Object)row).hasToString("-D[42, true, null]");
        row.setField(0, (Object)13);
        row.setField(2, (Object)"Hello");
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)13);
        Assertions.assertThat((Boolean)((Boolean)row.getField(1))).isTrue();
        Assertions.assertThat((Object)row.getField(2)).isEqualTo((Object)"Hello");
        Row otherRow1 = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        otherRow1.setField(0, (Object)13);
        otherRow1.setField(1, (Object)true);
        otherRow1.setField(2, (Object)"Hello");
        Assertions.assertThat((Object)row).hasSameHashCodeAs((Object)otherRow1);
        Assertions.assertThat((Object)row).isEqualTo((Object)otherRow1);
        Row otherRow2 = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        otherRow2.setField(0, (Object)13);
        otherRow2.setField(1, (Object)false);
        otherRow2.setField(2, (Object)"Hello");
        Assertions.assertThat((Object)row).doesNotHaveSameHashCodeAs((Object)otherRow2);
        Assertions.assertThat((Object)row).isNotEqualTo((Object)otherRow2);
        row.clear();
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Collection)row.getFieldNames(false)).isNull();
        Assertions.assertThat((Object)row).hasToString("-D[null, null, null]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> row.setField("a", (Object)13)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("not supported in position-based field mode");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> row.getField("a")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("not supported in position-based field mode");
    }

    @Test
    void testRowNamedPositioned() {
        LinkedHashMap<String, Integer> positionByName = new LinkedHashMap<String, Integer>();
        positionByName.put("a", 0);
        positionByName.put("b", 1);
        positionByName.put("c", 2);
        Row row = RowUtils.createRowWithNamedPositions((RowKind)RowKind.DELETE, (Object[])new Object[3], positionByName);
        row.setField(0, (Object)42);
        row.setField("b", (Object)true);
        row.setField(2, null);
        Assertions.assertThat((Collection)row.getFieldNames(false)).isNull();
        Assertions.assertThat((Collection)row.getFieldNames(true)).contains((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Comparable)row.getKind()).isEqualTo((Object)RowKind.DELETE);
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)42);
        Assertions.assertThat((Boolean)((Boolean)row.getField(1))).isTrue();
        Assertions.assertThat((Object)row.getField("c")).isNull();
        Assertions.assertThat((Object)row).hasToString("-D[42, true, null]");
        row.setField("a", (Object)13);
        row.setField(2, (Object)"Hello");
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)13);
        Assertions.assertThat((Boolean)((Boolean)row.getField("b"))).isTrue();
        Assertions.assertThat((Object)row.getField(2)).isEqualTo((Object)"Hello");
        Row otherRow1 = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        otherRow1.setField(0, (Object)13);
        otherRow1.setField(1, (Object)true);
        otherRow1.setField(2, (Object)"Hello");
        Assertions.assertThat((Object)row).hasSameHashCodeAs((Object)otherRow1);
        Assertions.assertThat((Object)row).isEqualTo((Object)otherRow1);
        Row otherRow2 = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        otherRow2.setField(0, (Object)13);
        otherRow2.setField(1, (Object)false);
        otherRow2.setField(2, (Object)"Hello");
        Assertions.assertThat((Object)row).doesNotHaveSameHashCodeAs((Object)otherRow2);
        Assertions.assertThat((Object)row).isNotEqualTo((Object)otherRow2);
        row.clear();
        Assertions.assertThat((int)row.getArity()).isEqualTo(3);
        Assertions.assertThat((Collection)row.getFieldNames(true)).contains((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((Object)row).hasToString("-D[null, null, null]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> row.setField("DOES_NOT_EXIST", (Object)13)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unknown field name 'DOES_NOT_EXIST'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> row.getField("DOES_NOT_EXIST")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unknown field name 'DOES_NOT_EXIST'");
    }

    @Test
    void testRowOf() {
        Row row1 = Row.of((Object[])new Object[]{1, "hello", null, Tuple2.of((Object)2L, (Object)"hi"), true});
        Row row2 = Row.withPositions((int)5);
        row2.setField(0, (Object)1);
        row2.setField(1, (Object)"hello");
        row2.setField(2, null);
        row2.setField(3, (Object)new Tuple2((Object)2L, (Object)"hi"));
        row2.setField(4, (Object)true);
        Assertions.assertThat((Object)row2).isEqualTo((Object)row1);
    }

    @Test
    void testRowCopyPositioned() {
        Row row = Row.withPositions((int)5);
        row.setField(0, (Object)1);
        row.setField(1, (Object)"hello");
        row.setField(2, null);
        row.setField(3, (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField(4, (Object)"hello world");
        Row copy = Row.copy((Row)row);
        Assertions.assertThat((Object)copy).isEqualTo((Object)row);
        Assertions.assertThat((Object)copy).isNotSameAs((Object)row);
    }

    @Test
    void testRowCopyNamed() {
        Row row = Row.withNames();
        row.setField("a", (Object)1);
        row.setField("b", (Object)"hello");
        row.setField("c", null);
        row.setField("d", (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField("e", (Object)"hello world");
        Row copy = Row.copy((Row)row);
        Assertions.assertThat((Object)copy).isEqualTo((Object)row);
        Assertions.assertThat((Object)copy).isNotSameAs((Object)row);
    }

    @Test
    void testRowProjectPositioned() {
        Row row = Row.withPositions((int)5);
        row.setField(0, (Object)1);
        row.setField(1, (Object)"hello");
        row.setField(2, null);
        row.setField(3, (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField(4, (Object)"hello world");
        Row projected = Row.project((Row)row, (int[])new int[]{0, 2, 4});
        Row expected = Row.withPositions((int)3);
        expected.setField(0, (Object)1);
        expected.setField(1, null);
        expected.setField(2, (Object)"hello world");
        Assertions.assertThat((Object)projected).isEqualTo((Object)expected);
    }

    @Test
    void testRowProjectNamed() {
        Row row = Row.withNames();
        row.setField("a", (Object)1);
        row.setField("b", (Object)"hello");
        row.setField("c", null);
        row.setField("d", (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField("e", (Object)"hello world");
        Row projected = Row.project((Row)row, (String[])new String[]{"a", "c", "e"});
        Row expected = Row.withNames();
        expected.setField("a", (Object)1);
        expected.setField("c", null);
        expected.setField("e", (Object)"hello world");
        Assertions.assertThat((Object)projected).isEqualTo((Object)expected);
    }

    @Test
    void testRowJoinPositioned() {
        Row row1 = new Row(2);
        row1.setField(0, (Object)1);
        row1.setField(1, (Object)"hello");
        Row row2 = new Row(2);
        row2.setField(0, null);
        row2.setField(1, (Object)new Tuple2((Object)2, (Object)"hi"));
        Row row3 = new Row(1);
        row3.setField(0, (Object)"hello world");
        Row joinedRow = Row.join((Row)row1, (Row[])new Row[]{row2, row3});
        Row expected = new Row(5);
        expected.setField(0, (Object)1);
        expected.setField(1, (Object)"hello");
        expected.setField(2, null);
        expected.setField(3, (Object)new Tuple2((Object)2, (Object)"hi"));
        expected.setField(4, (Object)"hello world");
        Assertions.assertThat((Object)joinedRow).isEqualTo((Object)expected);
    }

    @Test
    void testDeepEqualsAndHashCodePositioned() {
        HashMap<String, byte[]> originalMap = new HashMap<String, byte[]>();
        originalMap.put("k1", new byte[]{1, 2, 3});
        originalMap.put("k2", new byte[]{3, 4, 6});
        Row originalRow = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3}, Arrays.asList(1, null, 3), originalMap, Collections.emptyMap(), new int[][]{{1, 2, 3}, new int[0], {4, 5}}, 1.44});
        Assertions.assertThat((Object)originalRow).isEqualTo((Object)originalRow);
        Assertions.assertThat((Object)originalRow).hasSameHashCodeAs((Object)originalRow);
        Row row = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3}, Arrays.asList(1, null, 3), originalMap, Collections.emptyMap(), new int[][]{{1, 2, 3}, new int[0], {4, 5}}, 1.44});
        Assertions.assertThat((Object)originalRow).isEqualTo((Object)row);
        Assertions.assertThat((Object)originalRow).hasSameHashCodeAs((Object)row);
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("k1", new byte[]{1, 2, 3});
        map.put("k2", new byte[]{3, 4, 6});
        Row row2 = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3, 99}, Arrays.asList(1, null, 3), map, Collections.emptyMap(), new int[][]{{1, 2, 3}, new int[0], {4, 5}}, 1.44});
        Assertions.assertThat((Object)originalRow).isNotEqualTo((Object)row2);
        Assertions.assertThat((Object)originalRow).doesNotHaveSameHashCodeAs((Object)row2);
        map = new HashMap();
        map.put("k1", new byte[]{1, 2, 2});
        map.put("k2", new byte[]{3, 4, 6});
        row2 = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3}, Arrays.asList(1, null, 3), map, Collections.emptyMap(), new int[][]{{1, 2, 3}, new int[0], {4, 5}}, 1.44});
        Assertions.assertThat((Object)originalRow).isNotEqualTo((Object)row2);
        Assertions.assertThat((Object)originalRow).doesNotHaveSameHashCodeAs((Object)row2);
        map = new HashMap();
        map.put("k1", new byte[]{1, 2, 3});
        map.put("k2", new byte[]{3, 4, 6});
        row2 = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3}, Arrays.asList(1, null, 3), map, Collections.emptyMap(), new Integer[][]{{1, 2, 3}, new Integer[0], {4, 5}}, 1.44});
        Assertions.assertThat((Object)originalRow).isNotEqualTo((Object)row2);
        Assertions.assertThat((Object)originalRow).doesNotHaveSameHashCodeAs((Object)row2);
    }

    @Test
    void testDeepEqualsCodeNamed() {
        Row named = Row.withNames((RowKind)RowKind.DELETE);
        named.setField("a", (Object)12);
        named.setField("c", (Object)true);
        LinkedHashMap<String, Integer> positionByName = new LinkedHashMap<String, Integer>();
        positionByName.put("a", 0);
        positionByName.put("b", 1);
        positionByName.put("c", 2);
        Row namedPositioned = RowUtils.createRowWithNamedPositions((RowKind)RowKind.DELETE, (Object[])new Object[3], positionByName);
        namedPositioned.setField("a", (Object)12);
        namedPositioned.setField("b", null);
        namedPositioned.setField("c", (Object)true);
        Assertions.assertThat((Object)named).isEqualTo((Object)namedPositioned);
        Assertions.assertThat((Object)namedPositioned).isEqualTo((Object)named);
        named.setField("b", (Object)"Hello");
        Assertions.assertThat((Object)named).isNotEqualTo((Object)namedPositioned);
        Assertions.assertThat((Object)namedPositioned).isNotEqualTo((Object)named);
    }

    @Test
    void testDeepToString() {
        Row row = Row.withNames((RowKind)RowKind.UPDATE_BEFORE);
        row.setField("a", (Object)1);
        row.setField("b", (Object)"hello");
        row.setField("c", null);
        row.setField("d", (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField("e", (Object)"hello world");
        row.setField("f", (Object)new int[][]{{1}, null, {3, 4}});
        row.setField("g", (Object)new Boolean[][]{{true}, null, {false, false}});
        HashMap<String, Integer[]> map = new HashMap<String, Integer[]>();
        map.put("a", new Integer[]{1, 2, 3, 4});
        map.put("b", new Integer[0]);
        map.put("c", null);
        row.setField("h", map);
        Assertions.assertThat((String)row.toString()).isEqualTo("-U{a=1, b=hello, c=null, d=(2,hi), e=hello world, f=[[1], null, [3, 4]], g=[[true], null, [false, false]], h={a=[1, 2, 3, 4], b=[], c=null}}");
    }
}

