/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.testutils.logging.LoggerAuditingExtension;
import org.apache.flink.util.MdcUtils;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.logging.log4j.core.LogEvent;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

class MdcUtilsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MdcUtilsTest.class);
    private static final Runnable LOGGING_RUNNABLE = () -> LOGGER.info("ignore");
    @RegisterExtension
    public final LoggerAuditingExtension loggerExtension = new LoggerAuditingExtension(MdcUtilsTest.class, Level.DEBUG);

    MdcUtilsTest() {
    }

    @Test
    void testJobIDAsContext() {
        JobID jobID = new JobID();
        Assertions.assertThat((Map)MdcUtils.asContextData((JobID)jobID)).isEqualTo(Collections.singletonMap("flink-job-id", jobID.toHexString()));
    }

    @Test
    void testMdcCloseableAddsJobId() throws Exception {
        this.assertJobIDLogged((ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)jobID -> {
            try (MdcUtils.MdcCloseable ignored = MdcUtils.withContext((Map)MdcUtils.asContextData((JobID)jobID));){
                LOGGER.warn("ignore");
            }
        }));
    }

    @Test
    void testMdcCloseableRemovesJobId() {
        JobID jobID = new JobID();
        MdcUtils.MdcCloseable ignored = MdcUtils.withContext((Map)MdcUtils.asContextData((JobID)jobID));
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
        LOGGER.warn("with-job");
        this.assertJobIdLogged(null);
    }

    @Test
    void testWrapRunnable() throws Exception {
        this.assertJobIDLogged((ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)jobID -> MdcUtils.wrapRunnable((Map)MdcUtils.asContextData((JobID)jobID), (Runnable)LOGGING_RUNNABLE).run()));
    }

    @Test
    void testWrapCallable() throws Exception {
        this.assertJobIDLogged((ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)jobID -> MdcUtils.wrapCallable((Map)MdcUtils.asContextData((JobID)jobID), () -> {
            LOGGER.info("ignore");
            return null;
        }).call()));
    }

    @Test
    void testScopeExecutor() throws Exception {
        this.assertJobIDLogged((ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)jobID -> MdcUtils.scopeToJob((JobID)jobID, (Executor)Executors.directExecutor()).execute(LOGGING_RUNNABLE)));
    }

    @Test
    void testScopeExecutorService() throws Exception {
        this.assertJobIDLogged((ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)jobID -> MdcUtils.scopeToJob((JobID)jobID, (ExecutorService)Executors.newDirectExecutorService()).submit(LOGGING_RUNNABLE).get()));
    }

    @Test
    void testScopeScheduledExecutorService() throws Exception {
        ScheduledExecutorService ses = java.util.concurrent.Executors.newSingleThreadScheduledExecutor();
        try {
            this.assertJobIDLogged((ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)jobID -> MdcUtils.scopeToJob((JobID)jobID, (ScheduledExecutorService)ses).schedule(LOGGING_RUNNABLE, 1L, TimeUnit.MILLISECONDS).get()));
        }
        finally {
            ses.shutdownNow();
        }
    }

    private void assertJobIDLogged(ThrowingConsumer<JobID, Exception> action) throws Exception {
        JobID jobID = new JobID();
        action.accept((Object)jobID);
        this.assertJobIdLogged(jobID);
    }

    private void assertJobIdLogged(JobID jobId) {
        AbstractObjectAssert extracting = ((ObjectAssert)Assertions.assertThat((List)this.loggerExtension.getEvents()).singleElement()).extracting(LogEvent::getContextData).extracting(m -> m.getValue("flink-job-id"));
        if (jobId == null) {
            extracting.isNull();
        } else {
            extracting.isEqualTo((Object)jobId.toHexString());
        }
    }
}

