/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntMaximum;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IntMaximumTest {
    IntMaximumTest() {
    }

    @Test
    void testGet() {
        IntMaximum max = new IntMaximum();
        Assertions.assertThat((int)max.getLocalValue()).isEqualTo(Integer.MIN_VALUE);
    }

    @Test
    void testResetLocal() {
        IntMaximum max = new IntMaximum();
        int value = 13;
        max.add(value);
        Assertions.assertThat((int)max.getLocalValue()).isEqualTo(value);
        max.resetLocal();
        Assertions.assertThat((int)max.getLocalValue()).isEqualTo(Integer.MIN_VALUE);
    }

    @Test
    void testAdd() {
        IntMaximum max = new IntMaximum();
        max.add(1234);
        max.add(9876);
        max.add(-987);
        max.add(-123);
        Assertions.assertThat((int)max.getLocalValue()).isEqualTo(9876);
    }

    @Test
    void testMerge() {
        IntMaximum max1 = new IntMaximum();
        max1.add(1234);
        IntMaximum max2 = new IntMaximum();
        max2.add(5678);
        max2.merge((Accumulator)max1);
        Assertions.assertThat((int)max2.getLocalValue()).isEqualTo(5678);
        max1.merge((Accumulator)max2);
        Assertions.assertThat((int)max1.getLocalValue()).isEqualTo(5678);
    }

    @Test
    void testClone() {
        IntMaximum max = new IntMaximum();
        int value = 42;
        max.add(value);
        IntMaximum clone = max.clone();
        Assertions.assertThat((int)clone.getLocalValue()).isEqualTo(value);
    }
}

