/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.flink.api.common.io.BinaryInputFormat;
import org.apache.flink.api.common.io.BlockInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Record;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BinaryInputFormatTest {
    @TempDir
    private Path tempDir;

    BinaryInputFormatTest() {
    }

    @Test
    void testCreateInputSplitsWithOneFile() throws IOException {
        int blockInfoSize = new BlockInfo().getInfoSize();
        int blockSize = blockInfoSize + 8;
        int numBlocks = 3;
        File tempFile = this.createBinaryInputFile("test_create_input_splits_with_one_file", blockSize, 3);
        Configuration config = new Configuration();
        config.setLong("input.block_size", (long)(blockSize + 10));
        MyBinaryInputFormat inputFormat = new MyBinaryInputFormat();
        inputFormat.setFilePath(tempFile.toURI().toString());
        inputFormat.setBlockSize(blockSize);
        inputFormat.configure(config);
        Object[] inputSplits = inputFormat.createInputSplits(3);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])inputSplits).as("Returns requested numbers of splits.", new Object[0])).hasSize(3);
        ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[0].getLength()).as("1. split should have block size length.", new Object[0])).isEqualTo((long)blockSize);
        ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[1].getLength()).as("2. split should have block size length.", new Object[0])).isEqualTo((long)blockSize);
        ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[2].getLength()).as("3. split should have block size length.", new Object[0])).isEqualTo((long)blockSize);
    }

    @Test
    void testCreateInputSplitsWithMultipleFiles() throws IOException {
        int blockInfoSize = new BlockInfo().getInfoSize();
        int blockSize = blockInfoSize + 8;
        int numBlocks1 = 3;
        int numBlocks2 = 5;
        File tempFile1 = this.createBinaryInputFile("binary_input_format_test", blockSize, 3);
        File tempFile2 = this.createBinaryInputFile("binary_input_format_test_2", blockSize, 5);
        String pathFile1 = tempFile1.toURI().toString();
        String pathFile2 = tempFile2.toURI().toString();
        MyBinaryInputFormat inputFormat = new MyBinaryInputFormat();
        inputFormat.setFilePaths(new String[]{pathFile1, pathFile2});
        inputFormat.setBlockSize(blockSize);
        int numBlocksTotal = 8;
        Object[] inputSplits = inputFormat.createInputSplits(8);
        int numSplitsFile1 = 0;
        int numSplitsFile2 = 0;
        ((ObjectArrayAssert)Assertions.assertThat((Object[])inputSplits).as("Returns requested numbers of splits.", new Object[0])).hasSize(8);
        for (int i = 0; i < inputSplits.length; ++i) {
            ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[i].getLength()).as("%d. split should have block size length.", new Object[]{i})).isEqualTo((long)blockSize);
            if (inputSplits[i].getPath().toString().equals(pathFile1)) {
                ++numSplitsFile1;
                continue;
            }
            if (inputSplits[i].getPath().toString().equals(pathFile2)) {
                ++numSplitsFile2;
                continue;
            }
            Fail.fail((String)"Split does not belong to any input file.");
        }
        Assertions.assertThat((int)numSplitsFile1).isEqualTo(3);
        Assertions.assertThat((int)numSplitsFile2).isEqualTo(5);
    }

    @Test
    void testGetStatisticsNonExistingFiles() {
        MyBinaryInputFormat format = new MyBinaryInputFormat();
        format.setFilePaths(new String[]{"file:///some/none/existing/directory/", "file:///another/none/existing/directory/"});
        format.configure(new Configuration());
        BinaryInputFormat.SequentialStatistics stats = format.getStatistics(null);
        ((ObjectAssert)Assertions.assertThat((Object)stats).as("The file statistics should be null.", new Object[0])).isNull();
    }

    @Test
    void testGetStatisticsMultiplePaths() throws IOException {
        int blockInfoSize = new BlockInfo().getInfoSize();
        int blockSize = blockInfoSize + 8;
        int numBlocks1 = 3;
        int numBlocks2 = 5;
        File tempFile = this.createBinaryInputFile("binary_input_format_test", blockSize, 3);
        File tempFile2 = this.createBinaryInputFile("binary_input_format_test_2", blockSize, 5);
        MyBinaryInputFormat inputFormat = new MyBinaryInputFormat();
        inputFormat.setFilePaths(new String[]{tempFile.toURI().toString(), tempFile2.toURI().toString()});
        inputFormat.setBlockSize(blockSize);
        BinaryInputFormat.SequentialStatistics stats = inputFormat.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size statistics is wrong", new Object[0])).isEqualTo((long)blockSize * 8L);
    }

    @Test
    void testCreateInputSplitsWithEmptySplit() throws IOException {
        int blockInfoSize = new BlockInfo().getInfoSize();
        int blockSize = blockInfoSize + 8;
        int numBlocks = 3;
        int minNumSplits = 5;
        File tempFile = this.createBinaryInputFile("test_create_input_splits_with_empty_split", blockSize, 3);
        Configuration config = new Configuration();
        config.setLong("input.block_size", (long)(blockSize + 10));
        MyBinaryInputFormat inputFormat = new MyBinaryInputFormat();
        inputFormat.setFilePath(tempFile.toURI().toString());
        inputFormat.setBlockSize(blockSize);
        inputFormat.configure(config);
        Object[] inputSplits = inputFormat.createInputSplits(5);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])inputSplits).as("Returns requested numbers of splits.", new Object[0])).hasSize(5);
        ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[0].getLength()).as("1. split should have block size length.", new Object[0])).isEqualTo((long)blockSize);
        ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[1].getLength()).as("2. split should have block size length.", new Object[0])).isEqualTo((long)blockSize);
        ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[2].getLength()).as("3. split should have block size length.", new Object[0])).isEqualTo((long)blockSize);
        ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[3].getLength()).as("4. split should be an empty split.", new Object[0])).isZero();
        ((AbstractLongAssert)Assertions.assertThat((long)inputSplits[4].getLength()).as("5. split should be an empty split.", new Object[0])).isZero();
    }

    private File createBinaryInputFile(String fileName, int blockSize, int numBlocks) throws IOException {
        File tempFile = TempDirUtils.newFile((Path)this.tempDir, (String)fileName);
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
            for (int i = 0; i < blockSize * numBlocks; ++i) {
                fileOutputStream.write(new byte[]{1});
            }
        }
        return tempFile;
    }

    private static final class MyBinaryInputFormat
    extends BinaryInputFormat<Record> {
        private static final long serialVersionUID = 1L;

        private MyBinaryInputFormat() {
        }

        protected Record deserialize(Record record, DataInputView dataInput) {
            return record;
        }

        public boolean supportsMultiPaths() {
            return true;
        }
    }
}

