/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.time.Time;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StateTtlConfigTest {
    StateTtlConfigTest() {
    }

    @Test
    void testStateTtlConfigBuildWithoutCleanupInBackground() {
        StateTtlConfig ttlConfig = StateTtlConfig.newBuilder((Time)Time.seconds((long)1L)).disableCleanupInBackground().build();
        Assertions.assertThat((Object)ttlConfig.getCleanupStrategies()).isNotNull();
        StateTtlConfig.CleanupStrategies cleanupStrategies = ttlConfig.getCleanupStrategies();
        StateTtlConfig.IncrementalCleanupStrategy incrementalCleanupStrategy = cleanupStrategies.getIncrementalCleanupStrategy();
        StateTtlConfig.RocksdbCompactFilterCleanupStrategy rocksdbCleanupStrategy = cleanupStrategies.getRocksdbCompactFilterCleanupStrategy();
        Assertions.assertThat((boolean)cleanupStrategies.isCleanupInBackground()).isFalse();
        Assertions.assertThat((Object)incrementalCleanupStrategy).isNull();
        Assertions.assertThat((Object)rocksdbCleanupStrategy).isNull();
        Assertions.assertThat((boolean)cleanupStrategies.inRocksdbCompactFilter()).isFalse();
    }

    @Test
    void testStateTtlConfigBuildWithCleanupInBackground() {
        StateTtlConfig ttlConfig = StateTtlConfig.newBuilder((Time)Time.seconds((long)1L)).build();
        Assertions.assertThat((Object)ttlConfig.getCleanupStrategies()).isNotNull();
        StateTtlConfig.CleanupStrategies cleanupStrategies = ttlConfig.getCleanupStrategies();
        StateTtlConfig.IncrementalCleanupStrategy incrementalCleanupStrategy = cleanupStrategies.getIncrementalCleanupStrategy();
        StateTtlConfig.RocksdbCompactFilterCleanupStrategy rocksdbCleanupStrategy = cleanupStrategies.getRocksdbCompactFilterCleanupStrategy();
        Assertions.assertThat((boolean)cleanupStrategies.isCleanupInBackground()).isTrue();
        Assertions.assertThat((Object)incrementalCleanupStrategy).isNotNull();
        Assertions.assertThat((Object)rocksdbCleanupStrategy).isNotNull();
        Assertions.assertThat((boolean)cleanupStrategies.inRocksdbCompactFilter()).isTrue();
        Assertions.assertThat((int)incrementalCleanupStrategy.getCleanupSize()).isEqualTo(5);
        Assertions.assertThat((boolean)incrementalCleanupStrategy.runCleanupForEveryRecord()).isFalse();
        Assertions.assertThat((long)rocksdbCleanupStrategy.getQueryTimeAfterNumEntries()).isEqualTo(1000L);
        Assertions.assertThat((Duration)rocksdbCleanupStrategy.getPeriodicCompactionTime()).isEqualTo((Object)Duration.ofDays(30L));
    }

    @Test
    void testStateTtlConfigBuildWithNonPositiveCleanupIncrementalSize() {
        List<Integer> illegalCleanUpSizes = Arrays.asList(0, -2);
        for (Integer illegalCleanUpSize : illegalCleanUpSizes) {
            Assertions.assertThatThrownBy(() -> StateTtlConfig.newBuilder((Time)Time.seconds((long)1L)).cleanupIncrementally(illegalCleanUpSize.intValue(), false).build()).isInstanceOf(IllegalArgumentException.class);
        }
    }
}

