/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.ClassRelocator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.api.common.typeutils.base.TestEnum;
import org.assertj.core.api.Condition;

class EnumSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<TestEnum, TestEnum> {
    private static final String SPEC_NAME = "enum-serializer";

    EnumSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, EnumSerializerSetup.class, EnumSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("enum-serializerreconfig", flinkVersion, EnumSerializerReconfigSetup.class, EnumSerializerReconfigVerifier.class));
        return testSpecifications;
    }

    private static Condition<? extends TypeSerializer<TestEnum>> enumSerializerWith(TestEnum[] expectedEnumValues) {
        return new Condition(value -> Arrays.equals(value.getValues(), (Object[])expectedEnumValues), "", new Object[0]);
    }

    public static final class EnumSerializerReconfigVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<EnumAfter> {
        @Override
        public TypeSerializer<EnumAfter> createUpgradedSerializer() {
            return new EnumSerializer(EnumAfter.class);
        }

        @Override
        public Condition<EnumAfter> testDataCondition() {
            return new Condition(value -> value == EnumAfter.EMMA, "is EMMA", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<EnumAfter>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleWithReconfiguredSerializer();
        }

        @ClassRelocator.RelocateClass(value="TestEnumSerializerReconfig")
        public static enum EnumAfter {
            FOO,
            BAR,
            PETER,
            PAULA,
            NATHANIEL,
            EMMA;

        }
    }

    public static final class EnumSerializerReconfigSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<EnumBefore> {
        @Override
        public TypeSerializer<EnumBefore> createPriorSerializer() {
            return new EnumSerializer(EnumBefore.class);
        }

        @Override
        public EnumBefore createTestData() {
            return EnumBefore.EMMA;
        }

        @ClassRelocator.RelocateClass(value="TestEnumSerializerReconfig")
        public static enum EnumBefore {
            FOO,
            BAR,
            PETER,
            NATHANIEL,
            EMMA,
            PAULA;

        }
    }

    public static final class EnumSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TestEnum> {
        @Override
        public TypeSerializer<TestEnum> createUpgradedSerializer() {
            return new EnumSerializer(TestEnum.class);
        }

        @Override
        public Condition<TestEnum> testDataCondition() {
            return new Condition(value -> value == TestEnum.EMMA, "is EMMA", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<TestEnum>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class EnumSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TestEnum> {
        @Override
        public TypeSerializer<TestEnum> createPriorSerializer() {
            return new EnumSerializer(TestEnum.class);
        }

        @Override
        public TestEnum createTestData() {
            return TestEnum.EMMA;
        }
    }
}

