/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.typeutils.runtime.NullableSerializer;
import org.assertj.core.api.Condition;

class NullableSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Long, Long> {
    NullableSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("nullable-padded-serializer", flinkVersion, NullablePaddedSerializerSetup.class, NullablePaddedSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("nullable-not-padded-serializer", flinkVersion, NullableNotPaddedSerializerSetup.class, NullableNotPaddedSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class NullableNotPaddedSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Long> {
        @Override
        public TypeSerializer<Long> createUpgradedSerializer() {
            return NullableSerializer.wrap((TypeSerializer)LongSerializer.INSTANCE, (boolean)false);
        }

        @Override
        public Condition<Long> testDataCondition() {
            return new Condition(Objects::isNull, "value is null", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<Long>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class NullableNotPaddedSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Long> {
        @Override
        public TypeSerializer<Long> createPriorSerializer() {
            return NullableSerializer.wrap((TypeSerializer)LongSerializer.INSTANCE, (boolean)false);
        }

        @Override
        public Long createTestData() {
            return null;
        }
    }

    public static final class NullablePaddedSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Long> {
        @Override
        public TypeSerializer<Long> createUpgradedSerializer() {
            return NullableSerializer.wrap((TypeSerializer)LongSerializer.INSTANCE, (boolean)true);
        }

        @Override
        public Condition<Long> testDataCondition() {
            return new Condition(Objects::isNull, "value is null", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<Long>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class NullablePaddedSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Long> {
        @Override
        public TypeSerializer<Long> createPriorSerializer() {
            return NullableSerializer.wrap((TypeSerializer)LongSerializer.INSTANCE, (boolean)true);
        }

        @Override
        public Long createTestData() {
            return null;
        }
    }
}

