/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Condition;

@VisibleForTesting
public class RowSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Row, Row> {
    @Override
    public Collection<FlinkVersion> getMigrationVersions() {
        ArrayList<FlinkVersion> testVersions = new ArrayList<FlinkVersion>();
        testVersions.add(FlinkVersion.v1_10);
        testVersions.addAll(super.getMigrationVersions());
        return testVersions;
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        return Collections.singletonList(new TypeSerializerUpgradeTestBase.TestSpecification("row-serializer", flinkVersion, RowSerializerSetup.class, RowSerializerVerifier.class));
    }

    public static TypeSerializer<Row> createRowSerializer() {
        RowTypeInfo rowTypeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        return rowTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
    }

    public static final class RowSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Row> {
        @Override
        public TypeSerializer<Row> createUpgradedSerializer() {
            return RowSerializerUpgradeTest.createRowSerializer();
        }

        @Override
        public Condition<Row> testDataCondition() {
            Row row = new Row(RowKind.INSERT, 4);
            row.setField(0, null);
            row.setField(1, (Object)42L);
            row.setField(2, (Object)"My string.");
            row.setField(3, null);
            return new Condition(arg_0 -> ((Row)row).equals(arg_0), "a row with kind INSERT and fields [null, 42, 'My string.', null]", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<Row>> schemaCompatibilityCondition(FlinkVersion version) {
            if (version.isNewerVersionThan(FlinkVersion.v1_10)) {
                return TypeSerializerConditions.isCompatibleAsIs();
            }
            return TypeSerializerConditions.isCompatibleAfterMigration();
        }
    }

    public static final class RowSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Row> {
        @Override
        public TypeSerializer<Row> createPriorSerializer() {
            return RowSerializerUpgradeTest.createRowSerializer();
        }

        @Override
        public Row createTestData() {
            Row row = new Row(4);
            row.setField(0, null);
            row.setField(1, (Object)42L);
            row.setField(2, (Object)"My string.");
            row.setField(3, null);
            return row;
        }
    }
}

