/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.shaded.guava31.com.google.common.collect.Sets;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ConfigOptionTest {
    ConfigOptionTest() {
    }

    @Test
    void testDeprecationFlagForDeprecatedKeys() {
        ConfigOption optionWithDeprecatedKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(new String[]{"deprecated1", "deprecated2"});
        Assertions.assertThat((boolean)optionWithDeprecatedKeys.hasFallbackKeys()).isTrue();
        for (FallbackKey fallbackKey : optionWithDeprecatedKeys.fallbackKeys()) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fallbackKey.isDeprecated()).as("deprecated key not flagged as deprecated", new Object[0])).isTrue();
        }
    }

    @Test
    void testDeprecationFlagForFallbackKeys() {
        ConfigOption optionWithFallbackKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withFallbackKeys(new String[]{"fallback1", "fallback2"});
        Assertions.assertThat((boolean)optionWithFallbackKeys.hasFallbackKeys()).isTrue();
        for (FallbackKey fallbackKey : optionWithFallbackKeys.fallbackKeys()) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fallbackKey.isDeprecated()).as("falback key flagged as deprecated", new Object[0])).isFalse();
        }
    }

    @Test
    void testDeprecationFlagForMixedAlternativeKeys() {
        ConfigOption optionWithMixedKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(new String[]{"deprecated1", "deprecated2"}).withFallbackKeys(new String[]{"fallback1", "fallback2"});
        ArrayList<String> fallbackKeys = new ArrayList<String>(2);
        ArrayList<String> deprecatedKeys = new ArrayList<String>(2);
        for (FallbackKey alternativeKey : optionWithMixedKeys.fallbackKeys()) {
            if (alternativeKey.isDeprecated()) {
                deprecatedKeys.add(alternativeKey.getKey());
                continue;
            }
            fallbackKeys.add(alternativeKey.getKey());
        }
        Assertions.assertThat(fallbackKeys).hasSize(2);
        Assertions.assertThat(deprecatedKeys).hasSize(2);
        Assertions.assertThat(fallbackKeys).containsExactlyInAnyOrder((Object[])new String[]{"fallback1", "fallback2"});
        Assertions.assertThat(deprecatedKeys).containsExactlyInAnyOrder((Object[])new String[]{"deprecated1", "deprecated2"});
    }

    @Test
    void testDeprecationForDeprecatedKeys() {
        String[] deprecatedKeys = new String[]{"deprecated1", "deprecated2"};
        HashSet<String> expectedDeprecatedKeys = new HashSet<String>(Arrays.asList(deprecatedKeys));
        ConfigOption optionWithDeprecatedKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(deprecatedKeys).withFallbackKeys(new String[]{"fallback1"});
        Assertions.assertThat((boolean)optionWithDeprecatedKeys.hasDeprecatedKeys()).isTrue();
        Assertions.assertThat((Collection)Sets.newHashSet((Iterable)optionWithDeprecatedKeys.deprecatedKeys())).isEqualTo(expectedDeprecatedKeys);
    }

    @Test
    void testNoDeprecationForFallbackKeysWithoutDeprecated() {
        ConfigOption optionWithFallbackKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withFallbackKeys(new String[]{"fallback1"});
        Assertions.assertThat((boolean)optionWithFallbackKeys.hasDeprecatedKeys()).isFalse();
    }
}

