/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.core.plugin.PluginConfig;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableMap;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PluginConfigTest {
    @TempDir
    private static Path tempFolder;
    private static Map<String, String> oldEnvVariables;

    PluginConfigTest() {
    }

    @BeforeAll
    static void setup() {
        oldEnvVariables = System.getenv();
    }

    @AfterEach
    void teardown() {
        if (oldEnvVariables != null) {
            CommonTestUtils.setEnv(oldEnvVariables, (boolean)true);
        }
    }

    @Test
    void getPluginsDir_existingDirectory_returnsDirectoryFile() throws IOException {
        File pluginsDirectory = TempDirUtils.newFolder((Path)tempFolder);
        ImmutableMap envVariables = ImmutableMap.of((Object)"FLINK_PLUGINS_DIR", (Object)pluginsDirectory.getAbsolutePath());
        CommonTestUtils.setEnv((Map)envVariables);
        Assertions.assertThat((Optional)PluginConfig.getPluginsDir()).contains((Object)pluginsDirectory);
    }

    @Test
    void getPluginsDir_nonExistingDirectory_returnsEmpty() throws IOException {
        ImmutableMap envVariables = ImmutableMap.of((Object)"FLINK_PLUGINS_DIR", (Object)new File(TempDirUtils.newFolder((Path)tempFolder).getAbsoluteFile(), "should_not_exist").getAbsolutePath());
        CommonTestUtils.setEnv((Map)envVariables);
        Assertions.assertThat((Optional)PluginConfig.getPluginsDir()).isNotPresent();
    }
}

