/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Optional;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExceptionUtilsTest {
    ExceptionUtilsTest() {
    }

    @Test
    void testStringifyNullException() {
        Assertions.assertThat((String)"(null)").isEqualTo(ExceptionUtils.stringifyException(null));
    }

    @Test
    void testJvmFatalError() {
        Assertions.assertThat((boolean)ExceptionUtils.isJvmFatalError((Throwable)new Error())).isFalse();
        Assertions.assertThat((boolean)ExceptionUtils.isJvmFatalError((Throwable)new LinkageError())).isFalse();
        Assertions.assertThat((boolean)ExceptionUtils.isJvmFatalError((Throwable)new InternalError())).isTrue();
        Assertions.assertThat((boolean)ExceptionUtils.isJvmFatalError((Throwable)new UnknownError())).isTrue();
    }

    @Test
    void testRethrowFatalError() {
        Assertions.assertThatThrownBy(() -> ExceptionUtils.rethrowIfFatalError((Throwable)new InternalError())).isInstanceOf(InternalError.class);
        ExceptionUtils.rethrowIfFatalError((Throwable)new NoClassDefFoundError());
    }

    @Test
    void testFindThrowableByType() {
        Assertions.assertThat((Optional)ExceptionUtils.findThrowable((Throwable)new RuntimeException(new IllegalStateException()), IllegalStateException.class)).isPresent();
    }

    @Test
    void testExceptionStripping() {
        FlinkException expectedException = new FlinkException("test exception");
        Throwable strippedException = ExceptionUtils.stripException((Throwable)new RuntimeException(new RuntimeException((Throwable)expectedException)), RuntimeException.class);
        Assertions.assertThat((Throwable)strippedException).isEqualTo((Object)expectedException);
    }

    @Test
    void testInvalidExceptionStripping() {
        FlinkException expectedException = new FlinkException((Throwable)new RuntimeException((Throwable)new FlinkException("inner exception")));
        Throwable strippedException = ExceptionUtils.stripException((Throwable)expectedException, RuntimeException.class);
        Assertions.assertThat((Throwable)strippedException).isEqualTo((Object)expectedException);
    }

    @Test
    void testTryEnrichTaskExecutorErrorCanHandleNullValueWithoutCausingException() {
        ExceptionUtils.tryEnrichOutOfMemoryError(null, (String)"", (String)"", (String)"");
    }

    @Test
    void testUpdateDetailMessageOfBasicThrowable() {
        OutOfMemoryError rootThrowable = new OutOfMemoryError("old message");
        ExceptionUtils.updateDetailMessage((Throwable)rootThrowable, t -> "new message");
        Assertions.assertThat((String)rootThrowable.getMessage()).isEqualTo("new message");
    }

    @Test
    void testUpdateDetailMessageOfRelevantThrowableAsCause() {
        IllegalArgumentException oomCause = new IllegalArgumentException("another message deep down in the cause tree");
        Throwable oom = new OutOfMemoryError("old message").initCause(oomCause);
        oom.setStackTrace(new StackTraceElement[]{new StackTraceElement("class", "method", "file", 1)});
        oom.addSuppressed(new NullPointerException());
        IllegalStateException rootThrowable = new IllegalStateException("another message", oom);
        ExceptionUtils.updateDetailMessage((Throwable)rootThrowable, t -> t.getClass().equals(OutOfMemoryError.class) ? "new message" : null);
        Assertions.assertThat((Throwable)rootThrowable.getCause()).isSameAs((Object)oom);
        Assertions.assertThat((String)rootThrowable.getCause().getMessage()).isEqualTo("new message");
        Assertions.assertThat((Object[])rootThrowable.getCause().getStackTrace()).isEqualTo((Object)oom.getStackTrace());
        Assertions.assertThat((Object[])rootThrowable.getCause().getSuppressed()).isEqualTo((Object)oom.getSuppressed());
        Assertions.assertThat((Throwable)rootThrowable.getCause().getCause()).isSameAs((Object)oomCause);
    }

    @Test
    void testUpdateDetailMessageWithoutRelevantThrowable() {
        IllegalStateException originalThrowable = new IllegalStateException("root message", new IllegalArgumentException("cause message"));
        ExceptionUtils.updateDetailMessage((Throwable)originalThrowable, t -> null);
        Assertions.assertThat((String)originalThrowable.getMessage()).isEqualTo("root message");
        Assertions.assertThat((String)originalThrowable.getCause().getMessage()).isEqualTo("cause message");
    }

    @Test
    void testUpdateDetailMessageOfNullWithoutException() {
        ExceptionUtils.updateDetailMessage(null, t -> "new message");
    }

    @Test
    void testUpdateDetailMessageWithMissingPredicate() {
        Exception root = new Exception("old message");
        ExceptionUtils.updateDetailMessage((Throwable)root, null);
        Assertions.assertThat((String)root.getMessage()).isEqualTo("old message");
    }

    @Test
    void testIsMetaspaceOutOfMemoryErrorCanHandleNullValue() {
        Assertions.assertThat((boolean)ExceptionUtils.isMetaspaceOutOfMemoryError(null)).isFalse();
    }

    @Test
    void testIsDirectOutOfMemoryErrorCanHandleNullValue() {
        Assertions.assertThat((boolean)ExceptionUtils.isDirectOutOfMemoryError(null)).isFalse();
    }
}

