/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.SerializedValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SerializedValueTest {
    SerializedValueTest() {
    }

    @Test
    void testSimpleValue() throws Exception {
        String value = "teststring";
        SerializedValue v = new SerializedValue((Object)"teststring");
        SerializedValue copy = (SerializedValue)CommonTestUtils.createCopySerializable((Serializable)v);
        Assertions.assertThat((String)((String)v.deserializeValue(this.getClass().getClassLoader()))).isEqualTo("teststring");
        Assertions.assertThat((String)((String)copy.deserializeValue(this.getClass().getClassLoader()))).isEqualTo("teststring");
        Assertions.assertThat((Object)copy).isEqualTo((Object)v);
        Assertions.assertThat((Object)copy).hasSameHashCodeAs((Object)v);
        Assertions.assertThat((String)v.toString()).isNotNull();
        Assertions.assertThat((String)copy.toString()).isNotNull();
        Assertions.assertThat((byte[])v.getByteArray()).isNotEmpty();
        Assertions.assertThat((byte[])copy.getByteArray()).isEqualTo((Object)v.getByteArray());
        byte[] bytes = v.getByteArray();
        SerializedValue saved = SerializedValue.fromBytes((byte[])Arrays.copyOf(bytes, bytes.length));
        Assertions.assertThat((Object)saved).isEqualTo((Object)v);
        Assertions.assertThat((byte[])saved.getByteArray()).isEqualTo((Object)v.getByteArray());
    }

    @Test
    void testNullValue() {
        Assertions.assertThatThrownBy(() -> new SerializedValue(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testFromNullBytes() {
        Assertions.assertThatThrownBy(() -> SerializedValue.fromBytes(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testFromEmptyBytes() {
        Assertions.assertThatThrownBy(() -> SerializedValue.fromBytes((byte[])new byte[0])).isInstanceOf(IllegalArgumentException.class);
    }
}

