/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.util.Preconditions;

@Public
public class TypeInformationSerializationSchema<T>
implements DeserializationSchema<T>,
SerializationSchema<T> {
    private static final long serialVersionUID = -5359448468131559102L;
    private final TypeInformation<T> typeInfo;
    private final TypeSerializer<T> serializer;
    private transient DataOutputSerializer dos;
    private transient DataInputDeserializer dis;

    public TypeInformationSerializationSchema(TypeInformation<T> typeInfo, ExecutionConfig ec) {
        this.typeInfo = Preconditions.checkNotNull(typeInfo, "typeInfo");
        this.serializer = typeInfo.createSerializer(ec);
    }

    public TypeInformationSerializationSchema(TypeInformation<T> typeInfo, TypeSerializer<T> serializer) {
        this.typeInfo = Preconditions.checkNotNull(typeInfo, "typeInfo");
        this.serializer = Preconditions.checkNotNull(serializer, "serializer");
    }

    @Override
    public T deserialize(byte[] message) {
        if (this.dis != null) {
            this.dis.setBuffer(message, 0, message.length);
        } else {
            this.dis = new DataInputDeserializer(message, 0, message.length);
        }
        try {
            return this.serializer.deserialize(this.dis);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize message", e);
        }
    }

    @Override
    public boolean isEndOfStream(T nextElement) {
        return false;
    }

    @Override
    public byte[] serialize(T element) {
        if (this.dos == null) {
            this.dos = new DataOutputSerializer(16);
        }
        try {
            this.serializer.serialize(element, this.dos);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize record", e);
        }
        byte[] ret = this.dos.getCopyOfBuffer();
        this.dos.clear();
        return ret;
    }

    @Override
    public TypeInformation<T> getProducedType() {
        return this.typeInfo;
    }
}

