/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;

@Internal
public class CompatibilityUtil {
    public static <T> CompatibilityResult<T> resolveCompatibilityResult(@Nullable TypeSerializer<?> precedingSerializer, Class<?> dummySerializerClassTag, TypeSerializerConfigSnapshot precedingSerializerConfigSnapshot, TypeSerializer<T> newSerializer) {
        if (precedingSerializerConfigSnapshot != null) {
            CompatibilityResult<T> initialResult = newSerializer.ensureCompatibility(precedingSerializerConfigSnapshot);
            if (!initialResult.isRequiresMigration()) {
                return initialResult;
            }
            if (precedingSerializer != null && !precedingSerializer.getClass().equals(dummySerializerClassTag)) {
                return CompatibilityResult.requiresMigration(precedingSerializer);
            }
            return initialResult;
        }
        return CompatibilityResult.compatible();
    }
}

