/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.common.typeutils.UnloadableTypeSerializerException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TypeSerializerSerializationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TypeSerializerSerializationUtil.class);

    public static <T> void writeSerializer(DataOutputView out, TypeSerializer<T> serializer) throws IOException {
        new TypeSerializerSerializationProxy<T>(serializer).write(out);
    }

    public static <T> TypeSerializer<T> tryReadSerializer(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        return TypeSerializerSerializationUtil.tryReadSerializer(in, userCodeClassLoader, false);
    }

    public static <T> TypeSerializer<T> tryReadSerializer(DataInputView in, ClassLoader userCodeClassLoader, boolean useDummyPlaceholder) throws IOException {
        TypeSerializerSerializationProxy proxy = new TypeSerializerSerializationProxy(userCodeClassLoader);
        try {
            proxy.read(in);
            return proxy.getTypeSerializer();
        }
        catch (UnloadableTypeSerializerException e) {
            if (useDummyPlaceholder) {
                LOG.warn("Could not read a requested serializer. Replaced with a UnloadableDummyTypeSerializer.", e.getCause());
                return new UnloadableDummyTypeSerializer(e.getSerializerBytes());
            }
            throw e;
        }
    }

    public static void writeSerializersAndConfigsWithResilience(DataOutputView out, List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> serializersAndConfigs) throws IOException {
        try (ByteArrayOutputStreamWithPos bufferWithPos = new ByteArrayOutputStreamWithPos();
             DataOutputViewStreamWrapper bufferWrapper = new DataOutputViewStreamWrapper(bufferWithPos);){
            out.writeInt(serializersAndConfigs.size());
            for (Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot> serAndConfSnapshot : serializersAndConfigs) {
                out.writeInt(bufferWithPos.getPosition());
                TypeSerializerSerializationUtil.writeSerializer(bufferWrapper, (TypeSerializer)serAndConfSnapshot.f0);
                out.writeInt(bufferWithPos.getPosition());
                TypeSerializerSerializationUtil.writeSerializerConfigSnapshot(bufferWrapper, (TypeSerializerConfigSnapshot)serAndConfSnapshot.f1);
            }
            out.writeInt(bufferWithPos.getPosition());
            out.write(bufferWithPos.getBuf(), 0, bufferWithPos.getPosition());
        }
    }

    public static List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> readSerializersAndConfigsWithResilience(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        int numSerializersAndConfigSnapshots = in.readInt();
        int[] offsets = new int[numSerializersAndConfigSnapshots * 2];
        for (int i = 0; i < numSerializersAndConfigSnapshots; ++i) {
            offsets[i * 2] = in.readInt();
            offsets[i * 2 + 1] = in.readInt();
        }
        int totalBytes = in.readInt();
        byte[] buffer = new byte[totalBytes];
        in.readFully(buffer);
        ArrayList serializersAndConfigSnapshots = new ArrayList(numSerializersAndConfigSnapshots);
        try (ByteArrayInputStreamWithPos bufferWithPos = new ByteArrayInputStreamWithPos(buffer);
             DataInputViewStreamWrapper bufferWrapper = new DataInputViewStreamWrapper(bufferWithPos);){
            for (int i = 0; i < numSerializersAndConfigSnapshots; ++i) {
                bufferWithPos.setPosition(offsets[i * 2]);
                TypeSerializer serializer = TypeSerializerSerializationUtil.tryReadSerializer(bufferWrapper, userCodeClassLoader, true);
                bufferWithPos.setPosition(offsets[i * 2 + 1]);
                TypeSerializerConfigSnapshot configSnapshot = TypeSerializerSerializationUtil.readSerializerConfigSnapshot(bufferWrapper, userCodeClassLoader);
                serializersAndConfigSnapshots.add(new Tuple2(serializer, configSnapshot));
            }
        }
        return serializersAndConfigSnapshots;
    }

    public static void writeSerializerConfigSnapshot(DataOutputView out, TypeSerializerConfigSnapshot serializerConfigSnapshot) throws IOException {
        new TypeSerializerConfigSnapshotSerializationProxy(serializerConfigSnapshot).write(out);
    }

    public static TypeSerializerConfigSnapshot readSerializerConfigSnapshot(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        TypeSerializerConfigSnapshotSerializationProxy proxy = new TypeSerializerConfigSnapshotSerializationProxy(userCodeClassLoader);
        proxy.read(in);
        return proxy.getSerializerConfigSnapshot();
    }

    public static void writeSerializerConfigSnapshots(DataOutputView out, TypeSerializerConfigSnapshot ... serializerConfigSnapshots) throws IOException {
        out.writeInt(serializerConfigSnapshots.length);
        for (TypeSerializerConfigSnapshot snapshot : serializerConfigSnapshots) {
            new TypeSerializerConfigSnapshotSerializationProxy(snapshot).write(out);
        }
    }

    public static TypeSerializerConfigSnapshot[] readSerializerConfigSnapshots(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        int numFields = in.readInt();
        TypeSerializerConfigSnapshot[] serializerConfigSnapshots = new TypeSerializerConfigSnapshot[numFields];
        for (int i = 0; i < numFields; ++i) {
            TypeSerializerConfigSnapshotSerializationProxy proxy = new TypeSerializerConfigSnapshotSerializationProxy(userCodeClassLoader);
            proxy.read(in);
            serializerConfigSnapshots[i] = proxy.getSerializerConfigSnapshot();
        }
        return serializerConfigSnapshots;
    }

    static final class TypeSerializerConfigSnapshotSerializationProxy
    extends VersionedIOReadableWritable {
        private static final int VERSION = 1;
        private ClassLoader userCodeClassLoader;
        private TypeSerializerConfigSnapshot serializerConfigSnapshot;

        TypeSerializerConfigSnapshotSerializationProxy(ClassLoader userCodeClassLoader) {
            this.userCodeClassLoader = Preconditions.checkNotNull(userCodeClassLoader);
        }

        TypeSerializerConfigSnapshotSerializationProxy(TypeSerializerConfigSnapshot serializerConfigSnapshot) {
            this.serializerConfigSnapshot = serializerConfigSnapshot;
        }

        @Override
        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeUTF(this.serializerConfigSnapshot.getClass().getName());
            this.serializerConfigSnapshot.write(out);
        }

        @Override
        public void read(DataInputView in) throws IOException {
            Class<?> serializerConfigSnapshotClass;
            super.read(in);
            String serializerConfigClassname = in.readUTF();
            try {
                serializerConfigSnapshotClass = Class.forName(serializerConfigClassname, true, this.userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Could not find requested TypeSerializerConfigSnapshot class " + serializerConfigClassname + " in classpath.", e);
            }
            this.serializerConfigSnapshot = (TypeSerializerConfigSnapshot)InstantiationUtil.instantiate(serializerConfigSnapshotClass);
            this.serializerConfigSnapshot.setUserCodeClassLoader(this.userCodeClassLoader);
            this.serializerConfigSnapshot.read(in);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        TypeSerializerConfigSnapshot getSerializerConfigSnapshot() {
            return this.serializerConfigSnapshot;
        }
    }

    public static final class TypeSerializerSerializationProxy<T>
    extends VersionedIOReadableWritable {
        private static final Logger LOG = LoggerFactory.getLogger(TypeSerializerSerializationProxy.class);
        private static final int VERSION = 1;
        private ClassLoader userClassLoader;
        private TypeSerializer<T> typeSerializer;

        public TypeSerializerSerializationProxy(ClassLoader userClassLoader) {
            this.userClassLoader = userClassLoader;
        }

        public TypeSerializerSerializationProxy(TypeSerializer<T> typeSerializer) {
            this.typeSerializer = Preconditions.checkNotNull(typeSerializer);
        }

        public TypeSerializer<T> getTypeSerializer() {
            return this.typeSerializer;
        }

        @Override
        public void write(DataOutputView out) throws IOException {
            super.write(out);
            if (this.typeSerializer instanceof UnloadableDummyTypeSerializer) {
                UnloadableDummyTypeSerializer dummyTypeSerializer = (UnloadableDummyTypeSerializer)this.typeSerializer;
                byte[] serializerBytes = dummyTypeSerializer.getActualBytes();
                out.write(serializerBytes.length);
                out.write(serializerBytes);
            } else {
                try (ByteArrayOutputStreamWithPos streamWithPos = new ByteArrayOutputStreamWithPos();){
                    InstantiationUtil.serializeObject(streamWithPos, this.typeSerializer);
                    out.writeInt(streamWithPos.getPosition());
                    out.write(streamWithPos.getBuf(), 0, streamWithPos.getPosition());
                }
            }
        }

        @Override
        public void read(DataInputView in) throws IOException {
            super.read(in);
            int serializerBytes = in.readInt();
            byte[] buffer = new byte[serializerBytes];
            in.readFully(buffer);
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            try (InstantiationUtil.FailureTolerantObjectInputStream ois = new InstantiationUtil.FailureTolerantObjectInputStream(new ByteArrayInputStream(buffer), this.userClassLoader);){
                Thread.currentThread().setContextClassLoader(this.userClassLoader);
                this.typeSerializer = (TypeSerializer)ois.readObject();
            }
            catch (Exception e) {
                throw new UnloadableTypeSerializerException(e, buffer);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
        }

        @Override
        public int getVersion() {
            return 1;
        }
    }
}

