/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.LinkElement;

@PublicEvolving
public class AkkaOptions {
    public static final ConfigOption<String> ASK_TIMEOUT = ConfigOptions.key("akka.ask.timeout").defaultValue("10 s").withDescription("Timeout used for all futures and blocking Akka calls. If Flink fails due to timeouts then you should try to increase this value. Timeouts can be caused by slow machines or a congested network. The timeout value requires a time-unit specifier (ms/s/min/h/d).");
    public static final ConfigOption<String> WATCH_HEARTBEAT_INTERVAL = ConfigOptions.key("akka.watch.heartbeat.interval").defaultValue(ASK_TIMEOUT.defaultValue()).withDescription(Description.builder().text("Heartbeat interval for Akka\u2019s DeathWatch mechanism to detect dead TaskManagers. If TaskManagers are wrongly marked dead because of lost or delayed heartbeat messages, then you should decrease this value or increase akka.watch.heartbeat.pause. A thorough description of Akka\u2019s DeathWatch can be found %s", LinkElement.link("http://doc.akka.io/docs/akka/snapshot/scala/remoting.html#failure-detector", "here")).build());
    public static final ConfigOption<String> WATCH_HEARTBEAT_PAUSE = ConfigOptions.key("akka.watch.heartbeat.pause").defaultValue("60 s").withDescription(Description.builder().text("Acceptable heartbeat pause for Akka\u2019s DeathWatch mechanism. A low value does not allow an irregular heartbeat. If TaskManagers are wrongly marked dead because of lost or delayed heartbeat messages, then you should increase this value or decrease akka.watch.heartbeat.interval. Higher value increases the time to detect a dead TaskManager. A thorough description of Akka\u2019s DeathWatch can be found %s", LinkElement.link("http://doc.akka.io/docs/akka/snapshot/scala/remoting.html#failure-detector", "here")).build());
    public static final ConfigOption<String> TCP_TIMEOUT = ConfigOptions.key("akka.tcp.timeout").defaultValue("20 s").withDescription("Timeout for all outbound connections. If you should experience problems with connecting to a TaskManager due to a slow network, you should increase this value.");
    public static final ConfigOption<String> STARTUP_TIMEOUT = ConfigOptions.key("akka.startup-timeout").noDefaultValue().withDescription("Timeout after which the startup of a remote component is considered being failed.");
    public static final ConfigOption<String> TRANSPORT_HEARTBEAT_INTERVAL = ConfigOptions.key("akka.transport.heartbeat.interval").defaultValue("1000 s").withDescription("Heartbeat interval for Akka\u2019s transport failure detector. Since Flink uses TCP, the detector is not necessary. Therefore, the detector is disabled by setting the interval to a very high value. In case you should need the transport failure detector, set the interval to some reasonable value. The interval value requires a time-unit specifier (ms/s/min/h/d).");
    public static final ConfigOption<String> TRANSPORT_HEARTBEAT_PAUSE = ConfigOptions.key("akka.transport.heartbeat.pause").defaultValue("6000 s").withDescription("Acceptable heartbeat pause for Akka\u2019s transport failure detector. Since Flink uses TCP, the detector is not necessary. Therefore, the detector is disabled by setting the pause to a very high value. In case you should need the transport failure detector, set the pause to some reasonable value. The pause value requires a time-unit specifier (ms/s/min/h/d).");
    public static final ConfigOption<Double> TRANSPORT_THRESHOLD = ConfigOptions.key("akka.transport.threshold").defaultValue(300.0).withDescription("Threshold for the transport failure detector. Since Flink uses TCP, the detector is not necessary and, thus, the threshold is set to a high value.");
    public static final ConfigOption<Integer> WATCH_THRESHOLD = ConfigOptions.key("akka.watch.threshold").defaultValue(12).withDescription(Description.builder().text("Threshold for the DeathWatch failure detector. A low value is prone to false positives whereas a high value increases the time to detect a dead TaskManager. A thorough description of Akka\u2019s DeathWatch can be found %s", LinkElement.link("http://doc.akka.io/docs/akka/snapshot/scala/remoting.html#failure-detector", "here")).build());
    public static final ConfigOption<Boolean> SSL_ENABLED = ConfigOptions.key("akka.ssl.enabled").defaultValue(true).withDescription("Turns on SSL for Akka\u2019s remote communication. This is applicable only when the global ssl flag security.ssl.enabled is set to true.");
    public static final ConfigOption<String> FRAMESIZE = ConfigOptions.key("akka.framesize").defaultValue("10485760b").withDescription("Maximum size of messages which are sent between the JobManager and the TaskManagers. If Flink fails because messages exceed this limit, then you should increase it. The message size requires a size-unit specifier.");
    public static final ConfigOption<Integer> DISPATCHER_THROUGHPUT = ConfigOptions.key("akka.throughput").defaultValue(15).withDescription("Number of messages that are processed in a batch before returning the thread to the pool. Low values denote a fair scheduling whereas high values can increase the performance at the cost of unfairness.");
    public static final ConfigOption<Boolean> LOG_LIFECYCLE_EVENTS = ConfigOptions.key("akka.log.lifecycle.events").defaultValue(false).withDescription("Turns on the Akka\u2019s remote logging of events. Set this value to \u2018true\u2019 in case of debugging.");
    public static final ConfigOption<String> LOOKUP_TIMEOUT = ConfigOptions.key("akka.lookup.timeout").defaultValue("10 s").withDescription("Timeout used for the lookup of the JobManager. The timeout value has to contain a time-unit specifier (ms/s/min/h/d).");
    public static final ConfigOption<String> CLIENT_TIMEOUT = ConfigOptions.key("akka.client.timeout").defaultValue("60 s").withDescription("Timeout for all blocking calls on the client side.");
    public static final ConfigOption<Boolean> JVM_EXIT_ON_FATAL_ERROR = ConfigOptions.key("akka.jvm-exit-on-fatal-error").defaultValue(true).withDescription("Exit JVM on fatal Akka errors.");
    public static final ConfigOption<Long> RETRY_GATE_CLOSED_FOR = ConfigOptions.key("akka.retry-gate-closed-for").defaultValue(50L).withDescription("Milliseconds a gate should be closed for after a remote connection was disconnected.");
    public static final ConfigOption<Double> FORK_JOIN_EXECUTOR_PARALLELISM_FACTOR = ConfigOptions.key("akka.fork-join-executor.parallelism-factor").defaultValue(2.0).withDescription(Description.builder().text("The parallelism factor is used to determine thread pool size using the following formula: ceil(available processors * factor). Resulting size is then bounded by the parallelism-min and parallelism-max values.").build());
    public static final ConfigOption<Integer> FORK_JOIN_EXECUTOR_PARALLELISM_MIN = ConfigOptions.key("akka.fork-join-executor.parallelism-min").defaultValue(8).withDescription(Description.builder().text("Min number of threads to cap factor-based parallelism number to.").build());
    public static final ConfigOption<Integer> FORK_JOIN_EXECUTOR_PARALLELISM_MAX = ConfigOptions.key("akka.fork-join-executor.parallelism-max").defaultValue(64).withDescription(Description.builder().text("Max number of threads to cap factor-based parallelism number to.").build());
    public static final ConfigOption<Integer> CLIENT_SOCKET_WORKER_POOL_SIZE_MIN = ConfigOptions.key("akka.client-socket-worker-pool.pool-size-min").defaultValue(1).withDescription(Description.builder().text("Min number of threads to cap factor-based number to.").build());
    public static final ConfigOption<Integer> CLIENT_SOCKET_WORKER_POOL_SIZE_MAX = ConfigOptions.key("akka.client-socket-worker-pool.pool-size-max").defaultValue(2).withDescription(Description.builder().text("Max number of threads to cap factor-based number to.").build());
    public static final ConfigOption<Double> CLIENT_SOCKET_WORKER_POOL_SIZE_FACTOR = ConfigOptions.key("akka.client-socket-worker-pool.pool-size-factor").defaultValue(1.0).withDescription(Description.builder().text("The pool size factor is used to determine thread pool size using the following formula: ceil(available processors * factor). Resulting size is then bounded by the pool-size-min and pool-size-max values.").build());
    public static final ConfigOption<Integer> SERVER_SOCKET_WORKER_POOL_SIZE_MIN = ConfigOptions.key("akka.server-socket-worker-pool.pool-size-min").defaultValue(1).withDescription(Description.builder().text("Min number of threads to cap factor-based number to.").build());
    public static final ConfigOption<Integer> SERVER_SOCKET_WORKER_POOL_SIZE_MAX = ConfigOptions.key("akka.server-socket-worker-pool.pool-size-max").defaultValue(2).withDescription(Description.builder().text("Max number of threads to cap factor-based number to.").build());
    public static final ConfigOption<Double> SERVER_SOCKET_WORKER_POOL_SIZE_FACTOR = ConfigOptions.key("akka.server-socket-worker-pool.pool-size-factor").defaultValue(1.0).withDescription(Description.builder().text("The pool size factor is used to determine thread pool size using the following formula: ceil(available processors * factor). Resulting size is then bounded by the pool-size-min and pool-size-max values.").build());
}

