/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;

public class ConfigurationUtils {
    private static final String[] EMPTY = new String[0];

    public static MemorySize getJobManagerHeapMemory(Configuration configuration) {
        if (configuration.containsKey(JobManagerOptions.JOB_MANAGER_HEAP_MEMORY.key())) {
            return MemorySize.parse(configuration.getString(JobManagerOptions.JOB_MANAGER_HEAP_MEMORY));
        }
        if (configuration.containsKey(JobManagerOptions.JOB_MANAGER_HEAP_MEMORY_MB.key())) {
            return MemorySize.parse(configuration.getInteger(JobManagerOptions.JOB_MANAGER_HEAP_MEMORY_MB) + "m");
        }
        return MemorySize.parse(configuration.getString(JobManagerOptions.JOB_MANAGER_HEAP_MEMORY));
    }

    public static MemorySize getTaskManagerHeapMemory(Configuration configuration) {
        if (configuration.containsKey(TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY.key())) {
            return MemorySize.parse(configuration.getString(TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY));
        }
        if (configuration.containsKey(TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY_MB.key())) {
            return MemorySize.parse(configuration.getInteger(TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY_MB) + "m");
        }
        return MemorySize.parse(configuration.getString(TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY));
    }

    @Nonnull
    public static String[] parseTempDirectories(Configuration configuration) {
        return ConfigurationUtils.splitPaths(configuration.getString(CoreOptions.TMP_DIRS));
    }

    @Nonnull
    public static String[] parseLocalStateDirectories(Configuration configuration) {
        String configValue = configuration.getString(CheckpointingOptions.LOCAL_RECOVERY_TASK_MANAGER_STATE_ROOT_DIRS, "");
        return ConfigurationUtils.splitPaths(configValue);
    }

    @Nonnull
    public static Configuration createConfiguration(Properties properties) {
        Configuration configuration = new Configuration();
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            configuration.setString(propertyName, properties.getProperty(propertyName));
        }
        return configuration;
    }

    @Nonnull
    private static String[] splitPaths(@Nonnull String separatedPaths) {
        return separatedPaths.length() > 0 ? separatedPaths.split(",|" + File.pathSeparator) : EMPTY;
    }

    private ConfigurationUtils() {
    }
}

