/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.UnsupportedFileSystemSchemeException;
import org.apache.flink.util.Preconditions;

@Internal
class UnsupportedSchemeFactory
implements FileSystemFactory {
    private final String exceptionMessage;
    @Nullable
    private final Throwable exceptionCause;

    public UnsupportedSchemeFactory(String exceptionMessage) {
        this(exceptionMessage, null);
    }

    public UnsupportedSchemeFactory(String exceptionMessage, @Nullable Throwable exceptionCause) {
        this.exceptionMessage = Preconditions.checkNotNull(exceptionMessage);
        this.exceptionCause = exceptionCause;
    }

    @Override
    public String getScheme() {
        return "n/a";
    }

    @Override
    public void configure(Configuration config) {
    }

    @Override
    public FileSystem create(URI fsUri) throws IOException {
        if (this.exceptionCause == null) {
            throw new UnsupportedFileSystemSchemeException(this.exceptionMessage);
        }
        throw new UnsupportedFileSystemSchemeException(this.exceptionMessage, this.exceptionCause);
    }
}

