/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.configuration.StateChangelogOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.util.Preconditions;

@Public
public class ExecutionConfig
implements Serializable,
Archiveable<ArchivedExecutionConfig> {
    private static final long serialVersionUID = 1L;
    public static final int PARALLELISM_DEFAULT = -1;
    public static final int PARALLELISM_UNKNOWN = -2;
    private final Configuration configuration;
    private final SerializerConfig serializerConfig;

    @Internal
    public SerializerConfig getSerializerConfig() {
        return this.serializerConfig;
    }

    public ExecutionConfig() {
        this(new Configuration());
    }

    @Internal
    public ExecutionConfig(Configuration configuration) {
        this.configuration = configuration;
        this.serializerConfig = new SerializerConfigImpl(configuration);
    }

    public ExecutionConfig enableClosureCleaner() {
        return this.setClosureCleanerLevel(ClosureCleanerLevel.RECURSIVE);
    }

    public ExecutionConfig disableClosureCleaner() {
        return this.setClosureCleanerLevel(ClosureCleanerLevel.NONE);
    }

    public boolean isClosureCleanerEnabled() {
        return this.getClosureCleanerLevel() != ClosureCleanerLevel.NONE;
    }

    public ExecutionConfig setClosureCleanerLevel(ClosureCleanerLevel level) {
        this.configuration.set((ConfigOption)PipelineOptions.CLOSURE_CLEANER_LEVEL, level);
        return this;
    }

    public ClosureCleanerLevel getClosureCleanerLevel() {
        return this.configuration.get(PipelineOptions.CLOSURE_CLEANER_LEVEL);
    }

    @PublicEvolving
    public ExecutionConfig setAutoWatermarkInterval(long interval) {
        Preconditions.checkArgument(interval >= 0L, "Auto watermark interval must not be negative.");
        return this.setAutoWatermarkInterval(Duration.ofMillis(interval));
    }

    private ExecutionConfig setAutoWatermarkInterval(Duration autoWatermarkInterval) {
        this.configuration.set((ConfigOption)PipelineOptions.AUTO_WATERMARK_INTERVAL, autoWatermarkInterval);
        return this;
    }

    @PublicEvolving
    public long getAutoWatermarkInterval() {
        return this.configuration.get(PipelineOptions.AUTO_WATERMARK_INTERVAL).toMillis();
    }

    @PublicEvolving
    public ExecutionConfig setLatencyTrackingInterval(long interval) {
        this.configuration.set((ConfigOption)MetricOptions.LATENCY_INTERVAL, Duration.ofMillis(interval));
        return this;
    }

    @PublicEvolving
    public long getLatencyTrackingInterval() {
        return this.configuration.get(MetricOptions.LATENCY_INTERVAL).toMillis();
    }

    @Internal
    public boolean isLatencyTrackingConfigured() {
        return this.configuration.getOptional(MetricOptions.LATENCY_INTERVAL).isPresent();
    }

    @Internal
    public boolean isPeriodicMaterializeEnabled() {
        return this.configuration.get(StateChangelogOptions.PERIODIC_MATERIALIZATION_ENABLED);
    }

    @Internal
    public void enablePeriodicMaterialize(boolean enabled) {
        this.configuration.set((ConfigOption)StateChangelogOptions.PERIODIC_MATERIALIZATION_ENABLED, (Object)enabled);
    }

    @Internal
    public long getPeriodicMaterializeIntervalMillis() {
        return this.configuration.get(StateChangelogOptions.PERIODIC_MATERIALIZATION_INTERVAL).toMillis();
    }

    @Internal
    public void setPeriodicMaterializeIntervalMillis(Duration periodicMaterializeInterval) {
        this.configuration.set((ConfigOption)StateChangelogOptions.PERIODIC_MATERIALIZATION_INTERVAL, periodicMaterializeInterval);
    }

    @Internal
    public int getMaterializationMaxAllowedFailures() {
        return this.configuration.get(StateChangelogOptions.MATERIALIZATION_MAX_FAILURES_ALLOWED);
    }

    @Internal
    public void setMaterializationMaxAllowedFailures(int materializationMaxAllowedFailures) {
        this.configuration.set((ConfigOption)StateChangelogOptions.MATERIALIZATION_MAX_FAILURES_ALLOWED, (Object)materializationMaxAllowedFailures);
    }

    public int getParallelism() {
        return this.configuration.get(CoreOptions.DEFAULT_PARALLELISM);
    }

    public ExecutionConfig setParallelism(int parallelism) {
        if (parallelism != -2) {
            if (parallelism < 1 && parallelism != -1) {
                throw new IllegalArgumentException("Parallelism must be at least one, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
            }
            this.configuration.set((ConfigOption)CoreOptions.DEFAULT_PARALLELISM, (Object)parallelism);
        }
        return this;
    }

    @Internal
    public void resetParallelism() {
        this.configuration.removeConfig(CoreOptions.DEFAULT_PARALLELISM);
    }

    @PublicEvolving
    public int getMaxParallelism() {
        return this.configuration.get(PipelineOptions.MAX_PARALLELISM);
    }

    @PublicEvolving
    public void setMaxParallelism(int maxParallelism) {
        Preconditions.checkArgument(maxParallelism > 0, "The maximum parallelism must be greater than 0.");
        this.configuration.set((ConfigOption)PipelineOptions.MAX_PARALLELISM, (Object)maxParallelism);
    }

    public long getTaskCancellationInterval() {
        return this.configuration.get(TaskManagerOptions.TASK_CANCELLATION_INTERVAL).toMillis();
    }

    public ExecutionConfig setTaskCancellationInterval(long interval) {
        this.configuration.set((ConfigOption)TaskManagerOptions.TASK_CANCELLATION_INTERVAL, Duration.ofMillis(interval));
        return this;
    }

    @PublicEvolving
    public long getTaskCancellationTimeout() {
        return this.configuration.get(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT).toMillis();
    }

    @PublicEvolving
    public ExecutionConfig setTaskCancellationTimeout(long timeout) {
        Preconditions.checkArgument(timeout >= 0L, "Timeout needs to be >= 0.");
        this.configuration.set((ConfigOption)TaskManagerOptions.TASK_CANCELLATION_TIMEOUT, Duration.ofMillis(timeout));
        return this;
    }

    @Internal
    public Optional<JobManagerOptions.SchedulerType> getSchedulerType() {
        return this.configuration.getOptional(JobManagerOptions.SCHEDULER);
    }

    public void enableAutoGeneratedUIDs() {
        this.setAutoGeneratedUids(true);
    }

    public void disableAutoGeneratedUIDs() {
        this.setAutoGeneratedUids(false);
    }

    private void setAutoGeneratedUids(boolean autoGeneratedUids) {
        this.configuration.set((ConfigOption)PipelineOptions.AUTO_GENERATE_UIDS, (Object)autoGeneratedUids);
    }

    public boolean hasAutoGeneratedUIDsEnabled() {
        return this.configuration.get(PipelineOptions.AUTO_GENERATE_UIDS);
    }

    public ExecutionConfig enableObjectReuse() {
        return this.setObjectReuse(true);
    }

    public ExecutionConfig disableObjectReuse() {
        return this.setObjectReuse(false);
    }

    private ExecutionConfig setObjectReuse(boolean objectReuse) {
        this.configuration.set((ConfigOption)PipelineOptions.OBJECT_REUSE, (Object)objectReuse);
        return this;
    }

    public boolean isObjectReuseEnabled() {
        return this.configuration.get(PipelineOptions.OBJECT_REUSE);
    }

    public GlobalJobParameters getGlobalJobParameters() {
        return this.configuration.getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).map(x$0 -> new MapBasedJobParameters((Map<String, String>)x$0)).orElse(new MapBasedJobParameters(Collections.emptyMap()));
    }

    public void setGlobalJobParameters(GlobalJobParameters globalJobParameters) {
        Preconditions.checkNotNull(globalJobParameters, "globalJobParameters shouldn't be null");
        this.setGlobalJobParameters(globalJobParameters.toMap());
    }

    private void setGlobalJobParameters(Map<String, String> parameters) {
        this.configuration.set((ConfigOption)PipelineOptions.GLOBAL_JOB_PARAMETERS, parameters);
    }

    public boolean isUseSnapshotCompression() {
        return this.configuration.get(ExecutionOptions.SNAPSHOT_COMPRESSION);
    }

    public void setUseSnapshotCompression(boolean useSnapshotCompression) {
        this.configuration.set((ConfigOption)ExecutionOptions.SNAPSHOT_COMPRESSION, (Object)useSnapshotCompression);
    }

    @Experimental
    public int getAsyncInflightRecordsLimit() {
        return this.configuration.get(ExecutionOptions.ASYNC_INFLIGHT_RECORDS_LIMIT);
    }

    @Experimental
    public ExecutionConfig setAsyncInflightRecordsLimit(int limit) {
        this.configuration.set((ConfigOption)ExecutionOptions.ASYNC_INFLIGHT_RECORDS_LIMIT, (Object)limit);
        return this;
    }

    @Experimental
    public int getAsyncStateBufferSize() {
        return this.configuration.get(ExecutionOptions.ASYNC_STATE_BUFFER_SIZE);
    }

    @Experimental
    public ExecutionConfig setAsyncStateBufferSize(int bufferSize) {
        this.configuration.set((ConfigOption)ExecutionOptions.ASYNC_STATE_BUFFER_SIZE, (Object)bufferSize);
        return this;
    }

    @Experimental
    public long getAsyncStateBufferTimeout() {
        return this.configuration.get(ExecutionOptions.ASYNC_STATE_BUFFER_TIMEOUT);
    }

    @Experimental
    public ExecutionConfig setAsyncStateBufferTimeout(long timeout) {
        this.configuration.set((ConfigOption)ExecutionOptions.ASYNC_STATE_BUFFER_TIMEOUT, (Object)timeout);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionConfig) {
            ExecutionConfig other = (ExecutionConfig)obj;
            return Objects.equals(this.configuration, other.configuration) && Objects.equals(this.serializerConfig, other.serializerConfig);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.serializerConfig);
    }

    public String toString() {
        return "ExecutionConfig{configuration=" + this.configuration + ", serializerConfig=" + this.serializerConfig + "}";
    }

    @Override
    @Internal
    public ArchivedExecutionConfig archive() {
        return new ArchivedExecutionConfig(this);
    }

    public void configure(ReadableConfig configuration, ClassLoader classLoader) {
        configuration.getOptional(PipelineOptions.AUTO_GENERATE_UIDS).ifPresent(this::setAutoGeneratedUids);
        configuration.getOptional(PipelineOptions.AUTO_WATERMARK_INTERVAL).ifPresent(this::setAutoWatermarkInterval);
        configuration.getOptional(PipelineOptions.CLOSURE_CLEANER_LEVEL).ifPresent(this::setClosureCleanerLevel);
        configuration.getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).ifPresent(this::setGlobalJobParameters);
        configuration.getOptional(MetricOptions.LATENCY_INTERVAL).ifPresent(interval -> this.setLatencyTrackingInterval(interval.toMillis()));
        configuration.getOptional(StateChangelogOptions.PERIODIC_MATERIALIZATION_ENABLED).ifPresent(this::enablePeriodicMaterialize);
        configuration.getOptional(StateChangelogOptions.PERIODIC_MATERIALIZATION_INTERVAL).ifPresent(this::setPeriodicMaterializeIntervalMillis);
        configuration.getOptional(StateChangelogOptions.MATERIALIZATION_MAX_FAILURES_ALLOWED).ifPresent(this::setMaterializationMaxAllowedFailures);
        configuration.getOptional(PipelineOptions.MAX_PARALLELISM).ifPresent(this::setMaxParallelism);
        configuration.getOptional(CoreOptions.DEFAULT_PARALLELISM).ifPresent(this::setParallelism);
        configuration.getOptional(PipelineOptions.OBJECT_REUSE).ifPresent(this::setObjectReuse);
        configuration.getOptional(TaskManagerOptions.TASK_CANCELLATION_INTERVAL).ifPresent(interval -> this.setTaskCancellationInterval(interval.toMillis()));
        configuration.getOptional(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT).ifPresent(timeout -> this.setTaskCancellationTimeout(timeout.toMillis()));
        configuration.getOptional(ExecutionOptions.SNAPSHOT_COMPRESSION).ifPresent(this::setUseSnapshotCompression);
        configuration.getOptional(RestartStrategyOptions.RESTART_STRATEGY).ifPresent(s -> this.setRestartStrategy(configuration));
        configuration.getOptional(JobManagerOptions.SCHEDULER).ifPresent(t -> this.configuration.set((ConfigOption)JobManagerOptions.SCHEDULER, t));
        this.serializerConfig.configure(configuration, classLoader);
    }

    private void setRestartStrategy(ReadableConfig configuration) {
        Map<String, String> map = configuration.toMap();
        HashMap<String, String> restartStrategyEntries = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("restart-strategy")) continue;
            restartStrategyEntries.put(entry.getKey(), entry.getValue());
        }
        this.configuration.addAll(Configuration.fromMap(restartStrategyEntries));
    }

    @Internal
    public Configuration toConfiguration() {
        return new Configuration(this.configuration);
    }

    private static class MapBasedJobParameters
    extends GlobalJobParameters {
        private final Map<String, String> properties;

        private MapBasedJobParameters(Map<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public Map<String, String> toMap() {
            return this.properties;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GlobalJobParameters)) {
                return false;
            }
            GlobalJobParameters that = (GlobalJobParameters)o;
            return Objects.equals(this.properties, that.toMap());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.properties);
        }
    }

    public static enum ClosureCleanerLevel implements DescribedEnum
    {
        NONE(TextElement.text("Disables the closure cleaner completely.")),
        TOP_LEVEL(TextElement.text("Cleans only the top-level class without recursing into fields.")),
        RECURSIVE(TextElement.text("Cleans all fields recursively."));

        private final InlineElement description;

        private ClosureCleanerLevel(InlineElement description) {
            this.description = description;
        }

        @Override
        public InlineElement getDescription() {
            return this.description;
        }
    }

    public static class GlobalJobParameters
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public Map<String, String> toMap() {
            return Collections.emptyMap();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }
}

