/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;

public final class GenericArraySerializerSnapshot<C>
extends CompositeTypeSerializerSnapshot<C[], GenericArraySerializer<C>> {
    private static final int CURRENT_VERSION = 1;
    private Class<C> componentClass;

    public GenericArraySerializerSnapshot() {
    }

    public GenericArraySerializerSnapshot(GenericArraySerializer<C> genericArraySerializer) {
        super(genericArraySerializer);
        this.componentClass = genericArraySerializer.getComponentClass();
    }

    @Override
    protected int getCurrentOuterSnapshotVersion() {
        return 1;
    }

    @Override
    protected void writeOuterSnapshot(DataOutputView out) throws IOException {
        out.writeUTF(this.componentClass.getName());
    }

    @Override
    protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.componentClass = InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
    }

    @Override
    public TypeSerializerSchemaCompatibility<C[]> resolveSchemaCompatibility(TypeSerializerSnapshot<C[]> oldSerializerSnapshot) {
        return super.resolveSchemaCompatibility(oldSerializerSnapshot);
    }

    @Override
    protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(TypeSerializerSnapshot<C[]> oldSerializerSnapshot) {
        if (!(oldSerializerSnapshot instanceof GenericArraySerializerSnapshot)) {
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
        }
        Class<C> componentClass = ((GenericArraySerializerSnapshot)oldSerializerSnapshot).componentClass;
        return this.componentClass == componentClass ? CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS : CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
    }

    @Override
    protected GenericArraySerializer<C> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
        TypeSerializer<?> componentSerializer = nestedSerializers[0];
        return new GenericArraySerializer<C>(this.componentClass, componentSerializer);
    }

    @Override
    protected TypeSerializer<?>[] getNestedSerializers(GenericArraySerializer<C> outerSerializer) {
        return new TypeSerializer[]{outerSerializer.getComponentSerializer()};
    }
}

