/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class HighAvailabilityOptions {
    @Documentation.Section(value={"common_high_availability"}, position=1)
    public static final ConfigOption<String> HA_MODE = ConfigOptions.key("high-availability.type").stringType().defaultValue("NONE").withDeprecatedKeys("recovery.mode", "high-availability").withDescription("Defines high-availability mode used for cluster execution. To enable high-availability, set this mode to \"ZOOKEEPER\", \"KUBERNETES\", or specify the fully qualified name of the factory class.");
    @Documentation.Section(value={"common_high_availability"})
    public static final ConfigOption<String> HA_CLUSTER_ID = ConfigOptions.key("high-availability.cluster-id").stringType().defaultValue("/default").withDeprecatedKeys("high-availability.zookeeper.path.namespace", "recovery.zookeeper.path.namespace").withDescription("The ID of the Flink cluster, used to separate multiple Flink clusters from each other. Needs to be set for standalone clusters but is automatically inferred in YARN.");
    @Documentation.Section(value={"common_high_availability"})
    public static final ConfigOption<String> HA_STORAGE_PATH = ConfigOptions.key("high-availability.storageDir").stringType().noDefaultValue().withDeprecatedKeys("high-availability.zookeeper.storageDir", "recovery.zookeeper.storageDir").withDescription("File system path (URI) where Flink persists metadata in high-availability setups.");
    @Documentation.Section(value={"expert_high_availability"})
    public static final ConfigOption<String> HA_JOB_MANAGER_PORT_RANGE = ConfigOptions.key("high-availability.jobmanager.port").stringType().defaultValue("0").withDeprecatedKeys("recovery.jobmanager.port").withDescription("The port (range) used by the Flink Master for its RPC connections in highly-available setups. In highly-available setups, this value is used instead of '" + JobManagerOptions.PORT.key() + "'.A value of '0' means that a random free port is chosen. TaskManagers discover this port through the high-availability services (leader election), so a random port or a port range works without requiring any additional means of service discovery.");
    @Documentation.Section(value={"common_high_availability_zk"})
    public static final ConfigOption<String> HA_ZOOKEEPER_QUORUM = ConfigOptions.key("high-availability.zookeeper.quorum").stringType().noDefaultValue().withDeprecatedKeys("recovery.zookeeper.quorum").withDescription("The ZooKeeper quorum to use, when running Flink in a high-availability mode with ZooKeeper.");
    @Documentation.Section(value={"common_high_availability_zk"})
    public static final ConfigOption<String> HA_ZOOKEEPER_ROOT = ConfigOptions.key("high-availability.zookeeper.path.root").stringType().defaultValue("/flink").withDeprecatedKeys("recovery.zookeeper.path.root").withDescription("The root path under which Flink stores its entries in ZooKeeper.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<String> HA_ZOOKEEPER_JOBGRAPHS_PATH = ConfigOptions.key("high-availability.zookeeper.path.jobgraphs").stringType().defaultValue("/jobgraphs").withDeprecatedKeys("recovery.zookeeper.path.jobgraphs").withDescription("ZooKeeper root path (ZNode) for job graphs");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Duration> ZOOKEEPER_SESSION_TIMEOUT = ConfigOptions.key("high-availability.zookeeper.client.session-timeout").durationType().defaultValue(Duration.ofMillis(60000L)).withDeprecatedKeys("recovery.zookeeper.client.session-timeout").withDescription("Defines the session timeout for the ZooKeeper session.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Duration> ZOOKEEPER_CONNECTION_TIMEOUT = ConfigOptions.key("high-availability.zookeeper.client.connection-timeout").durationType().defaultValue(Duration.ofMillis(15000L)).withDeprecatedKeys("recovery.zookeeper.client.connection-timeout").withDescription("Defines the connection timeout for ZooKeeper.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Duration> ZOOKEEPER_RETRY_WAIT = ConfigOptions.key("high-availability.zookeeper.client.retry-wait").durationType().defaultValue(Duration.ofMillis(5000L)).withDeprecatedKeys("recovery.zookeeper.client.retry-wait").withDescription("Defines the pause between consecutive retries.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Integer> ZOOKEEPER_MAX_RETRY_ATTEMPTS = ConfigOptions.key("high-availability.zookeeper.client.max-retry-attempts").intType().defaultValue(3).withDeprecatedKeys("recovery.zookeeper.client.max-retry-attempts").withDescription("Defines the number of connection retries before the client gives up.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<String> ZOOKEEPER_CLIENT_ACL = ConfigOptions.key("high-availability.zookeeper.client.acl").stringType().defaultValue("open").withDescription("Defines the ACL (open|creator) to be configured on ZK node. The configuration value can be set to \u201ccreator\u201d if the ZooKeeper server configuration has the \u201cauthProvider\u201d property mapped to use SASLAuthenticationProvider and the cluster is configured to run in secure mode (Kerberos).");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Boolean> ZOOKEEPER_TOLERATE_SUSPENDED_CONNECTIONS = ConfigOptions.key("high-availability.zookeeper.client.tolerate-suspended-connections").booleanType().defaultValue(false).withDescription(Description.builder().text("Defines whether a suspended ZooKeeper connection will be treated as an error that causes the leader information to be invalidated or not. In case you set this option to %s, Flink will wait until a ZooKeeper connection is marked as lost before it revokes the leadership of components. This has the effect that Flink is more resilient against temporary connection instabilities at the cost of running more likely into timing issues with ZooKeeper.", TextElement.code("true")).build());
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Boolean> ZOOKEEPER_ENSEMBLE_TRACKING = ConfigOptions.key("high-availability.zookeeper.client.ensemble-tracker").booleanType().defaultValue(true).withDescription(Description.builder().text("Defines whether Curator should enable ensemble tracker. This can be useful in certain scenarios in which CuratorFramework is accessing to ZK clusters via load balancer or Virtual IPs. Default Curator EnsembleTracking logic watches CuratorEventType.GET_CONFIG events and changes ZooKeeper connection string. It is not desired behaviour when ZooKeeper is running under the Virtual IPs. Under certain configurations EnsembleTracking can lead to setting of ZooKeeper connection string with unresolvable hostnames.").build());
    public static final ConfigOption<Map<String, String>> ZOOKEEPER_CLIENT_AUTHORIZATION = ConfigOptions.key("high-availability.zookeeper.client.authorization").mapType().noDefaultValue().withDescription(Description.builder().text("Add connection authorization Subsequent calls to this method overwrite the prior calls. In certain cases ZooKeeper requires additional Authorization information. For example list of valid names for ensemble in order to prevent accidentally connecting to a wrong ensemble. Each entry of type Map.Entry<String, String> will be transformed into an AuthInfo object with the constructor AuthInfo(String, byte[]). The field entry.key() will serve as the String scheme value, while the field entry.getValue() will be initially converted to a byte[] using the String#getBytes() method with %s encoding. If not set the default configuration for a Curator would be applied.", TextElement.text(ConfigConstants.DEFAULT_CHARSET.displayName())).build());
    public static final ConfigOption<Duration> ZOOKEEPER_MAX_CLOSE_WAIT = ConfigOptions.key("high-availability.zookeeper.client.max-close-wait").durationType().noDefaultValue().withDescription(Description.builder().text("Defines the time Curator should wait during close to join background threads. If not set the default configuration for a Curator would be applied.").build());
    public static final ConfigOption<Integer> ZOOKEEPER_SIMULATED_SESSION_EXP_PERCENT = ConfigOptions.key("high-availability.zookeeper.client.simulated-session-expiration-percent").intType().noDefaultValue().withDescription(Description.builder().text("The percentage set by this method determines how and if Curator will check for session expiration. See Curator documentation for %s property for more information.", LinkElement.link("https://curator.apache.org/apidocs/org/apache/curator/framework/CuratorFrameworkFactory.Builder.html#simulatedSessionExpirationPercent(int)", "simulatedSessionExpirationPercent")).build());

    private HighAvailabilityOptions() {
    }
}

