/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableWriter;

@Experimental
public interface IFileSystem {
    public Path getWorkingDirectory();

    public Path getHomeDirectory();

    public URI getUri();

    public FileStatus getFileStatus(Path var1) throws IOException;

    public BlockLocation[] getFileBlockLocations(FileStatus var1, long var2, long var4) throws IOException;

    public FSDataInputStream open(Path var1, int var2) throws IOException;

    public FSDataInputStream open(Path var1) throws IOException;

    default public RecoverableWriter createRecoverableWriter() throws IOException {
        throw new UnsupportedOperationException("This file system does not support recoverable writers.");
    }

    default public RecoverableWriter createRecoverableWriter(Map<String, String> conf) throws IOException {
        return this.createRecoverableWriter();
    }

    public FileStatus[] listStatus(Path var1) throws IOException;

    default public boolean exists(Path f) throws IOException {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    default public boolean canCopyPaths(Path source, Path destination) throws IOException {
        return false;
    }

    public boolean delete(Path var1, boolean var2) throws IOException;

    public boolean mkdirs(Path var1) throws IOException;

    public FSDataOutputStream create(Path var1, FileSystem.WriteMode var2) throws IOException;

    public boolean rename(Path var1, Path var2) throws IOException;

    public boolean isDistributedFS();

    public boolean initOutPathLocalFS(Path var1, FileSystem.WriteMode var2, boolean var3) throws IOException;

    public boolean initOutPathDistFS(Path var1, FileSystem.WriteMode var2, boolean var3) throws IOException;
}

