/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.state;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

@Internal
public class StateFutureImpl<T>
implements InternalStateFuture<T> {
    private final CompletableFuture<T> completableFuture = new CompletableFuture();
    protected final CallbackRunner callbackRunner;
    protected final AsyncFrameworkExceptionHandler exceptionHandler;

    public StateFutureImpl(CallbackRunner callbackRunner, AsyncFrameworkExceptionHandler exceptionHandler) {
        this.callbackRunner = callbackRunner;
        this.exceptionHandler = exceptionHandler;
    }

    public <U> StateFuture<U> thenApply(FunctionWithException<? super T, ? extends U, ? extends Exception> fn) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            Object r = FunctionWithException.unchecked(fn).apply(t2);
            this.callbackFinished();
            return StateFutureUtils.completedFuture(r);
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            ret.completeInCallbackRunner(fn.apply(t));
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public StateFuture<Void> thenAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            ThrowingConsumer.unchecked(action).accept(t2);
            this.callbackFinished();
            return StateFutureUtils.completedVoidFuture();
        }
        StateFutureImpl<Void> ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            action.accept(t);
            ret.completeInCallbackRunner(null);
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public <U> StateFuture<U> thenCompose(FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> action) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Throwable e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            this.callbackFinished();
            return (StateFuture)FunctionWithException.unchecked(action).apply(t2);
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            StateFuture su = (StateFuture)action.apply(t);
            su.thenAccept(ret::completeInCallbackRunner);
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public <U, V> StateFuture<V> thenCombine(StateFuture<? extends U> other, BiFunctionWithException<? super T, ? super U, ? extends V, ? extends Exception> fn) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t;
            try {
                t = this.completableFuture.get();
            }
            catch (Throwable e) {
                this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", e);
                return null;
            }
            return other.thenCompose(u -> {
                Object v = fn.apply(t, u);
                this.callbackFinished();
                return StateFutureUtils.completedFuture(v);
            });
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((InternalStateFuture)other).thenSyncAccept(u -> ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            ret.completeInCallbackRunner(fn.apply(t, u));
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        }));
        return ret;
    }

    public <U, V> StateFuture<Tuple2<Boolean, Object>> thenConditionallyApply(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends U, ? extends Exception> actionIfTrue, FunctionWithException<? super T, ? extends V, ? extends Exception> actionIfFalse) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(t2);
            Object r = test ? FunctionWithException.unchecked(actionIfTrue).apply(t2) : FunctionWithException.unchecked(actionIfFalse).apply(t2);
            this.callbackFinished();
            return StateFutureUtils.completedFuture(Tuple2.of((Object)test, r));
        }
        StateFutureImpl<Tuple2<Boolean, Object>> ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            boolean test = (Boolean)condition.apply(t);
            Object r = test ? actionIfTrue.apply(t) : actionIfFalse.apply(t);
            ret.completeInCallbackRunner(Tuple2.of((Object)test, (Object)r));
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public <U> StateFuture<Tuple2<Boolean, U>> thenConditionallyApply(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends U, ? extends Exception> actionIfTrue) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(t2);
            Object r = test ? FunctionWithException.unchecked(actionIfTrue).apply(t2) : null;
            this.callbackFinished();
            return StateFutureUtils.completedFuture(Tuple2.of((Object)test, r));
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            boolean test = (Boolean)condition.apply(t);
            Object r = test ? actionIfTrue.apply(t) : null;
            ret.completeInCallbackRunner(Tuple2.of((Object)test, (Object)r));
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public StateFuture<Boolean> thenConditionallyAccept(FunctionWithException<? super T, Boolean, ? extends Exception> condition, ThrowingConsumer<? super T, ? extends Exception> actionIfTrue, ThrowingConsumer<? super T, ? extends Exception> actionIfFalse) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(t2);
            if (test) {
                ThrowingConsumer.unchecked(actionIfTrue).accept(t2);
            } else {
                ThrowingConsumer.unchecked(actionIfFalse).accept(t2);
            }
            this.callbackFinished();
            return StateFutureUtils.completedFuture(test);
        }
        StateFutureImpl<Boolean> ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            boolean test = (Boolean)condition.apply(t);
            if (test) {
                actionIfTrue.accept(t);
            } else {
                actionIfFalse.accept(t);
            }
            ret.completeInCallbackRunner(test);
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public StateFuture<Boolean> thenConditionallyAccept(FunctionWithException<? super T, Boolean, ? extends Exception> condition, ThrowingConsumer<? super T, ? extends Exception> actionIfTrue) {
        return this.thenConditionallyAccept(condition, actionIfTrue, b -> {});
    }

    public <U, V> StateFuture<Tuple2<Boolean, Object>> thenConditionallyCompose(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> actionIfTrue, FunctionWithException<? super T, ? extends StateFuture<V>, ? extends Exception> actionIfFalse) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Throwable e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(t2);
            StateFuture actionResult = test ? (StateFuture)FunctionWithException.unchecked(actionIfTrue).apply(t2) : (StateFuture)FunctionWithException.unchecked(actionIfFalse).apply(t2);
            StateFutureImpl<Tuple2<Boolean, Object>> ret = this.makeNewStateFuture();
            actionResult.thenAccept(e -> ret.completeInCallbackRunner(Tuple2.of((Object)test, (Object)e)));
            this.callbackFinished();
            return ret;
        }
        StateFutureImpl<Tuple2<Boolean, Object>> ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            boolean test = (Boolean)condition.apply(t);
            StateFuture actionResult = test ? (StateFuture)actionIfTrue.apply(t) : (StateFuture)actionIfFalse.apply(t);
            actionResult.thenAccept(e -> ret.completeInCallbackRunner(Tuple2.of((Object)test, (Object)e)));
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public <U> StateFuture<Tuple2<Boolean, U>> thenConditionallyCompose(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> actionIfTrue) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Throwable e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(t2);
            if (test) {
                StateFuture actionResult = (StateFuture)FunctionWithException.unchecked(actionIfTrue).apply(t2);
                StateFutureImpl ret = this.makeNewStateFuture();
                actionResult.thenAccept(e -> ret.completeInCallbackRunner(Tuple2.of((Object)true, (Object)e)));
                this.callbackFinished();
                return ret;
            }
            this.callbackFinished();
            return StateFutureUtils.completedFuture(Tuple2.of((Object)false, null));
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            boolean test = (Boolean)condition.apply(t);
            if (test) {
                StateFuture actionResult = (StateFuture)actionIfTrue.apply(t);
                actionResult.thenAccept(e -> ret.completeInCallbackRunner(Tuple2.of((Object)true, (Object)e)));
            } else {
                ret.completeInCallbackRunner(Tuple2.of((Object)false, null));
            }
            this.callbackFinished();
        })))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public <A> StateFutureImpl<A> makeNewStateFuture() {
        return new StateFutureImpl<T>(this.callbackRunner, this.exceptionHandler);
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    @Override
    public T get() {
        T t;
        try {
            t = this.completableFuture.get();
        }
        catch (Exception e) {
            this.exceptionHandler.handleException("Caught exception when getting StateFuture's result.", e);
            return null;
        }
        return t;
    }

    @Override
    public void complete(T result) {
        if (this.completableFuture.isCompletedExceptionally()) {
            throw new IllegalStateException("StateFuture already failed !");
        }
        this.completableFuture.complete(result);
        this.postComplete(false);
    }

    @Override
    public void completeExceptionally(String message, Throwable ex) {
        this.exceptionHandler.handleException(message, ex);
    }

    private void completeInCallbackRunner(T result) {
        this.completableFuture.complete(result);
        this.postComplete(true);
    }

    public void callbackRegistered() {
    }

    public void postComplete(boolean inCallbackRunner) {
    }

    public void callbackFinished() {
    }

    @Override
    public void thenSyncAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        ((CompletableFuture)this.completableFuture.thenAccept(ThrowingConsumer.unchecked(action))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", (Throwable)e);
            return null;
        });
    }

    public static interface AsyncFrameworkExceptionHandler {
        public void handleException(String var1, Throwable var2);
    }

    public static interface CallbackRunner {
        public void submit(ThrowingRunnable<? extends Exception> var1);
    }
}

