/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.time.Duration;
import org.apache.flink.api.common.RestartStrategyDescriptionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RestartStrategyDescriptionUtilsTest {
    private Configuration configuration;

    @BeforeEach
    public void setUp() {
        this.configuration = new Configuration();
    }

    @Test
    public void testGetNoRestartStrategyDescription() {
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"none");
        String description = RestartStrategyDescriptionUtils.getRestartStrategyDescription((Configuration)this.configuration);
        AssertionsForInterfaceTypes.assertThat((String)"Restart deactivated.").isEqualTo(description);
    }

    @Test
    public void testGetFixedDelayDescription() {
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)3);
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofSeconds(10L));
        String description = RestartStrategyDescriptionUtils.getRestartStrategyDescription((Configuration)this.configuration);
        AssertionsForInterfaceTypes.assertThat((String)"Restart with fixed delay (PT10S). #3 restart attempts.").isEqualTo(description);
    }

    @Test
    public void testGetFailureRateDescription() {
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"failure-rate");
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL, (Object)5);
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL, (Object)Duration.ofMinutes(1L));
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_DELAY, (Object)Duration.ofSeconds(15L));
        String description = RestartStrategyDescriptionUtils.getRestartStrategyDescription((Configuration)this.configuration);
        AssertionsForInterfaceTypes.assertThat((String)"Failure rate restart with maximum of 5 failures within interval PT1M and fixed delay PT15S.").isEqualTo(description);
    }

    @Test
    public void testGetExponentialDelayDescription() {
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"exponential-delay");
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF, (Object)Duration.ofSeconds(1L));
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF, (Object)Duration.ofMinutes(2L));
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER, (Object)2.0);
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD, (Object)Duration.ofMinutes(5L));
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR, (Object)0.5);
        String description = RestartStrategyDescriptionUtils.getRestartStrategyDescription((Configuration)this.configuration);
        AssertionsForInterfaceTypes.assertThat((String)"Restart with exponential delay: starting at PT1S, increasing by 2.000000, with maximum PT2M. Delay resets after PT5M with jitter 0.500000").isEqualTo(description);
    }

    @Test
    public void testGetDefaultRestartStrategyDescription() {
        String description = RestartStrategyDescriptionUtils.getRestartStrategyDescription((Configuration)this.configuration);
        AssertionsForInterfaceTypes.assertThat((String)"Cluster level default restart strategy").isEqualTo(description);
    }

    @Test
    public void testGetRestartStrategyDescriptionForUnknownStrategy() {
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"unknown");
        AssertionsForClassTypes.assertThatThrownBy(() -> RestartStrategyDescriptionUtils.getRestartStrategyDescription((Configuration)this.configuration)).isInstanceOf(IllegalArgumentException.class);
    }
}

