/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntMinimum;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IntMinimumTest {
    IntMinimumTest() {
    }

    @Test
    void testGet() {
        IntMinimum min = new IntMinimum();
        Assertions.assertThat((int)min.getLocalValue()).isEqualTo(Integer.MAX_VALUE);
    }

    @Test
    void testResetLocal() {
        IntMinimum min = new IntMinimum();
        int value = 13;
        min.add(value);
        Assertions.assertThat((int)min.getLocalValue()).isEqualTo(value);
        min.resetLocal();
        Assertions.assertThat((int)min.getLocalValue()).isEqualTo(Integer.MAX_VALUE);
    }

    @Test
    void testAdd() {
        IntMinimum min = new IntMinimum();
        min.add(1234);
        min.add(9876);
        min.add(-987);
        min.add(-123);
        Assertions.assertThat((int)min.getLocalValue()).isEqualTo(-987);
    }

    @Test
    void testMerge() {
        IntMinimum min1 = new IntMinimum();
        min1.add(1234);
        IntMinimum min2 = new IntMinimum();
        min2.add(5678);
        min2.merge((Accumulator)min1);
        Assertions.assertThat((int)min2.getLocalValue()).isEqualTo(1234);
        min1.merge((Accumulator)min2);
        Assertions.assertThat((int)min1.getLocalValue()).isEqualTo(1234);
    }

    @Test
    void testClone() {
        IntMinimum min = new IntMinimum();
        int value = 42;
        min.add(value);
        IntMinimum clone = min.clone();
        Assertions.assertThat((int)clone.getLocalValue()).isEqualTo(value);
    }
}

