/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.LongMaximum;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LongMaximumTest {
    LongMaximumTest() {
    }

    @Test
    void testGet() {
        LongMaximum max = new LongMaximum();
        Assertions.assertThat((long)max.getLocalValue()).isEqualTo(Long.MIN_VALUE);
    }

    @Test
    void testResetLocal() {
        LongMaximum max = new LongMaximum();
        long value = 9876543210L;
        max.add(value);
        Assertions.assertThat((long)max.getLocalValue()).isEqualTo(value);
        max.resetLocal();
        Assertions.assertThat((long)max.getLocalValue()).isEqualTo(Long.MIN_VALUE);
    }

    @Test
    void testAdd() {
        LongMaximum max = new LongMaximum();
        max.add(1234567890L);
        max.add(9876543210L);
        max.add(-9876543210L);
        max.add(-1234567890L);
        Assertions.assertThat((long)max.getLocalValue()).isEqualTo(9876543210L);
    }

    @Test
    void testMerge() {
        LongMaximum max1 = new LongMaximum();
        max1.add(1234567890987654321L);
        LongMaximum max2 = new LongMaximum();
        max2.add(5678909876543210123L);
        max2.merge((Accumulator)max1);
        Assertions.assertThat((long)max2.getLocalValue()).isEqualTo(5678909876543210123L);
        max1.merge((Accumulator)max2);
        Assertions.assertThat((long)max1.getLocalValue()).isEqualTo(5678909876543210123L);
    }

    @Test
    void testClone() {
        LongMaximum max = new LongMaximum();
        long value = 4242424242424242L;
        max.add(value);
        LongMaximum clone = max.clone();
        Assertions.assertThat((long)clone.getLocalValue()).isEqualTo(value);
    }
}

