/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.apache.flink.api.common.io.GlobFilePathFilter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

class GlobFilePathFilterTest {
    GlobFilePathFilterTest() {
    }

    @Test
    void testDefaultConstructorCreateMatchAllFilter() {
        GlobFilePathFilter matcher = new GlobFilePathFilter();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/file.txt"))).isFalse();
    }

    @Test
    void testMatchAllFilesByDefault() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.emptyList(), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/file.txt"))).isFalse();
    }

    @Test
    void testExcludeFilesNotInIncludePatterns() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/*"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/file.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir1/file.txt"))).isTrue();
    }

    @Test
    void testExcludeFilesIfMatchesExclude() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/*"), Collections.singletonList("dir/file.txt"));
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/file.txt"))).isTrue();
    }

    @Test
    void testIncludeFileWithAnyCharacterMatcher() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/?.txt"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/a.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/aa.txt"))).isTrue();
    }

    @Test
    void testIncludeFileWithCharacterSetMatcher() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/[acd].txt"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/a.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/c.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/d.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/z.txt"))).isTrue();
    }

    @Test
    void testIncludeFileWithCharacterRangeMatcher() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/[a-d].txt"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/a.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/b.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/c.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/d.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/z.txt"))).isTrue();
    }

    @Test
    void testExcludeHDFSFile() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("**"), Collections.singletonList("/dir/file2.txt"));
        Assertions.assertThat((boolean)matcher.filterPath(new Path("hdfs:///dir/file1.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("hdfs:///dir/file2.txt"))).isTrue();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("hdfs:///dir/file3.txt"))).isFalse();
    }

    @Test
    void testExcludeFilenameWithStart() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).as("Windows does not allow asterisks in file names.", new Object[0])).isFalse();
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("**"), Collections.singletonList("\\*"));
        Assertions.assertThat((boolean)matcher.filterPath(new Path("*"))).isTrue();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("**"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("other.txt"))).isFalse();
    }

    @Test
    void testSingleStarPattern() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("*"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a/b"))).isTrue();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a/b/c"))).isTrue();
    }

    @Test
    void testDoubleStarPattern() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("**"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a/b"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a/b/c"))).isFalse();
    }

    @Test
    void testIncludePatternIsNull() {
        Assertions.assertThatThrownBy(() -> new GlobFilePathFilter(null, Collections.emptyList())).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testExcludePatternIsNull() {
        Assertions.assertThatThrownBy(() -> new GlobFilePathFilter(Collections.singletonList("**"), null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testGlobFilterSerializable() throws IOException {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("**"), Collections.emptyList());
        GlobFilePathFilter matcherCopy = (GlobFilePathFilter)CommonTestUtils.createCopySerializable((Serializable)matcher);
        Assertions.assertThat((boolean)matcherCopy.filterPath(new Path("a"))).isFalse();
        Assertions.assertThat((boolean)matcherCopy.filterPath(new Path("a/b"))).isFalse();
        Assertions.assertThat((boolean)matcherCopy.filterPath(new Path("a/b/c"))).isFalse();
    }
}

