/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SingleInputSemanticPropertiesTest {
    SingleInputSemanticPropertiesTest() {
    }

    @Test
    void testGetTargetFields() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 1);
        sp.addForwardedField(1, 4);
        sp.addForwardedField(2, 3);
        sp.addForwardedField(3, 2);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 0)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 1)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 2)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 3)).hasSize(1);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(4))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2))).isTrue();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 4)).isNotNull();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 4)).isEmpty();
        sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 0);
        sp.addForwardedField(0, 4);
        sp.addForwardedField(1, 1);
        sp.addForwardedField(1, 2);
        sp.addForwardedField(1, 3);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 0)).hasSize(2);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 1)).hasSize(3);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(3))).isTrue();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 2)).isNotNull();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 2)).isEmpty();
    }

    @Test
    void testGetSourceField() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 1);
        sp.addForwardedField(1, 4);
        sp.addForwardedField(2, 3);
        sp.addForwardedField(3, 2);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 1)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 4)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 3)).isEqualTo(2);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 2)).isEqualTo(3);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 0)).isNegative();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 5)).isNegative();
        sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 0);
        sp.addForwardedField(0, 4);
        sp.addForwardedField(1, 1);
        sp.addForwardedField(1, 2);
        sp.addForwardedField(1, 3);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 0)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 4)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 1)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 2)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 3)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 5)).isNegative();
    }

    @Test
    void testGetReadSet() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addReadFields(new FieldSet(new int[]{0, 1}));
        Assertions.assertThat((Iterable)sp.getReadFields(0)).hasSize(2);
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(1))).isTrue();
        sp.addReadFields(new FieldSet(Integer.valueOf(3)));
        Assertions.assertThat((Iterable)sp.getReadFields(0)).hasSize(3);
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(3))).isTrue();
    }

    @Test
    void testAddForwardedFieldsTargetTwice() {
        Assertions.assertThatThrownBy(() -> {
            SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
            sp.addForwardedField(0, 2);
            sp.addForwardedField(1, 2);
        }).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testGetTargetFieldInvalidIndex() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 0);
        Assertions.assertThatThrownBy(() -> sp.getForwardingTargetFields(1, 0)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testGetSourceFieldInvalidIndex() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 0);
        Assertions.assertThatThrownBy(() -> sp.getForwardingSourceField(1, 0)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testGetReadFieldsInvalidIndex() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addReadFields(new FieldSet(new int[]{0, 1}));
        Assertions.assertThatThrownBy(() -> sp.getReadFields(1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testAllForwardedSingleInputSemProps() {
        SingleInputSemanticProperties.AllFieldsForwardedProperties sp = new SingleInputSemanticProperties.AllFieldsForwardedProperties();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 0)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 1)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 123)).hasSize(1);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 123).contains(Integer.valueOf(123))).isTrue();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 0)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 2)).isEqualTo(2);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 123)).isEqualTo(123);
    }

    @Test
    void testAllForwardedSingleInputSemPropsInvalidIndex1() {
        Assertions.assertThatThrownBy(() -> {
            SingleInputSemanticProperties.AllFieldsForwardedProperties sp = new SingleInputSemanticProperties.AllFieldsForwardedProperties();
            sp.getForwardingSourceField(1, 0);
        }).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testAllForwardedSingleInputSemPropsInvalidIndex2() {
        Assertions.assertThatThrownBy(() -> {
            SingleInputSemanticProperties.AllFieldsForwardedProperties sp = new SingleInputSemanticProperties.AllFieldsForwardedProperties();
            sp.getForwardingTargetFields(1, 0);
        }).isInstanceOf(IndexOutOfBoundsException.class);
    }
}

