/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.FlatMapOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FlatMapOperatorCollectionTest
implements Serializable {
    FlatMapOperatorCollectionTest() {
    }

    @Test
    void testExecuteOnCollection() throws Exception {
        IdRichFlatMap udf = new IdRichFlatMap();
        this.testExecuteOnCollection((FlatMapFunction<String, String>)udf, Arrays.asList("f", "l", "i", "n", "k"), true);
        Assertions.assertThat((boolean)udf.isClosed).isTrue();
        udf = new IdRichFlatMap();
        this.testExecuteOnCollection((FlatMapFunction<String, String>)udf, Arrays.asList("f", "l", "i", "n", "k"), false);
        Assertions.assertThat((boolean)udf.isClosed).isTrue();
        udf = new IdRichFlatMap();
        this.testExecuteOnCollection((FlatMapFunction<String, String>)udf, Collections.emptyList(), true);
        Assertions.assertThat((boolean)udf.isClosed).isTrue();
        udf = new IdRichFlatMap();
        this.testExecuteOnCollection((FlatMapFunction<String, String>)udf, Collections.emptyList(), false);
        Assertions.assertThat((boolean)udf.isClosed).isTrue();
    }

    private void testExecuteOnCollection(FlatMapFunction<String, String> udf, List<String> input, boolean mutableSafe) throws Exception {
        ExecutionConfig executionConfig = new ExecutionConfig();
        if (mutableSafe) {
            executionConfig.disableObjectReuse();
        } else {
            executionConfig.enableObjectReuse();
        }
        TaskInfoImpl taskInfo = new TaskInfoImpl("Test UDF", 4, 0, 4, 0);
        List result = this.getTestFlatMapOperator(udf).executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
        Assertions.assertThat((List)result).hasSameSizeAs(input);
        Assertions.assertThat((List)result).isEqualTo(input);
    }

    private FlatMapOperatorBase<String, String, FlatMapFunction<String, String>> getTestFlatMapOperator(FlatMapFunction<String, String> udf) {
        UnaryOperatorInformation typeInfo = new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        return new FlatMapOperatorBase(udf, typeInfo, "flatMap on Collections");
    }

    public class IdRichFlatMap<IN>
    extends RichFlatMapFunction<IN, IN> {
        private boolean isOpened = false;
        private boolean isClosed = false;

        public void open(OpenContext openContext) {
            this.isOpened = true;
            RuntimeContext ctx = this.getRuntimeContext();
            Assertions.assertThat((String)ctx.getTaskInfo().getTaskName()).isEqualTo("Test UDF");
            Assertions.assertThat((int)ctx.getTaskInfo().getNumberOfParallelSubtasks()).isEqualTo(4);
            Assertions.assertThat((int)ctx.getTaskInfo().getIndexOfThisSubtask()).isZero();
        }

        public void flatMap(IN value, Collector<IN> out) {
            Assertions.assertThat((boolean)this.isOpened).isTrue();
            Assertions.assertThat((boolean)this.isClosed).isFalse();
            out.collect(value);
        }

        public void close() {
            this.isClosed = true;
        }
    }
}

