/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.base.OuterJoinOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OuterJoinOperatorBaseTest
implements Serializable {
    private MockRichFlatJoinFunction joiner;
    private OuterJoinOperatorBase<String, String, String, FlatJoinFunction<String, String, String>> baseOperator;
    private ExecutionConfig executionConfig;
    private RuntimeContext runtimeContext;

    OuterJoinOperatorBaseTest() {
    }

    @BeforeEach
    void setup() {
        this.joiner = new MockRichFlatJoinFunction();
        this.baseOperator = new OuterJoinOperatorBase((FlatJoinFunction)this.joiner, new BinaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), new int[0], new int[0], "TestJoiner", null);
        this.executionConfig = new ExecutionConfig();
        String taskName = "Test rich outer join function";
        TaskInfoImpl taskInfo = new TaskInfoImpl(taskName, 1, 0, 1, 0);
        HashMap accumulatorMap = new HashMap();
        HashMap cpTasks = new HashMap();
        this.runtimeContext = new RuntimeUDFContext((TaskInfo)taskInfo, null, this.executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup());
    }

    @Test
    void testFullOuterJoinWithoutMatchingPartners() throws Exception {
        List<String> leftInput = Arrays.asList("foo", "bar", "foobar");
        List<String> rightInput = Arrays.asList("oof", "rab", "raboof");
        this.baseOperator.setOuterJoinType(OuterJoinOperatorBase.OuterJoinType.FULL);
        List<String> expected = Arrays.asList("bar,null", "foo,null", "foobar,null", "null,oof", "null,rab", "null,raboof");
        this.testOuterJoin(leftInput, rightInput, expected);
    }

    @Test
    void testFullOuterJoinWithFullMatchingKeys() throws Exception {
        List<String> leftInput = Arrays.asList("foo", "bar", "foobar");
        List<String> rightInput = Arrays.asList("bar", "foobar", "foo");
        this.baseOperator.setOuterJoinType(OuterJoinOperatorBase.OuterJoinType.FULL);
        List<String> expected = Arrays.asList("bar,bar", "foo,foo", "foobar,foobar");
        this.testOuterJoin(leftInput, rightInput, expected);
    }

    @Test
    void testFullOuterJoinWithEmptyLeftInput() throws Exception {
        List<String> leftInput = Collections.emptyList();
        List<String> rightInput = Arrays.asList("foo", "bar", "foobar");
        this.baseOperator.setOuterJoinType(OuterJoinOperatorBase.OuterJoinType.FULL);
        List<String> expected = Arrays.asList("null,bar", "null,foo", "null,foobar");
        this.testOuterJoin(leftInput, rightInput, expected);
    }

    @Test
    void testFullOuterJoinWithEmptyRightInput() throws Exception {
        List<String> leftInput = Arrays.asList("foo", "bar", "foobar");
        List<String> rightInput = Collections.emptyList();
        this.baseOperator.setOuterJoinType(OuterJoinOperatorBase.OuterJoinType.FULL);
        List<String> expected = Arrays.asList("bar,null", "foo,null", "foobar,null");
        this.testOuterJoin(leftInput, rightInput, expected);
    }

    @Test
    void testFullOuterJoinWithPartialMatchingKeys() throws Exception {
        List<String> leftInput = Arrays.asList("foo", "bar", "foobar");
        List<String> rightInput = Arrays.asList("bar", "foo", "barfoo");
        this.baseOperator.setOuterJoinType(OuterJoinOperatorBase.OuterJoinType.FULL);
        List<String> expected = Arrays.asList("bar,bar", "null,barfoo", "foo,foo", "foobar,null");
        this.testOuterJoin(leftInput, rightInput, expected);
    }

    @Test
    void testFullOuterJoinBuildingCorrectCrossProducts() throws Exception {
        List<String> leftInput = Arrays.asList("foo", "foo", "foo", "bar", "bar", "foobar", "foobar");
        List<String> rightInput = Arrays.asList("foo", "foo", "bar", "bar", "bar", "barfoo", "barfoo");
        this.baseOperator.setOuterJoinType(OuterJoinOperatorBase.OuterJoinType.FULL);
        List<String> expected = Arrays.asList("bar,bar", "bar,bar", "bar,bar", "bar,bar", "bar,bar", "bar,bar", "null,barfoo", "null,barfoo", "foo,foo", "foo,foo", "foo,foo", "foo,foo", "foo,foo", "foo,foo", "foobar,null", "foobar,null");
        this.testOuterJoin(leftInput, rightInput, expected);
    }

    @Test
    void testLeftOuterJoin() throws Exception {
        List<String> leftInput = Arrays.asList("foo", "foo", "foo", "bar", "bar", "foobar", "foobar");
        List<String> rightInput = Arrays.asList("foo", "foo", "bar", "bar", "bar", "barfoo", "barfoo");
        this.baseOperator.setOuterJoinType(OuterJoinOperatorBase.OuterJoinType.LEFT);
        List<String> expected = Arrays.asList("bar,bar", "bar,bar", "bar,bar", "bar,bar", "bar,bar", "bar,bar", "foo,foo", "foo,foo", "foo,foo", "foo,foo", "foo,foo", "foo,foo", "foobar,null", "foobar,null");
        this.testOuterJoin(leftInput, rightInput, expected);
    }

    @Test
    void testRightOuterJoin() throws Exception {
        List<String> leftInput = Arrays.asList("foo", "foo", "foo", "bar", "bar", "foobar", "foobar");
        List<String> rightInput = Arrays.asList("foo", "foo", "bar", "bar", "bar", "barfoo", "barfoo");
        this.baseOperator.setOuterJoinType(OuterJoinOperatorBase.OuterJoinType.RIGHT);
        List<String> expected = Arrays.asList("bar,bar", "bar,bar", "bar,bar", "bar,bar", "bar,bar", "bar,bar", "null,barfoo", "null,barfoo", "foo,foo", "foo,foo", "foo,foo", "foo,foo", "foo,foo", "foo,foo");
        this.testOuterJoin(leftInput, rightInput, expected);
    }

    @Test
    void testThatExceptionIsThrownForOuterJoinTypeNull() throws Exception {
        List<String> leftInput = Arrays.asList("foo", "bar", "foobar");
        List<String> rightInput = Arrays.asList("bar", "foobar", "foo");
        this.baseOperator.setOuterJoinType(null);
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.disableObjectReuse();
        Assertions.assertThatThrownBy(() -> this.baseOperator.executeOnCollections(leftInput, rightInput, this.runtimeContext, executionConfig)).isInstanceOf(IllegalArgumentException.class);
    }

    private void testOuterJoin(List<String> leftInput, List<String> rightInput, List<String> expected) throws Exception {
        this.executionConfig.disableObjectReuse();
        List resultSafe = this.baseOperator.executeOnCollections(leftInput, rightInput, this.runtimeContext, this.executionConfig);
        this.executionConfig.enableObjectReuse();
        List resultRegular = this.baseOperator.executeOnCollections(leftInput, rightInput, this.runtimeContext, this.executionConfig);
        Assertions.assertThat((List)resultSafe).isEqualTo(expected);
        Assertions.assertThat((List)resultRegular).isEqualTo(expected);
        Assertions.assertThat((AtomicBoolean)this.joiner.opened).isTrue();
        Assertions.assertThat((AtomicBoolean)this.joiner.closed).isTrue();
    }

    private static class MockRichFlatJoinFunction
    extends RichFlatJoinFunction<String, String, String> {
        final AtomicBoolean opened = new AtomicBoolean(false);
        final AtomicBoolean closed = new AtomicBoolean(false);

        private MockRichFlatJoinFunction() {
        }

        public void open(OpenContext openContext) {
            this.opened.compareAndSet(false, true);
            Assertions.assertThat((int)this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask()).isZero();
            Assertions.assertThat((int)this.getRuntimeContext().getTaskInfo().getNumberOfParallelSubtasks()).isOne();
        }

        public void close() {
            this.closed.compareAndSet(false, true);
        }

        public void join(String first, String second, Collector<String> out) {
            out.collect((Object)(String.valueOf(first) + "," + second));
        }
    }
}

