/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public abstract class ComparatorTestBase<T> {
    private static final int DEFAULT_MAX_NORMALIZED_KEY_LEN = 8;

    protected Order[] getTestedOrder() {
        return new Order[]{Order.ASCENDING, Order.DESCENDING};
    }

    protected abstract TypeComparator<T> createComparator(boolean var1);

    protected abstract TypeSerializer<T> createSerializer();

    protected abstract T[] getSortedTestData();

    @Test
    protected void testDuplicate() {
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comparator = this.getComparator(ascending);
        TypeComparator clone = comparator.duplicate();
        T[] data = this.getSortedData();
        comparator.setReference(data[0]);
        clone.setReference(data[1]);
        ((AbstractBooleanAssert)Assertions.assertThat((comparator.equalToReference(data[0]) && clone.equalToReference(data[1]) ? 1 : 0) != 0).as("Comparator duplication does not work: Altering the reference in a duplicated comparator alters the original comparator's reference.", new Object[0])).isTrue();
    }

    @Test
    protected void testEquality() throws IOException {
        for (Order order : this.getTestedOrder()) {
            boolean ascending = ComparatorTestBase.isAscending(order);
            this.testEquals(ascending);
        }
    }

    protected void testEquals(boolean ascending) throws IOException {
        T[] data;
        TypeComparator<T> comparator = this.getComparator(ascending);
        for (T d : data = this.getSortedData()) {
            TestOutputView out2 = new TestOutputView();
            this.writeSortedData(d, out2);
            TestInputView in2 = out2.getInputView();
            TestOutputView out1 = new TestOutputView();
            this.writeSortedData(d, out1);
            TestInputView in1 = out1.getInputView();
            Assertions.assertThat((int)comparator.compareSerialized((DataInputView)in1, (DataInputView)in2)).isZero();
        }
    }

    @Test
    protected void testEqualityWithReference() {
        T[] data;
        TypeSerializer<T> serializer = this.createSerializer();
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comparator = this.getComparator(ascending);
        TypeComparator<T> comparator2 = this.getComparator(ascending);
        for (T d : data = this.getSortedData()) {
            comparator.setReference(d);
            Object copy = serializer.copy(d, serializer.createInstance());
            Assertions.assertThat((boolean)comparator.equalToReference(d)).isTrue();
            comparator2.setReference(copy);
            Assertions.assertThat((int)comparator.compareToReference(comparator2)).isZero();
        }
    }

    @Test
    protected void testInequality() throws IOException {
        for (Order order : this.getTestedOrder()) {
            boolean ascending = ComparatorTestBase.isAscending(order);
            this.testGreatSmallAscDesc(ascending, true);
            this.testGreatSmallAscDesc(ascending, false);
        }
    }

    protected void testGreatSmallAscDesc(boolean ascending, boolean greater) throws IOException {
        T[] data = this.getSortedData();
        TypeComparator<T> comparator = this.getComparator(ascending);
        for (int x = 0; x < data.length - 1; ++x) {
            for (int y = x + 1; y < data.length; ++y) {
                TestOutputView out1 = new TestOutputView();
                this.writeSortedData(data[x], out1);
                TestInputView in1 = out1.getInputView();
                TestOutputView out2 = new TestOutputView();
                this.writeSortedData(data[y], out2);
                TestInputView in2 = out2.getInputView();
                if (greater && ascending) {
                    Assertions.assertThat((int)comparator.compareSerialized((DataInputView)in1, (DataInputView)in2)).isNegative();
                }
                if (greater && !ascending) {
                    Assertions.assertThat((int)comparator.compareSerialized((DataInputView)in1, (DataInputView)in2)).isPositive();
                }
                if (!greater && ascending) {
                    Assertions.assertThat((int)comparator.compareSerialized((DataInputView)in2, (DataInputView)in1)).isPositive();
                }
                if (greater || ascending) continue;
                Assertions.assertThat((int)comparator.compareSerialized((DataInputView)in2, (DataInputView)in1)).isNegative();
            }
        }
    }

    @Test
    protected void testInequalityWithReference() {
        for (Order order : this.getTestedOrder()) {
            boolean ascending = ComparatorTestBase.isAscending(order);
            this.testGreatSmallAscDescWithReference(ascending, true);
            this.testGreatSmallAscDescWithReference(ascending, false);
        }
    }

    protected void testGreatSmallAscDescWithReference(boolean ascending, boolean greater) {
        T[] data = this.getSortedData();
        TypeComparator<T> comparatorLow = this.getComparator(ascending);
        TypeComparator<T> comparatorHigh = this.getComparator(ascending);
        for (int x = 0; x < data.length - 1; ++x) {
            for (int y = x + 1; y < data.length; ++y) {
                comparatorLow.setReference(data[x]);
                comparatorHigh.setReference(data[y]);
                if (greater && ascending) {
                    Assertions.assertThat((int)comparatorLow.compareToReference(comparatorHigh)).isPositive();
                }
                if (greater && !ascending) {
                    Assertions.assertThat((int)comparatorLow.compareToReference(comparatorHigh)).isNegative();
                }
                if (!greater && ascending) {
                    Assertions.assertThat((int)comparatorHigh.compareToReference(comparatorLow)).isNegative();
                }
                if (greater || ascending) continue;
                Assertions.assertThat((int)comparatorHigh.compareToReference(comparatorLow)).isPositive();
            }
        }
    }

    public MemorySegment setupNormalizedKeysMemSegment(T[] data, int normKeyLen, TypeComparator<T> comparator) {
        MemorySegment memSeg = MemorySegmentFactory.allocateUnpooledSegment((int)2048);
        int offset = 0;
        for (T e : data) {
            comparator.putNormalizedKey(e, memSeg, offset, normKeyLen);
            offset += normKeyLen;
        }
        return memSeg;
    }

    private int getNormKeyLen(boolean halfLength, T[] data, TypeComparator<T> comparator) {
        int keyLen = Math.min(comparator.getNormalizeKeyLen(), 8);
        if (keyLen < comparator.getNormalizeKeyLen()) {
            Assertions.assertThat((boolean)comparator.isNormalizedKeyPrefixOnly(keyLen)).isTrue();
        }
        if (halfLength) {
            Assertions.assertThat((boolean)comparator.isNormalizedKeyPrefixOnly(keyLen /= 2)).isTrue();
        }
        return keyLen;
    }

    @Test
    protected void testNormalizedKeysEqualsFullLength() {
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comparator = this.getComparator(ascending);
        if (!comparator.supportsNormalizedKey()) {
            return;
        }
        this.testNormalizedKeysEquals(false);
    }

    @Test
    protected void testNormalizedKeysEqualsHalfLength() {
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comparator = this.getComparator(ascending);
        if (!comparator.supportsNormalizedKey()) {
            return;
        }
        this.testNormalizedKeysEquals(true);
    }

    public void testNormalizedKeysEquals(boolean halfLength) {
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comparator = this.getComparator(ascending);
        T[] data = this.getSortedData();
        int normKeyLen = this.getNormKeyLen(halfLength, data, comparator);
        MemorySegment memSeg1 = this.setupNormalizedKeysMemSegment(data, normKeyLen, comparator);
        MemorySegment memSeg2 = this.setupNormalizedKeysMemSegment(data, normKeyLen, comparator);
        for (int i = 0; i < data.length; ++i) {
            Assertions.assertThat((int)memSeg1.compare(memSeg2, i * normKeyLen, i * normKeyLen, normKeyLen)).isZero();
        }
    }

    @Test
    protected void testNormalizedKeysGreatSmallFullLength() {
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comparator = this.getComparator(ascending);
        if (!comparator.supportsNormalizedKey()) {
            return;
        }
        this.testNormalizedKeysGreatSmall(true, comparator, false);
        this.testNormalizedKeysGreatSmall(false, comparator, false);
    }

    @Test
    protected void testNormalizedKeysGreatSmallAscDescHalfLength() {
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comparator = this.getComparator(ascending);
        if (!comparator.supportsNormalizedKey()) {
            return;
        }
        this.testNormalizedKeysGreatSmall(true, comparator, true);
        this.testNormalizedKeysGreatSmall(false, comparator, true);
    }

    protected void testNormalizedKeysGreatSmall(boolean greater, TypeComparator<T> comparator, boolean halfLength) {
        T[] data = this.getSortedData();
        int normKeyLen = this.getNormKeyLen(halfLength, data, comparator);
        MemorySegment memSegLow = this.setupNormalizedKeysMemSegment(data, normKeyLen, comparator);
        MemorySegment memSegHigh = this.setupNormalizedKeysMemSegment(data, normKeyLen, comparator);
        boolean fullyDetermines = !comparator.isNormalizedKeyPrefixOnly(normKeyLen);
        for (int l = 0; l < data.length - 1; ++l) {
            for (int h = l + 1; h < data.length; ++h) {
                int cmp;
                if (greater) {
                    cmp = memSegLow.compare(memSegHigh, l * normKeyLen, h * normKeyLen, normKeyLen);
                    if (fullyDetermines) {
                        Assertions.assertThat((int)cmp).isNegative();
                        continue;
                    }
                    Assertions.assertThat((int)cmp).isLessThanOrEqualTo(0);
                    continue;
                }
                cmp = memSegHigh.compare(memSegLow, h * normKeyLen, l * normKeyLen, normKeyLen);
                if (fullyDetermines) {
                    Assertions.assertThat((int)cmp).isPositive();
                    continue;
                }
                Assertions.assertThat((int)cmp).isGreaterThanOrEqualTo(0);
            }
        }
    }

    @Test
    protected void testNormalizedKeyReadWriter() throws IOException {
        T[] data = this.getSortedData();
        T reuse = this.getSortedData()[0];
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comp1 = this.getComparator(ascending);
        if (!comp1.supportsSerializationWithKeyNormalization()) {
            return;
        }
        TypeComparator comp2 = comp1.duplicate();
        comp2.setReference(reuse);
        TestOutputView out = new TestOutputView();
        for (T value : data) {
            comp1.setReference(value);
            comp1.writeWithKeyNormalization(value, (DataOutputView)out);
            TestInputView in = out.getInputView();
            comp1.readWithKeyDenormalization(reuse, (DataInputView)in);
            Assertions.assertThat((int)comp1.compareToReference(comp2)).isZero();
        }
    }

    @Test
    public void testKeyExtraction() {
        T[] data;
        boolean ascending = ComparatorTestBase.isAscending(this.getTestedOrder()[0]);
        TypeComparator<T> comparator = this.getComparator(ascending);
        for (T value : data = this.getSortedData()) {
            TypeComparator[] comparators = comparator.getFlatComparators();
            Object[] extractedKeys = new Object[comparators.length];
            int insertedKeys = comparator.extractKeys(value, extractedKeys, 0);
            Assertions.assertThat((int)insertedKeys).isEqualTo(comparators.length);
            for (int i = 0; i < insertedKeys; ++i) {
                if (!this.supportsNullKeys()) {
                    Assertions.assertThat((Object)extractedKeys[i]).isNotNull();
                }
                Assertions.assertThat((int)comparators[i].compare(extractedKeys[i], extractedKeys[i])).isZero();
            }
        }
    }

    protected void deepEquals(String message, T should, T is) {
        ((ObjectAssert)Assertions.assertThat(is).as(message, new Object[0])).isEqualTo(should);
    }

    protected TypeComparator<T> getComparator(boolean ascending) {
        TypeComparator<T> comparator = this.createComparator(ascending);
        if (comparator == null) {
            throw new RuntimeException("Test case corrupt. Returns null as comparator.");
        }
        return comparator;
    }

    protected T[] getSortedData() {
        T[] data = this.getSortedTestData();
        if (data == null) {
            throw new RuntimeException("Test case corrupt. Returns null as test data.");
        }
        if (data.length < 2) {
            throw new RuntimeException("Test case does not provide enough sorted test data.");
        }
        return data;
    }

    protected TypeSerializer<T> getSerializer() {
        TypeSerializer<T> serializer = this.createSerializer();
        if (serializer == null) {
            throw new RuntimeException("Test case corrupt. Returns null as serializer.");
        }
        return serializer;
    }

    protected void writeSortedData(T value, TestOutputView out) throws IOException {
        TypeSerializer<T> serializer = this.getSerializer();
        serializer.serialize(value, (DataOutputView)out);
        TestInputView in = out.getInputView();
        ((AbstractIntegerAssert)Assertions.assertThat((int)in.available()).as("No data available during deserialization.", new Object[0])).isPositive();
        Object deserialized = serializer.deserialize(serializer.createInstance(), (DataInputView)in);
        this.deepEquals("Deserialized value is wrong.", value, deserialized);
    }

    protected boolean supportsNullKeys() {
        return false;
    }

    private static boolean isAscending(Order order) {
        return order == Order.ASCENDING;
    }

    public static final class TestInputView
    extends DataInputStream
    implements DataInputView {
        public TestInputView(byte[] data) {
            super(new ByteArrayInputStream(data));
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            while (numBytes > 0) {
                int skipped = this.skipBytes(numBytes);
                numBytes -= skipped;
            }
        }
    }

    public static final class TestOutputView
    extends DataOutputStream
    implements DataOutputView {
        public TestOutputView() {
            super(new ByteArrayOutputStream(4096));
        }

        public TestInputView getInputView() {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
            return new TestInputView(baos.toByteArray());
        }

        public void skipBytesToWrite(int numBytes) throws IOException {
            for (int i = 0; i < numBytes; ++i) {
                this.write(0);
            }
        }

        public void write(DataInputView source, int numBytes) throws IOException {
            byte[] buffer = new byte[numBytes];
            source.readFully(buffer);
            this.write(buffer);
        }
    }
}

