/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeSerializerSnapshotTest {
    TypeSerializerSnapshotTest() {
    }

    @Test
    void testNestedSchemaCompatibility() {
        final NotCompletedTypeSerializerSnapshot innerSnapshot = new NotCompletedTypeSerializerSnapshot(){

            @Override
            public TypeSerializerSchemaCompatibility<Integer> resolveSchemaCompatibility(TypeSerializerSnapshot<Integer> oldSerializerSnapshot) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
        };
        NotCompletedTypeSerializerSnapshot outerSnapshot = new NotCompletedTypeSerializerSnapshot(){

            @Override
            public TypeSerializerSchemaCompatibility<Integer> resolveSchemaCompatibility(TypeSerializerSnapshot<Integer> newSerializer) {
                return innerSnapshot.resolveSchemaCompatibility(innerSnapshot);
            }
        };
        Assertions.assertThat((boolean)outerSnapshot.resolveSchemaCompatibility(outerSnapshot).isCompatibleAsIs()).isTrue();
    }

    private static class NotCompletedTypeSerializerSnapshot
    implements TypeSerializerSnapshot<Integer> {
        private NotCompletedTypeSerializerSnapshot() {
        }

        public int getCurrentVersion() {
            return 0;
        }

        public void writeSnapshot(DataOutputView out) {
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) {
        }

        public TypeSerializer<Integer> restoreSerializer() {
            return new NotCompletedTypeSerializer(){

                @Override
                public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
                    return this;
                }
            };
        }

        public TypeSerializerSchemaCompatibility<Integer> resolveSchemaCompatibility(TypeSerializerSnapshot<Integer> oldSerializerSnapshot) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
    }

    private static class NotCompletedTypeSerializer
    extends TypeSerializer<Integer> {
        private NotCompletedTypeSerializer() {
        }

        public boolean isImmutableType() {
            return true;
        }

        public TypeSerializer<Integer> duplicate() {
            return this;
        }

        public Integer createInstance() {
            return 0;
        }

        public Integer copy(Integer from) {
            return from;
        }

        public Integer copy(Integer from, Integer reuse) {
            return from;
        }

        public int getLength() {
            return 1;
        }

        public void serialize(Integer record, DataOutputView target) {
        }

        public Integer deserialize(DataInputView source) {
            return 0;
        }

        public Integer deserialize(Integer reuse, DataInputView source) {
            return reuse;
        }

        public void copy(DataInputView source, DataOutputView target) {
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
            return new NotCompletedTypeSerializerSnapshot(){

                @Override
                public TypeSerializer<Integer> restoreSerializer() {
                    return this;
                }
            };
        }
    }
}

