/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PojoTypeInformationTest {
    PojoTypeInformationTest() {
    }

    @Test
    void testSimplePojoTypeExtraction() {
        TypeInformation type = TypeExtractor.getForClass(SimplePojo.class);
        Assertions.assertThat((Object)type).isInstanceOf(CompositeType.class);
    }

    @Test
    void testNestedPojoTypeExtraction() {
        TypeInformation type = TypeExtractor.getForClass(NestedPojoOuter.class);
        Assertions.assertThat((Object)type).isInstanceOf(CompositeType.class);
    }

    @Test
    void testRecursivePojoTypeExtraction() {
        TypeInformation type = TypeExtractor.getForClass(Recursive1Pojo.class);
        Assertions.assertThat((Object)type).isInstanceOf(CompositeType.class);
    }

    @Test
    void testRecursivePojoObjectTypeExtraction() {
        TypeInformation type = TypeExtractor.getForObject((Object)new Recursive1Pojo());
        Assertions.assertThat((Object)type).isInstanceOf(CompositeType.class);
    }

    public static class Recursive2Pojo {
        public String strField;
        public Recursive1Pojo rec;
    }

    public static class Recursive1Pojo {
        public Integer intField;
        public Recursive2Pojo rec;
    }

    public static class NestedPojoOuter {
        public Integer intField;
        public NestedPojoInner inner;
    }

    public static class NestedPojoInner {
        public String field;
    }

    public static class SimplePojo {
        public String str;
        public Boolean Bl;
        public boolean bl;
        public Byte Bt;
        public byte bt;
        public Short Shrt;
        public short shrt;
        public Integer Intgr;
        public int intgr;
        public Long Lng;
        public long lng;
        public Float Flt;
        public float flt;
        public Double Dbl;
        public double dbl;
        public Character Ch;
        public char ch;
        public int[] primIntArray;
        public Integer[] intWrapperArray;
    }
}

