/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichCoGroupFunction;
import org.apache.flink.api.common.functions.RichCrossFunction;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.functions.RichJoinFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple0;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.api.java.typeutils.EnumTypeInfo;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.SetTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.Either;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Row;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeExtractorTest {
    @Test
    void testBasicType() {
        RichGroupReduceFunction<Boolean, Boolean> function = new RichGroupReduceFunction<Boolean, Boolean>(){
            private static final long serialVersionUID = 1L;

            public void reduce(Iterable<Boolean> values, Collector<Boolean> out) throws Exception {
            }
        };
        TypeInformation ti = TypeExtractor.getGroupReduceReturnTypes((GroupReduceFunction)function, (TypeInformation)Types.BOOLEAN);
        Assertions.assertThat((boolean)ti.isBasicType()).isTrue();
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Class)ti.getTypeClass()).isEqualTo(Boolean.class);
        Assertions.assertThat((boolean)TypeExtractor.getForClass(Boolean.class).isBasicType()).isTrue();
        Assertions.assertThat((Object)TypeExtractor.getForClass(Boolean.class)).isEqualTo((Object)ti);
        Assertions.assertThat((Object)TypeExtractor.getForObject((Object)true)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testTupleWithBasicTypes() throws Exception {
        RichMapFunction<Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>, Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>> function = new RichMapFunction<Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>, Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>>(){
            private static final long serialVersionUID = 1L;

            public Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte> map(Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(9);
        Assertions.assertThat((Object)ti).isInstanceOf(TupleTypeInfo.class);
        ArrayList ffd = new ArrayList();
        ((TupleTypeInfo)ti).getFlatFields("f3", 0, ffd);
        Assertions.assertThat(ffd).hasSize(1);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition()).isEqualTo(3);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(Tuple9.class);
        for (int i = 0; i < 9; ++i) {
            Assertions.assertThat((boolean)(tti.getTypeAt(i) instanceof BasicTypeInfo)).isTrue();
        }
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(3)).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(4)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(5)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(6)).isEqualTo((Object)BasicTypeInfo.CHAR_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(7)).isEqualTo((Object)BasicTypeInfo.SHORT_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(8)).isEqualTo((Object)BasicTypeInfo.BYTE_TYPE_INFO);
        Tuple9 t = new Tuple9((Object)1, (Object)1L, (Object)1.0, (Object)Float.valueOf(1.0f), (Object)false, (Object)"Hello World", (Object)Character.valueOf('w'), (Object)1, (Object)1);
        Assertions.assertThat((boolean)(TypeExtractor.getForObject((Object)t) instanceof TupleTypeInfo)).isTrue();
        TupleTypeInfo tti2 = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        Assertions.assertThat((Object)tti2.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(3)).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(4)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(5)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(6)).isEqualTo((Object)BasicTypeInfo.CHAR_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(7)).isEqualTo((Object)BasicTypeInfo.SHORT_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(8)).isEqualTo((Object)BasicTypeInfo.BYTE_TYPE_INFO);
        try {
            TypeExtractor.getForClass(Tuple9.class);
            Assertions.fail((String)"Exception expected here");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    void testTupleWithTuples() {
        RichFlatMapFunction<Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>, Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>> function = new RichFlatMapFunction<Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>, Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>>(){
            private static final long serialVersionUID = 1L;

            public void flatMap(Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>> value, Collector<Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>> out) throws Exception {
            }
        };
        TypeInformation ti = TypeExtractor.getFlatMapReturnTypes((FlatMapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)ti).isInstanceOf(TupleTypeInfo.class);
        ArrayList ffd = new ArrayList();
        ((TupleTypeInfo)ti).getFlatFields("f0.f0", 0, ffd);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition()).isZero();
        ffd.clear();
        ((TupleTypeInfo)ti).getFlatFields("f0.f0", 0, ffd);
        Assertions.assertThat((boolean)(((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType() instanceof BasicTypeInfo)).isTrue();
        Assertions.assertThat((Class)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType().getTypeClass()).isEqualTo(String.class);
        ffd.clear();
        ((TupleTypeInfo)ti).getFlatFields("f1.f0", 0, ffd);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition()).isOne();
        ffd.clear();
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(Tuple3.class);
        Assertions.assertThat((boolean)tti.getTypeAt(0).isTupleType()).isTrue();
        Assertions.assertThat((boolean)tti.getTypeAt(1).isTupleType()).isTrue();
        Assertions.assertThat((boolean)tti.getTypeAt(2).isTupleType()).isTrue();
        Assertions.assertThat((Class)tti.getTypeAt(0).getTypeClass()).isEqualTo(Tuple1.class);
        Assertions.assertThat((Class)tti.getTypeAt(1).getTypeClass()).isEqualTo(Tuple1.class);
        Assertions.assertThat((Class)tti.getTypeAt(2).getTypeClass()).isEqualTo(Tuple2.class);
        Assertions.assertThat((int)tti.getTypeAt(0).getArity()).isOne();
        Assertions.assertThat((int)tti.getTypeAt(1).getArity()).isOne();
        Assertions.assertThat((int)tti.getTypeAt(2).getArity()).isEqualTo(2);
        Assertions.assertThat((Object)((TupleTypeInfo)tti.getTypeAt(0)).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)((TupleTypeInfo)tti.getTypeAt(1)).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)((TupleTypeInfo)tti.getTypeAt(2)).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)((TupleTypeInfo)tti.getTypeAt(2)).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Tuple3 t = new Tuple3((Object)new Tuple1((Object)"hello"), (Object)new Tuple1((Object)1), (Object)new Tuple2((Object)2L, (Object)3L));
        Assertions.assertThat((boolean)(TypeExtractor.getForObject((Object)t) instanceof TupleTypeInfo)).isTrue();
        TupleTypeInfo tti2 = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        Assertions.assertThat((int)tti2.getTypeAt(0).getArity()).isOne();
        Assertions.assertThat((int)tti2.getTypeAt(1).getArity()).isOne();
        Assertions.assertThat((int)tti2.getTypeAt(2).getArity()).isEqualTo(2);
        Assertions.assertThat((Object)((TupleTypeInfo)tti2.getTypeAt(0)).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)((TupleTypeInfo)tti2.getTypeAt(1)).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)((TupleTypeInfo)tti2.getTypeAt(2)).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)((TupleTypeInfo)tti2.getTypeAt(2)).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
    }

    @Test
    void testTuple0() {
        RichFlatMapFunction<Tuple0, Tuple0> function = new RichFlatMapFunction<Tuple0, Tuple0>(){
            private static final long serialVersionUID = 1L;

            public void flatMap(Tuple0 value, Collector<Tuple0> out) throws Exception {
            }
        };
        TypeInformation ti = TypeExtractor.getFlatMapReturnTypes((FlatMapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple0>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isZero();
        Assertions.assertThat((Object)ti).isInstanceOf(TupleTypeInfo.class);
    }

    @Test
    void testSubclassOfTuple() {
        RichFlatJoinFunction<CustomTuple, String, CustomTuple> function = new RichFlatJoinFunction<CustomTuple, String, CustomTuple>(){
            private static final long serialVersionUID = 1L;

            public void join(CustomTuple first, String second, Collector<CustomTuple> out) throws Exception {
                out.collect(null);
            }
        };
        TypeInformation ti = TypeExtractor.getFlatJoinReturnTypes((FlatJoinFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Integer>>(){}), (TypeInformation)Types.STRING);
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Class)((TupleTypeInfo)ti).getTypeClass()).isEqualTo(CustomTuple.class);
        CustomTuple t = new CustomTuple("hello", 1);
        TypeInformation ti2 = TypeExtractor.getForObject((Object)((Object)t));
        Assertions.assertThat((boolean)ti2.isTupleType()).isTrue();
        Assertions.assertThat((int)ti2.getArity()).isEqualTo(2);
        Assertions.assertThat((Object)((TupleTypeInfo)ti2).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)((TupleTypeInfo)ti2).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Class)((TupleTypeInfo)ti2).getTypeClass()).isEqualTo(CustomTuple.class);
    }

    @Test
    void testPojo() {
        RichCrossFunction<CustomType, Integer, CustomType> function = new RichCrossFunction<CustomType, Integer, CustomType>(){
            private static final long serialVersionUID = 1L;

            public CustomType cross(CustomType first, Integer second) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getCrossReturnTypes((CrossFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<CustomType>(){}), (TypeInformation)Types.INT);
        Assertions.assertThat((boolean)ti.isBasicType()).isFalse();
        Assertions.assertThat((boolean)ti.isTupleType()).isFalse();
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat((Class)ti.getTypeClass()).isEqualTo(CustomType.class);
        Assertions.assertThat((boolean)(TypeExtractor.getForClass(CustomType.class) instanceof PojoTypeInfo)).isTrue();
        Assertions.assertThat((Class)ti.getTypeClass()).isEqualTo((Object)TypeExtractor.getForClass(CustomType.class).getTypeClass());
        CustomType t = new CustomType("World", 1);
        TypeInformation ti2 = TypeExtractor.getForObject((Object)t);
        Assertions.assertThat((boolean)ti2.isBasicType()).isFalse();
        Assertions.assertThat((boolean)ti2.isTupleType()).isFalse();
        Assertions.assertThat((Object)ti2).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat((Class)ti2.getTypeClass()).isEqualTo(CustomType.class);
        Assertions.assertThat((boolean)(TypeExtractor.getForClass(PojoWithNonPublicDefaultCtor.class) instanceof PojoTypeInfo)).isFalse();
    }

    @Test
    void testMethodChainingPojo() {
        CustomChainingPojoType t = new CustomChainingPojoType();
        t.setMyField1("World").setMyField2(1);
        TypeInformation ti = TypeExtractor.getForObject((Object)t);
        Assertions.assertThat((boolean)ti.isBasicType()).isFalse();
        Assertions.assertThat((boolean)ti.isTupleType()).isFalse();
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat((Class)ti.getTypeClass()).isEqualTo(CustomChainingPojoType.class);
    }

    @Test
    void testRow() {
        Row row = new Row(2);
        row.setField(0, (Object)"string");
        row.setField(1, (Object)15);
        TypeInformation rowInfo = TypeExtractor.getForObject((Object)row);
        Assertions.assertThat(rowInfo.getClass()).isEqualTo(RowTypeInfo.class);
        Assertions.assertThat((int)rowInfo.getArity()).isEqualTo(2);
        Assertions.assertThat((Object)rowInfo).isEqualTo((Object)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO}));
        Row nullRow = new Row(2);
        TypeInformation genericRowInfo = TypeExtractor.getForObject((Object)nullRow);
        Assertions.assertThat((Object)new GenericTypeInfo(Row.class)).isEqualTo((Object)genericRowInfo);
    }

    @Test
    void testTupleWithPojo() {
        RichMapFunction<Tuple2<Long, CustomType>, Tuple2<Long, CustomType>> function = new RichMapFunction<Tuple2<Long, CustomType>, Tuple2<Long, CustomType>>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<Long, CustomType> map(Tuple2<Long, CustomType> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, CustomType>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(Tuple2.class);
        ArrayList ffd = new ArrayList();
        tti.getFlatFields("f0", 0, ffd);
        Assertions.assertThat(ffd).hasSize(1);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition()).isZero();
        Assertions.assertThat((Class)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType().getTypeClass()).isEqualTo(Long.class);
        ffd.clear();
        tti.getFlatFields("f1.myField1", 0, ffd);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition()).isOne();
        Assertions.assertThat((Class)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType().getTypeClass()).isEqualTo(String.class);
        ffd.clear();
        tti.getFlatFields("f1.myField2", 0, ffd);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition()).isEqualTo(2);
        Assertions.assertThat((Class)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType().getTypeClass()).isEqualTo(Integer.class);
        Assertions.assertThat((Class)tti.getTypeAt(0).getTypeClass()).isEqualTo(Long.class);
        Assertions.assertThat((boolean)(tti.getTypeAt(1) instanceof PojoTypeInfo)).isTrue();
        Assertions.assertThat((Class)tti.getTypeAt(1).getTypeClass()).isEqualTo(CustomType.class);
        Tuple2 t = new Tuple2((Object)1L, (Object)new CustomType("Hello", 1));
        TypeInformation ti2 = TypeExtractor.getForObject((Object)t);
        Assertions.assertThat((boolean)ti2.isTupleType()).isTrue();
        Assertions.assertThat((int)ti2.getArity()).isEqualTo(2);
        TupleTypeInfo tti2 = (TupleTypeInfo)ti2;
        Assertions.assertThat((Class)tti2.getTypeClass()).isEqualTo(Tuple2.class);
        Assertions.assertThat((Class)tti2.getTypeAt(0).getTypeClass()).isEqualTo(Long.class);
        Assertions.assertThat((boolean)(tti2.getTypeAt(1) instanceof PojoTypeInfo)).isTrue();
        Assertions.assertThat((Class)tti2.getTypeAt(1).getTypeClass()).isEqualTo(CustomType.class);
    }

    @Test
    void testValue() {
        KeySelector<StringValue, StringValue> function = new KeySelector<StringValue, StringValue>(){
            private static final long serialVersionUID = 1L;

            public StringValue getKey(StringValue value) {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getKeySelectorTypes((KeySelector)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<StringValue>(){}));
        Assertions.assertThat((boolean)ti.isBasicType()).isFalse();
        Assertions.assertThat((boolean)ti.isTupleType()).isFalse();
        Assertions.assertThat((Object)ti).isInstanceOf(ValueTypeInfo.class);
        Assertions.assertThat((Class)ti.getTypeClass()).isEqualTo(StringValue.class);
        Assertions.assertThat((boolean)(TypeExtractor.getForClass(StringValue.class) instanceof ValueTypeInfo)).isTrue();
        Assertions.assertThat((Class)ti.getTypeClass()).isEqualTo((Object)TypeExtractor.getForClass(StringValue.class).getTypeClass());
        StringValue v = new StringValue((CharSequence)"Hello");
        Assertions.assertThat((boolean)(TypeExtractor.getForObject((Object)v) instanceof ValueTypeInfo)).isTrue();
        Assertions.assertThat((Class)ti.getTypeClass()).isEqualTo((Object)TypeExtractor.getForObject((Object)v).getTypeClass());
    }

    @Test
    void testTupleOfValues() {
        RichMapFunction<Tuple2<StringValue, IntValue>, Tuple2<StringValue, IntValue>> function = new RichMapFunction<Tuple2<StringValue, IntValue>, Tuple2<StringValue, IntValue>>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<StringValue, IntValue> map(Tuple2<StringValue, IntValue> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<StringValue, IntValue>>(){}));
        Assertions.assertThat((boolean)ti.isBasicType()).isFalse();
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((Class)((TupleTypeInfo)ti).getTypeAt(0).getTypeClass()).isEqualTo(StringValue.class);
        Assertions.assertThat((Class)((TupleTypeInfo)ti).getTypeAt(1).getTypeClass()).isEqualTo(IntValue.class);
        Tuple2 t = new Tuple2((Object)new StringValue((CharSequence)"x"), (Object)new IntValue(1));
        TypeInformation ti2 = TypeExtractor.getForObject((Object)t);
        Assertions.assertThat((boolean)ti2.isBasicType()).isFalse();
        Assertions.assertThat((boolean)ti2.isTupleType()).isTrue();
        Assertions.assertThat((Class)((TupleTypeInfo)ti2).getTypeAt(0).getTypeClass()).isEqualTo(StringValue.class);
        Assertions.assertThat((Class)((TupleTypeInfo)ti2).getTypeAt(1).getTypeClass()).isEqualTo(IntValue.class);
    }

    @Test
    void testGenericsNotInSuperclass() {
        RichMapFunction<LongKeyValue<String>, LongKeyValue<String>> function = new RichMapFunction<LongKeyValue<String>, LongKeyValue<String>>(){
            private static final long serialVersionUID = 1L;

            public LongKeyValue<String> map(LongKeyValue<String> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, String>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(LongKeyValue.class);
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testChainedGenericsNotInSuperclass() {
        RichMapFunction<ChainedTwo<Integer>, ChainedTwo<Integer>> function = new RichMapFunction<ChainedTwo<Integer>, ChainedTwo<Integer>>(){
            private static final long serialVersionUID = 1L;

            public ChainedTwo<Integer> map(ChainedTwo<Integer> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<String, Long, Integer>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(3);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(ChainedTwo.class);
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testGenericsInDirectSuperclass() {
        RichMapFunction<ChainedThree, ChainedThree> function = new RichMapFunction<ChainedThree, ChainedThree>(){
            private static final long serialVersionUID = 1L;

            public ChainedThree map(ChainedThree value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<String, Long, String>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(3);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(ChainedThree.class);
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testGenericsNotInSuperclassWithNonGenericClassAtEnd() {
        RichMapFunction<ChainedFour, ChainedFour> function = new RichMapFunction<ChainedFour, ChainedFour>(){
            private static final long serialVersionUID = 1L;

            public ChainedFour map(ChainedFour value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<String, Long, String>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(3);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(ChainedFour.class);
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testMissingTupleGenerics() {
        RichMapFunction<String, Tuple2> function = new RichMapFunction<String, Tuple2>(){
            private static final long serialVersionUID = 1L;

            public Tuple2 map(String value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)Types.STRING, (String)"name", (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(MissingTypeInfo.class);
        Assertions.assertThatThrownBy(() -> TypeExtractorTest.lambda$testMissingTupleGenerics$0((RichMapFunction)function)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testTupleSupertype() {
        RichMapFunction<String, Tuple> function = new RichMapFunction<String, Tuple>(){
            private static final long serialVersionUID = 1L;

            public Tuple map(String value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)Types.STRING, (String)"name", (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(MissingTypeInfo.class);
        Assertions.assertThatThrownBy(() -> TypeExtractorTest.lambda$testTupleSupertype$1((RichMapFunction)function)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testSameGenericVariable() {
        RichMapFunction<SameTypeVariable<String>, SameTypeVariable<String>> function = new RichMapFunction<SameTypeVariable<String>, SameTypeVariable<String>>(){
            private static final long serialVersionUID = 1L;

            public SameTypeVariable<String> map(SameTypeVariable<String> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, String>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(SameTypeVariable.class);
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testNestedTupleGenerics() {
        RichMapFunction<Nested<String, Integer>, Nested<String, Integer>> function = new RichMapFunction<Nested<String, Integer>, Nested<String, Integer>>(){
            private static final long serialVersionUID = 1L;

            public Nested<String, Integer> map(Nested<String, Integer> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Tuple2<Integer, Integer>>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Class)tti.getTypeClass()).isEqualTo(Nested.class);
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((boolean)tti.getTypeAt(1).isTupleType()).isTrue();
        Assertions.assertThat((int)tti.getTypeAt(1).getArity()).isEqualTo(2);
        TupleTypeInfo tti2 = (TupleTypeInfo)tti.getTypeAt(1);
        Assertions.assertThat((Class)tti2.getTypeClass()).isEqualTo(Tuple2.class);
        Assertions.assertThat((Object)tti2.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testNestedTupleGenerics2() {
        RichMapFunction<Nested2<Boolean>, Nested2<Boolean>> function = new RichMapFunction<Nested2<Boolean>, Nested2<Boolean>>(){
            private static final long serialVersionUID = 1L;

            public Nested2<Boolean> map(Nested2<Boolean> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Boolean, Tuple2<Tuple2<Integer, Tuple2<Boolean, Boolean>>, Tuple2<Integer, Tuple2<Boolean, Boolean>>>>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((boolean)tti.getTypeAt(1).isTupleType()).isTrue();
        TupleTypeInfo tti2 = (TupleTypeInfo)tti.getTypeAt(1);
        Assertions.assertThat((boolean)tti2.getTypeAt(0).isTupleType()).isTrue();
        Assertions.assertThat((boolean)tti2.getTypeAt(1).isTupleType()).isTrue();
        TupleTypeInfo tti3 = (TupleTypeInfo)tti2.getTypeAt(0);
        Assertions.assertThat((Object)tti3.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((boolean)tti3.getTypeAt(1).isTupleType()).isTrue();
        TupleTypeInfo tti4 = (TupleTypeInfo)tti3.getTypeAt(1);
        Assertions.assertThat((Object)tti4.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)tti4.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testFunctionWithMissingGenerics() {
        RichMapFunction function = new RichMapFunction(){
            private static final long serialVersionUID = 1L;

            public String map(Object value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)Types.STRING, (String)"name", (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(MissingTypeInfo.class);
        Assertions.assertThatThrownBy(() -> TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)Types.STRING)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testFunctionDependingOnInputAsSuperclass() {
        IdentityMapper<Boolean> function = new IdentityMapper<Boolean>(){
            private static final long serialVersionUID = 1L;
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)Types.BOOLEAN);
        Assertions.assertThat((boolean)ti.isBasicType()).isTrue();
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testFunctionDependingOnInputFromInput() {
        IdentityMapper function = new IdentityMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((boolean)ti.isBasicType()).isTrue();
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testFunctionDependingOnInputWithMissingInput() {
        IdentityMapper function = new IdentityMapper();
        Assertions.assertThatThrownBy(() -> TypeExtractor.getMapReturnTypes((MapFunction)function, null)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testFunctionDependingOnInputWithTupleInput() {
        IdentityMapper2 function = new IdentityMapper2();
        TupleTypeInfo inputType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)inputType);
        Assertions.assertThat((boolean)ti.isBasicType()).isTrue();
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testFunctionDependingOnInputWithCustomTupleInput() {
        IdentityMapper function = new IdentityMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, String>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testFunctionDependingOnUnknownInput() {
        IdentityMapper3 function = new IdentityMapper3();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO, (String)"name", (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(MissingTypeInfo.class);
        Assertions.assertThatThrownBy(() -> TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testFunctionDependingOnInputWithFunctionHierarchy() {
        IdentityMapper4 function = new IdentityMapper4();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testFunctionDependingOnInputWithFunctionHierarchy2() {
        IdentityMapper5 function = new IdentityMapper5();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testFunctionWithNoGenericSuperclass() {
        Mapper2 function = new Mapper2();
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)Types.STRING);
        Assertions.assertThat((boolean)ti.isBasicType()).isTrue();
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testFunctionDependingPartialOnInput() {
        OneAppender<DoubleValue> function = new OneAppender<DoubleValue>(){
            private static final long serialVersionUID = 1L;
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<DoubleValue>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((boolean)(tti.getTypeAt(0) instanceof ValueTypeInfo)).isTrue();
        ValueTypeInfo vti = (ValueTypeInfo)tti.getTypeAt(0);
        Assertions.assertThat((Class)vti.getTypeClass()).isEqualTo(DoubleValue.class);
        Assertions.assertThat((boolean)tti.getTypeAt(1).isBasicType()).isTrue();
        Assertions.assertThat((Class)tti.getTypeAt(1).getTypeClass()).isEqualTo(Integer.class);
    }

    @Test
    void testFunctionDependingPartialOnInput2() {
        OneAppender function = new OneAppender();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)new ValueTypeInfo(DoubleValue.class));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((boolean)(tti.getTypeAt(0) instanceof ValueTypeInfo)).isTrue();
        ValueTypeInfo vti = (ValueTypeInfo)tti.getTypeAt(0);
        Assertions.assertThat((Class)vti.getTypeClass()).isEqualTo(DoubleValue.class);
        Assertions.assertThat((boolean)tti.getTypeAt(1).isBasicType()).isTrue();
        Assertions.assertThat((Class)tti.getTypeAt(1).getTypeClass()).isEqualTo(Integer.class);
    }

    @Test
    void testFunctionInputInOutputMultipleTimes() {
        FieldDuplicator function = new FieldDuplicator();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.FLOAT_TYPE_INFO);
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
    }

    @Test
    void testFunctionInputInOutputMultipleTimes2() {
        FieldDuplicator function = new FieldDuplicator();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.FLOAT_TYPE_INFO, BasicTypeInfo.FLOAT_TYPE_INFO}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((boolean)tti.getTypeAt(0).isTupleType()).isTrue();
        TupleTypeInfo tti2 = (TupleTypeInfo)tti.getTypeAt(0);
        Assertions.assertThat((Object)tti2.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
        Assertions.assertThat((Object)tti2.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
        Assertions.assertThat((boolean)tti.getTypeAt(0).isTupleType()).isTrue();
        TupleTypeInfo tti3 = (TupleTypeInfo)tti.getTypeAt(1);
        Assertions.assertThat((Object)tti3.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
        Assertions.assertThat((Object)tti3.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
    }

    @Test
    void testAbstractAndInterfaceTypes() {
        RichMapFunction<String, Testable> function = new RichMapFunction<String, Testable>(){
            private static final long serialVersionUID = 1L;

            public Testable map(String value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isInstanceOf(GenericTypeInfo.class);
        RichMapFunction<String, AbstractClassWithoutMember> function2 = new RichMapFunction<String, AbstractClassWithoutMember>(){
            private static final long serialVersionUID = 1L;

            public AbstractClassWithoutMember map(String value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function2, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isInstanceOf(GenericTypeInfo.class);
        RichMapFunction<String, AbstractClassWithMember> function3 = new RichMapFunction<String, AbstractClassWithMember>(){
            private static final long serialVersionUID = 1L;

            public AbstractClassWithMember map(String value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function3, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
    }

    @Test
    void testValueSupertypeException() {
        RichMapFunction<StringValue, Value> function = new RichMapFunction<StringValue, Value>(){
            private static final long serialVersionUID = 1L;

            public Value map(StringValue value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<StringValue>(){}), (String)"name", (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(MissingTypeInfo.class);
        Assertions.assertThatThrownBy(() -> this.lambda$testValueSupertypeException$5((RichMapFunction)function)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testBasicArray() {
        RichCoGroupFunction<String[], String[], String[]> function = new RichCoGroupFunction<String[], String[], String[]>(){
            private static final long serialVersionUID = 1L;

            public void coGroup(Iterable<String[]> first, Iterable<String[]> second, Collector<String[]> out) throws Exception {
            }
        };
        TypeInformation ti = TypeExtractor.getCoGroupReturnTypes((CoGroupFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<String[]>(){}), (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<String[]>(){}));
        Assertions.assertThat((boolean)ti.isBasicType()).isFalse();
        Assertions.assertThat((boolean)ti.isTupleType()).isFalse();
        Assertions.assertThat((ti instanceof BasicArrayTypeInfo || ti instanceof ObjectArrayTypeInfo ? 1 : 0) != 0).isTrue();
        if (ti instanceof BasicArrayTypeInfo) {
            Assertions.assertThat((Object)ti).isEqualTo((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO);
        } else {
            Assertions.assertThat((Object)((ObjectArrayTypeInfo)ti).getComponentInfo()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    void testBasicArray2() {
        IdentityMapper function = new IdentityMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicArrayTypeInfo.BOOLEAN_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)ti).isInstanceOf(BasicArrayTypeInfo.class);
        BasicArrayTypeInfo bati = (BasicArrayTypeInfo)ti;
        Assertions.assertThat((boolean)bati.getComponentInfo().isBasicType()).isTrue();
        Assertions.assertThat((Object)bati.getComponentInfo()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testCustomArray() {
        RichMapFunction<CustomArrayObject[], CustomArrayObject[]> function = new RichMapFunction<CustomArrayObject[], CustomArrayObject[]>(){
            private static final long serialVersionUID = 1L;

            public CustomArrayObject[] map(CustomArrayObject[] value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<CustomArrayObject[]>(){}));
        Assertions.assertThat((Object)ti).isInstanceOf(ObjectArrayTypeInfo.class);
        Assertions.assertThat((Class)((ObjectArrayTypeInfo)ti).getComponentInfo().getTypeClass()).isEqualTo(CustomArrayObject.class);
    }

    @Test
    void testTupleArray() {
        RichMapFunction<Tuple2<String, String>[], Tuple2<String, String>[]> function = new RichMapFunction<Tuple2<String, String>[], Tuple2<String, String>[]>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<String, String>[] map(Tuple2<String, String>[] value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, String>[]>(){}));
        Assertions.assertThat((Object)ti).isInstanceOf(ObjectArrayTypeInfo.class);
        ObjectArrayTypeInfo oati = (ObjectArrayTypeInfo)ti;
        Assertions.assertThat((boolean)oati.getComponentInfo().isTupleType()).isTrue();
        TupleTypeInfo tti = (TupleTypeInfo)oati.getComponentInfo();
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testCustomArrayWithTypeVariable() {
        IdentityMapper function = new IdentityMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple1<Boolean>[]>(){}));
        Assertions.assertThat((Object)ti).isInstanceOf(ObjectArrayTypeInfo.class);
        ObjectArrayTypeInfo oati = (ObjectArrayTypeInfo)ti;
        Assertions.assertThat((boolean)oati.getComponentInfo().isTupleType()).isTrue();
        TupleTypeInfo tti = (TupleTypeInfo)oati.getComponentInfo();
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testParameterizedArrays() {
        GenericArrayClass<Boolean> function = new GenericArrayClass<Boolean>(){
            private static final long serialVersionUID = 1L;
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Boolean[]>(){}));
        Assertions.assertThat((Object)ti).isInstanceOf(ObjectArrayTypeInfo.class);
        ObjectArrayTypeInfo oati = (ObjectArrayTypeInfo)ti;
        Assertions.assertThat((Object)oati.getComponentInfo()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testParameterizedPojo() {
        RichMapFunction<InType, MyObject<String>> function = new RichMapFunction<InType, MyObject<String>>(){
            private static final long serialVersionUID = 1L;

            public MyObject<String> map(InType value) throws Exception {
                return null;
            }
        };
        TypeInformation inType = TypeExtractor.createTypeInfo(InType.class);
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)inType);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
    }

    @Test
    void testFunctionDependingOnInputWithTupleInputWithTypeMismatch() {
        IdentityMapper2 function = new IdentityMapper2();
        TupleTypeInfo inputType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        Assertions.assertThatThrownBy(() -> TypeExtractorTest.lambda$testFunctionDependingOnInputWithTupleInputWithTypeMismatch$6(function, (TypeInformation)inputType)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testInputMismatchExceptions() {
        RichMapFunction<Tuple2<String, String>, String> function = new RichMapFunction<Tuple2<String, String>, String>(){
            private static final long serialVersionUID = 1L;

            public String map(Tuple2<String, String> value) throws Exception {
                return null;
            }
        };
        Assertions.assertThatThrownBy(() -> this.lambda$testInputMismatchExceptions$7((RichMapFunction)function)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> this.lambda$testInputMismatchExceptions$8((RichMapFunction)function)).isInstanceOf(InvalidTypesException.class);
        RichMapFunction<StringValue, String> function2 = new RichMapFunction<StringValue, String>(){
            private static final long serialVersionUID = 1L;

            public String map(StringValue value) throws Exception {
                return null;
            }
        };
        Assertions.assertThatThrownBy(() -> this.lambda$testInputMismatchExceptions$9((RichMapFunction)function2)).isInstanceOf(InvalidTypesException.class);
        RichMapFunction<Tuple1<Integer>[], String> function3 = new RichMapFunction<Tuple1<Integer>[], String>(){
            private static final long serialVersionUID = 1L;

            public String map(Tuple1<Integer>[] value) throws Exception {
                return null;
            }
        };
        Assertions.assertThatThrownBy(() -> this.lambda$testInputMismatchExceptions$10((RichMapFunction)function3)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testTypeErasure() {
        TypeInformation ti = TypeExtractor.getFlatMapReturnTypes(new DummyFlatMapFunction(), (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Integer>>(){}), (String)"name", (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(MissingTypeInfo.class);
        Assertions.assertThatThrownBy(() -> TypeExtractor.getFlatMapReturnTypes(new DummyFlatMapFunction(), (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Integer>>(){}))).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testResultTypeQueryable() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(new MyQueryableMapper(), (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testTupleWithPrimitiveArray() {
        RichMapFunction<Integer, Tuple9<int[], double[], long[], byte[], char[], float[], short[], boolean[], String[]>> function = new RichMapFunction<Integer, Tuple9<int[], double[], long[], byte[], char[], float[], short[], boolean[], String[]>>(){
            private static final long serialVersionUID = 1L;

            public Tuple9<int[], double[], long[], byte[], char[], float[], short[], boolean[], String[]> map(Integer value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(2)).isEqualTo((Object)PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(3)).isEqualTo((Object)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(4)).isEqualTo((Object)PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(5)).isEqualTo((Object)PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(6)).isEqualTo((Object)PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(7)).isEqualTo((Object)PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(8)).isEqualTo((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO);
    }

    @Test
    void testFunction() {
        RichMapFunction<String, Boolean> mapInterface = new RichMapFunction<String, Boolean>(){
            private static final long serialVersionUID = 1L;

            public void setRuntimeContext(RuntimeContext t) {
            }

            public void open(OpenContext openContext) throws Exception {
            }

            public RuntimeContext getRuntimeContext() {
                return null;
            }

            public void close() throws Exception {
            }

            public Boolean map(String record) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)mapInterface, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testInterface() {
        MapFunction<String, Boolean> mapInterface = new MapFunction<String, Boolean>(){
            private static final long serialVersionUID = 1L;

            public Boolean map(String record) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)mapInterface, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testCreateTypeInfoFromInstance() {
        ResultTypeQueryable<Long> instance = new ResultTypeQueryable<Long>(){

            public TypeInformation<Long> getProducedType() {
                return BasicTypeInfo.LONG_TYPE_INFO;
            }
        };
        TypeInformation ti = TypeExtractor.createTypeInfo((Object)instance, null, null, (int)0);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        MapFunction<Integer, Long> func = new MapFunction<Integer, Long>(){

            public Long map(Integer value) throws Exception {
                return value.longValue();
            }
        };
        ti = TypeExtractor.createTypeInfo((Object)func, MapFunction.class, func.getClass(), (int)0);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testExtractKeySelector() {
        KeySelector<String, Integer> selector = new KeySelector<String, Integer>(){

            public Integer getKey(String value) {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getKeySelectorTypes((KeySelector)selector, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThatThrownBy(() -> TypeExtractorTest.lambda$testExtractKeySelector$12((KeySelector)selector)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testDuplicateValue() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(new DuplicateValue(), (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple1<String>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testDuplicateValueNested() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(new DuplicateValueNested(), (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple1<Tuple1<String>>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testInputInference1() {
        EdgeMapper em = new EdgeMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(em, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<String, String, Double>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(3);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
    }

    @Test
    void testInputInference2() {
        EdgeMapper2 em = new EdgeMapper2();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(em, (TypeInformation)Types.BOOLEAN);
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        Assertions.assertThat((int)ti.getArity()).isEqualTo(3);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testInputInference3() {
        EdgeMapper3 em = new EdgeMapper3();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(em, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<Boolean, Boolean, String>>(){}));
        Assertions.assertThat((boolean)ti.isBasicType()).isTrue();
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testInputInference4() {
        EdgeMapper4 em = new EdgeMapper4();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(em, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<Boolean, Boolean, String>[]>(){}));
        Assertions.assertThat((boolean)ti.isBasicType()).isTrue();
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testInputInferenceWithCustomTupleAndRichFunction() {
        JoinWithCustomTuple2WithArray function = new JoinWithCustomTuple2WithArray();
        TypeInformation ti = TypeExtractor.getJoinReturnTypes(function, (TypeInformation)new TypeHint<CustomTuple2WithArray<Long>>(){}.getTypeInfo(), (TypeInformation)new TypeHint<CustomTuple2WithArray<Long>>(){}.getTypeInfo());
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((boolean)(tti.getTypeAt(0) instanceof ObjectArrayTypeInfo)).isTrue();
        ObjectArrayTypeInfo oati = (ObjectArrayTypeInfo)tti.getTypeAt(0);
        Assertions.assertThat((Object)oati.getComponentInfo()).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
    }

    @Test
    void testEnumType() {
        MapFunction<MyEnum, MyEnum> mf = new MapFunction<MyEnum, MyEnum>(){
            private static final long serialVersionUID = 1L;

            public MyEnum map(MyEnum value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)mf, (TypeInformation)new EnumTypeInfo(MyEnum.class));
        Assertions.assertThat((Object)ti).isInstanceOf(EnumTypeInfo.class);
        Assertions.assertThat((Class)ti.getTypeClass()).isEqualTo(MyEnum.class);
    }

    @Test
    void testMultiDimensionalArray() {
        Object function = new MapFunction<Tuple2<Integer, Double>[][], Tuple2<Integer, Double>[][]>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<Integer, Double>[][] map(Tuple2<Integer, Double>[][] value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, Double>[][]>(){}));
        Assertions.assertThat((String)ti.toString()).isEqualTo("ObjectArrayTypeInfo<ObjectArrayTypeInfo<Java Tuple2<Integer, Double>>>");
        function = new MapFunction<int[][][], int[][][]>(){
            private static final long serialVersionUID = 1L;

            public int[][][] map(int[][][] value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<int[][][]>(){}));
        Assertions.assertThat((Object)ti).hasToString("ObjectArrayTypeInfo<ObjectArrayTypeInfo<int[]>>");
        function = new MapFunction<Integer[][][], Integer[][][]>(){
            private static final long serialVersionUID = 1L;

            public Integer[][][] map(Integer[][][] value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Integer[][][]>(){}));
        Assertions.assertThat((String)ti.toString()).isEqualTo("ObjectArrayTypeInfo<ObjectArrayTypeInfo<BasicArrayTypeInfo<Integer>>>");
        function = new MapFunction<CustomType[][][], CustomType[][][]>(){
            private static final long serialVersionUID = 1L;

            public CustomType[][][] map(CustomType[][][] value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<CustomType[][][]>(){}));
        Assertions.assertThat((String)ti.toString()).isEqualTo("ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<PojoType<org.apache.flink.api.java.typeutils.TypeExtractorTest$CustomType, fields = [myField1: String, myField2: Integer]>>>>");
        ti = TypeExtractor.getMapReturnTypes(new MapperWithMultiDimGenericArray(), (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<String[][][]>(){}));
        Assertions.assertThat((String)ti.toString()).isEqualTo("ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<Java Tuple1<String>>>>");
    }

    @Test
    void testInputMismatchWithRawFuntion() {
        MapWithResultTypeQueryable function = new MapWithResultTypeQueryable();
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testEither() {
        MapFunction<Either<String, Boolean>, Either<String, Boolean>> function = new MapFunction<Either<String, Boolean>, Either<String, Boolean>>(){

            public Either<String, Boolean> map(Either<String, Boolean> value) throws Exception {
                return null;
            }
        };
        EitherTypeInfo expected = new EitherTypeInfo((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)expected);
        Assertions.assertThat((Object)ti).isEqualTo((Object)expected);
    }

    @Test
    void testEitherHierarchy() {
        Object function = new EitherMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        EitherTypeInfo expected = new EitherTypeInfo((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)expected);
        function = new EitherMapper2();
        ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        expected = new EitherTypeInfo((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO}));
        Assertions.assertThat((Object)ti).isEqualTo((Object)expected);
        function = new EitherMapper3();
        ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)expected);
        Assertions.assertThat((Object)ti).isEqualTo((Object)expected);
        Either2 either = new Either2();
        ti = TypeExtractor.getForObject((Object)((Object)either));
        Assertions.assertThat((Object)ti).isEqualTo((Object)expected);
    }

    @Test
    void testEitherFromObjectException() {
        Assertions.assertThatThrownBy(() -> {
            Either either = Either.Left((Object)"test");
            TypeExtractor.getForObject((Object)either);
        }).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testGenericTypeWithSubclassInput() {
        LinkedHashMap<String, String> inputMap = new LinkedHashMap<String, String>();
        inputMap.put("a", "b");
        TypeInformation inputType = TypeExtractor.createTypeInfo(inputMap.getClass());
        MapFunction<HashMap<String, Object>, HashMap<String, Object>> function = new MapFunction<HashMap<String, Object>, HashMap<String, Object>>(){

            public HashMap<String, Object> map(HashMap<String, Object> stringObjectMap) throws Exception {
                return stringObjectMap;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)inputType);
        TypeInformation expected = TypeExtractor.createTypeInfo(HashMap.class);
        Assertions.assertThat((Object)ti).isEqualTo((Object)expected);
    }

    @Test
    void testGenericTypeWithSuperclassInput() {
        Assertions.assertThatThrownBy(() -> {
            TypeInformation inputType = TypeExtractor.createTypeInfo(Map.class);
            MapFunction & Serializable function = (MapFunction & Serializable)stringObjectMap -> stringObjectMap;
            TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)inputType);
        }).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testInputWithCustomTypeInfo() {
        TypeInformation<Object> customTypeInfo = new TypeInformation<Object>(){

            public boolean isBasicType() {
                return true;
            }

            public boolean isTupleType() {
                return true;
            }

            public int getArity() {
                return 0;
            }

            public int getTotalFields() {
                return 0;
            }

            public Class getTypeClass() {
                return null;
            }

            public boolean isKeyType() {
                return false;
            }

            public TypeSerializer<Object> createSerializer(SerializerConfig config) {
                return null;
            }

            public String toString() {
                return null;
            }

            public boolean equals(Object obj) {
                return false;
            }

            public int hashCode() {
                return 0;
            }

            public boolean canEqual(Object obj) {
                return false;
            }
        };
        MapFunction<Tuple1<String>, Tuple1<Object>> function = new MapFunction<Tuple1<String>, Tuple1<Object>>(){

            public Tuple1<Object> map(Tuple1<String> value) throws Exception {
                return null;
            }
        };
        TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{customTypeInfo}));
    }

    @Test
    void testBigBasicTypes() {
        MapFunction<Tuple2<BigInteger, BigDecimal>, Tuple2<BigInteger, BigDecimal>> function = new MapFunction<Tuple2<BigInteger, BigDecimal>, Tuple2<BigInteger, BigDecimal>>(){

            public Tuple2<BigInteger, BigDecimal> map(Tuple2<BigInteger, BigDecimal> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<BigInteger, BigDecimal>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.BIG_INT_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO);
        Assertions.assertThat((boolean)TypeExtractor.getForClass(BigInteger.class).isBasicType()).isTrue();
        Assertions.assertThat((boolean)TypeExtractor.getForClass(BigDecimal.class).isBasicType()).isTrue();
        Assertions.assertThat((Object)TypeExtractor.getForClass(BigInteger.class)).isEqualTo((Object)tti.getTypeAt(0));
        Assertions.assertThat((Object)TypeExtractor.getForClass(BigDecimal.class)).isEqualTo((Object)tti.getTypeAt(1));
        Assertions.assertThat((Object)TypeExtractor.getForObject((Object)new BigInteger("42"))).isEqualTo((Object)BasicTypeInfo.BIG_INT_TYPE_INFO);
        Assertions.assertThat((Object)TypeExtractor.getForObject((Object)new BigDecimal("42.42"))).isEqualTo((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO);
    }

    @Test
    void testSqlTimeTypes() {
        MapFunction<Tuple3<Date, Time, Timestamp>, Tuple3<Date, Time, Timestamp>> function = new MapFunction<Tuple3<Date, Time, Timestamp>, Tuple3<Date, Time, Timestamp>>(){

            public Tuple3<Date, Time, Timestamp> map(Tuple3<Date, Time, Timestamp> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<Date, Time, Timestamp>>(){}));
        Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)SqlTimeTypeInfo.DATE);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)SqlTimeTypeInfo.TIME);
        Assertions.assertThat((Object)tti.getTypeAt(2)).isEqualTo((Object)SqlTimeTypeInfo.TIMESTAMP);
        Assertions.assertThat((Object)TypeExtractor.getForClass(Date.class)).isEqualTo((Object)tti.getTypeAt(0));
        Assertions.assertThat((Object)TypeExtractor.getForClass(Time.class)).isEqualTo((Object)tti.getTypeAt(1));
        Assertions.assertThat((Object)TypeExtractor.getForClass(Timestamp.class)).isEqualTo((Object)tti.getTypeAt(2));
        Assertions.assertThat((Object)TypeExtractor.getForObject((Object)Date.valueOf("1998-12-12"))).isEqualTo((Object)SqlTimeTypeInfo.DATE);
        Assertions.assertThat((Object)TypeExtractor.getForObject((Object)Time.valueOf("12:37:45"))).isEqualTo((Object)SqlTimeTypeInfo.TIME);
        Assertions.assertThat((Object)TypeExtractor.getForObject((Object)Timestamp.valueOf("1998-12-12 12:37:45"))).isEqualTo((Object)SqlTimeTypeInfo.TIMESTAMP);
    }

    @Test
    public <T> void testCollectionTypes() {
        MapFunction function = new MapFunction<PojoWithCollections<T>, PojoWithCollections<T>>(){

            public PojoWithCollections map(PojoWithCollections<T> value) {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithCollections<T>>(){}));
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        this.testCollectionTypesInternal(ti);
        TypeInformation ti2 = TypeExtractor.getForClass(PojoWithCollections.class);
        Assertions.assertThat((Object)ti2).isInstanceOf(PojoTypeInfo.class);
        this.testCollectionTypesInternal(ti2);
        PojoWithCollections t = new PojoWithCollections();
        TypeInformation ti3 = TypeExtractor.getForObject(t);
        Assertions.assertThat((Object)ti3).isInstanceOf(PojoTypeInfo.class);
        this.testCollectionTypesInternal(ti3);
    }

    private void testCollectionTypesInternal(TypeInformation<?> ti) {
        PojoTypeInfo pojoTi = (PojoTypeInfo)ti;
        Assertions.assertThat((Object)pojoTi.getPojoFieldAt(pojoTi.getFieldIndex("mapVal")).getTypeInformation()).isInstanceOf(MapTypeInfo.class);
        Assertions.assertThat((Object)pojoTi.getPojoFieldAt(pojoTi.getFieldIndex("listVal")).getTypeInformation()).isInstanceOf(ListTypeInfo.class);
        Assertions.assertThat((Object)pojoTi.getPojoFieldAt(pojoTi.getFieldIndex("collectionVal")).getTypeInformation()).isInstanceOf(ListTypeInfo.class);
        Assertions.assertThat((Object)pojoTi.getPojoFieldAt(pojoTi.getFieldIndex("setVal")).getTypeInformation()).isInstanceOf(SetTypeInfo.class);
        Assertions.assertThat((Object)pojoTi.getPojoFieldAt(pojoTi.getFieldIndex("linkedListVal")).getTypeInformation()).isInstanceOf(GenericTypeInfo.class);
        Assertions.assertThat((Object)pojoTi.getPojoFieldAt(pojoTi.getFieldIndex("rawListVal")).getTypeInformation()).isInstanceOf(GenericTypeInfo.class);
        Assertions.assertThat((Object)pojoTi.getPojoFieldAt(pojoTi.getFieldIndex("genericListVal")).getTypeInformation()).isInstanceOf(GenericTypeInfo.class);
        Assertions.assertThat((Object)pojoTi.getPojoFieldAt(pojoTi.getFieldIndex("wildcardListVal")).getTypeInformation()).isInstanceOf(GenericTypeInfo.class);
    }

    private static /* synthetic */ void lambda$testExtractKeySelector$12(KeySelector selector) throws Throwable {
        TypeExtractor.getKeySelectorTypes((KeySelector)selector, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    private /* synthetic */ void lambda$testInputMismatchExceptions$10(RichMapFunction function3) throws Throwable {
        TypeExtractor.getMapReturnTypes((MapFunction)function3, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Integer[]>(){}));
    }

    private /* synthetic */ void lambda$testInputMismatchExceptions$9(RichMapFunction function2) throws Throwable {
        TypeExtractor.getMapReturnTypes((MapFunction)function2, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<IntValue>(){}));
    }

    private /* synthetic */ void lambda$testInputMismatchExceptions$8(RichMapFunction function) throws Throwable {
        TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple3<String, String, String>>(){}));
    }

    private /* synthetic */ void lambda$testInputMismatchExceptions$7(RichMapFunction function) throws Throwable {
        TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, String>>(){}));
    }

    private static /* synthetic */ void lambda$testFunctionDependingOnInputWithTupleInputWithTypeMismatch$6(IdentityMapper2 function, TypeInformation inputType) throws Throwable {
        TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)inputType);
    }

    private /* synthetic */ void lambda$testValueSupertypeException$5(RichMapFunction function) throws Throwable {
        TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<StringValue>(){}));
    }

    private static /* synthetic */ void lambda$testTupleSupertype$1(RichMapFunction function) throws Throwable {
        TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)Types.STRING);
    }

    private static /* synthetic */ void lambda$testMissingTupleGenerics$0(RichMapFunction function) throws Throwable {
        TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)Types.STRING);
    }

    public static class PojoWithCollections<T> {
        public Map<String, Integer> mapVal = new HashMap<String, Integer>();
        public List<String> listVal = new ArrayList<String>();
        public Collection<String> collectionVal = new ArrayList<String>();
        public Set<String> setVal = new HashSet<String>();
        public LinkedList<String> linkedListVal = new LinkedList();
        public List rawListVal = new ArrayList();
        public List<T> genericListVal = new ArrayList<T>();
        public List<?> wildcardListVal = new ArrayList();
    }

    public static class EitherMapper3
    implements MapFunction<Either2, Either2> {
        public Either2 map(Either2 value) throws Exception {
            return null;
        }
    }

    public static class EitherMapper2
    implements MapFunction<String, Either2> {
        public Either2 map(String value) throws Exception {
            return null;
        }
    }

    public static class EitherMapper<T>
    implements MapFunction<T, Either1<T>> {
        public Either1<T> map(T value) throws Exception {
            return null;
        }
    }

    public static class Either2
    extends Either1<Tuple1<Integer>> {
    }

    public static class Either1<T>
    extends Either<String, T> {
        public String left() throws IllegalStateException {
            return null;
        }

        public T right() throws IllegalStateException {
            return null;
        }
    }

    public static class MapWithResultTypeQueryable
    implements MapFunction,
    ResultTypeQueryable {
        private static final long serialVersionUID = 1L;

        public TypeInformation getProducedType() {
            return BasicTypeInfo.STRING_TYPE_INFO;
        }

        public Object map(Object value) throws Exception {
            return null;
        }
    }

    public static class MapperWithMultiDimGenericArray<T>
    implements MapFunction<T[][][], Tuple1<T>[][][]> {
        private static final long serialVersionUID = 1L;

        public Tuple1<T>[][][] map(T[][][] value) throws Exception {
            return null;
        }
    }

    public static enum MyEnum {
        ONE,
        TWO,
        THREE;

    }

    public class JoinWithCustomTuple2WithArray<T>
    extends RichJoinFunction<CustomTuple2WithArray<T>, CustomTuple2WithArray<T>, CustomTuple2WithArray<T>> {
        public CustomTuple2WithArray<T> join(CustomTuple2WithArray<T> first, CustomTuple2WithArray<T> second) throws Exception {
            return null;
        }
    }

    public static class CustomTuple2WithArray<K>
    extends Tuple2<K[], K> {
    }

    public static class EdgeMapper4<K, V>
    implements MapFunction<Edge<K, V>[], V> {
        private static final long serialVersionUID = 1L;

        public V map(Edge<K, V>[] value) throws Exception {
            return null;
        }
    }

    public static class EdgeMapper3<K, V>
    implements MapFunction<Edge<K, V>, V> {
        private static final long serialVersionUID = 1L;

        public V map(Edge<K, V> value) throws Exception {
            return null;
        }
    }

    public static class EdgeMapper2<V>
    implements MapFunction<V, Edge<Long, V>> {
        private static final long serialVersionUID = 1L;

        public Edge<Long, V> map(V value) throws Exception {
            return null;
        }
    }

    public static class EdgeMapper<K, V>
    implements MapFunction<Edge<K, V>, Edge<K, V>> {
        private static final long serialVersionUID = 1L;

        public Edge<K, V> map(Edge<K, V> value) throws Exception {
            return null;
        }
    }

    public static class Edge<K, V>
    extends Tuple3<K, K, V> {
        private static final long serialVersionUID = 1L;
    }

    public static class DuplicateValueNested<T>
    implements MapFunction<Tuple1<Tuple1<T>>, Tuple2<T, T>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<T, T> map(Tuple1<Tuple1<T>> vertex) {
            return new Tuple2(null, null);
        }
    }

    public static class DuplicateValue<T>
    implements MapFunction<Tuple1<T>, Tuple2<T, T>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<T, T> map(Tuple1<T> vertex) {
            return new Tuple2(vertex.f0, vertex.f0);
        }
    }

    public static class MyQueryableMapper<A>
    extends RichMapFunction<String, A>
    implements ResultTypeQueryable<A> {
        private static final long serialVersionUID = 1L;

        public TypeInformation<A> getProducedType() {
            return BasicTypeInfo.INT_TYPE_INFO;
        }

        public A map(String value) throws Exception {
            return null;
        }
    }

    public static class DummyFlatMapFunction<A, B, C, D>
    extends RichFlatMapFunction<Tuple2<A, B>, Tuple2<C, D>> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Tuple2<A, B> value, Collector<Tuple2<C, D>> out) throws Exception {
        }
    }

    public static class InType
    extends MyObject<String> {
    }

    public static class MyObject<T> {
        public T myField;
    }

    public class GenericArrayClass<T>
    extends RichMapFunction<T[], T[]> {
        private static final long serialVersionUID = 1L;

        public T[] map(T[] value) throws Exception {
            return null;
        }
    }

    public class CustomArrayObject2<F>
    extends Tuple1<F> {
        private static final long serialVersionUID = 1L;
    }

    public static class CustomArrayObject {
    }

    public static abstract class AbstractClassWithMember {
        public int x;
    }

    public static abstract class AbstractClassWithoutMember {
    }

    public static interface Testable {
    }

    public class FieldDuplicator<T>
    extends RichMapFunction<T, Tuple2<T, T>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<T, T> map(T value) {
            return new Tuple2(value, value);
        }
    }

    public class OneAppender<T>
    extends RichMapFunction<T, Tuple2<T, Integer>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<T, Integer> map(T value) {
            return new Tuple2(value, (Object)1);
        }
    }

    public class Mapper2
    extends Mapper {
        private static final long serialVersionUID = 1L;

        @Override
        public String map(String value) throws Exception {
            return null;
        }
    }

    public class Mapper
    extends IdentityMapper<String> {
        private static final long serialVersionUID = 1L;

        @Override
        public String map(String value) throws Exception {
            return null;
        }
    }

    public class IdentityMapper5<D>
    extends IdentityMapper<Tuple2<D, D>> {
        private static final long serialVersionUID = 1L;
    }

    public class IdentityMapper4<D>
    extends IdentityMapper<D> {
        private static final long serialVersionUID = 1L;
    }

    public class IdentityMapper3<T, V>
    extends RichMapFunction<T, V> {
        private static final long serialVersionUID = 1L;

        public V map(T value) throws Exception {
            return null;
        }
    }

    public class IdentityMapper2<T>
    extends RichMapFunction<Tuple2<T, String>, T> {
        private static final long serialVersionUID = 1L;

        public T map(Tuple2<T, String> value) throws Exception {
            return null;
        }
    }

    public class IdentityMapper<T>
    extends RichMapFunction<T, T> {
        private static final long serialVersionUID = 1L;

        public T map(T value) throws Exception {
            return null;
        }
    }

    public static class Nested2<T>
    extends Nested<T, Nested<Integer, T>> {
        private static final long serialVersionUID = 1L;

        public Nested2(T field0, Tuple2<Nested<Integer, T>, Nested<Integer, T>> field1) {
            super(field0, field1);
        }
    }

    public static class Nested<V, T>
    extends Tuple2<V, Tuple2<T, T>> {
        private static final long serialVersionUID = 1L;

        public Nested(V field0, Tuple2<T, T> field1) {
            super(field0, field1);
        }
    }

    public static class SameTypeVariable<X>
    extends Tuple2<X, X> {
        private static final long serialVersionUID = 1L;

        public SameTypeVariable(X field0, X field1) {
            super(field0, field1);
        }
    }

    public static class ChainedFour
    extends ChainedThree {
        private static final long serialVersionUID = 1L;

        public ChainedFour(String field0, Long field1, String field2) {
            super(field0, field1, field2);
        }
    }

    public static class ChainedThree
    extends ChainedTwo<String> {
        private static final long serialVersionUID = 1L;

        public ChainedThree(String field0, Long field1, String field2) {
            super(field0, field1, field2);
        }
    }

    public static class ChainedTwo<V>
    extends ChainedOne<String, V> {
        private static final long serialVersionUID = 1L;

        public ChainedTwo(String field0, Long field1, V field2) {
            super(field0, field1, field2);
        }
    }

    public static class ChainedOne<X, Y>
    extends Tuple3<X, Long, Y> {
        private static final long serialVersionUID = 1L;

        public ChainedOne(X field0, Long field1, Y field2) {
            this.f0 = field0;
            this.f1 = field1;
            this.f2 = field2;
        }
    }

    public static class LongKeyValue<V>
    extends Tuple2<Long, V> {
        private static final long serialVersionUID = 1L;

        public LongKeyValue(Long field1, V field2) {
            this.f0 = field1;
            this.f1 = field2;
        }
    }

    public static class CustomChainingPojoType {
        private String myField1;
        private int myField2;

        public CustomChainingPojoType setMyField1(String myField1) {
            this.myField1 = myField1;
            return this;
        }

        public CustomChainingPojoType setMyField2(int myField2) {
            this.myField2 = myField2;
            return this;
        }

        public String getMyField1() {
            return this.myField1;
        }

        public int getMyField2() {
            return this.myField2;
        }
    }

    public static class CustomType {
        public String myField1;
        public int myField2;

        public CustomType() {
        }

        public CustomType(String myField1, int myField2) {
            this.myField1 = myField1;
            this.myField2 = myField2;
        }
    }

    public static class PojoWithNonPublicDefaultCtor {
        public int foo;
        public int bar;

        PojoWithNonPublicDefaultCtor() {
        }
    }

    public static class CustomTuple
    extends Tuple2<String, Integer> {
        private static final long serialVersionUID = 1L;

        public CustomTuple(String myField1, Integer myField2) {
            this.setFields(myField1, myField2);
        }

        public String getMyField1() {
            return (String)this.f0;
        }

        public int getMyField2() {
            return (Integer)this.f1;
        }
    }
}

