/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.StringUtils;
import org.junit.jupiter.api.Test;

public abstract class AbstractGenericTypeSerializerTest {
    private final Random rnd = new Random(349712539451944123L);

    @Test
    void testString() {
        this.runTests("abc", "", StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)10, (int)100), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)1000, (int)5000), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)30000, (int)35000), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)102400, (int)107520));
    }

    @Test
    void testSimpleTypesObjects() {
        SimpleTypes a = new SimpleTypes();
        SimpleTypes b = new SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        SimpleTypes c = new SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        SimpleTypes d = new SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        SimpleTypes e = new SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        SimpleTypes f = new SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        SimpleTypes g = new SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        this.runTests(a, b, c, d, e, f, g);
    }

    @Test
    void testCompositeObject() {
        ComplexNestedObject1 o1 = new ComplexNestedObject1(5626435);
        ComplexNestedObject1 o2 = new ComplexNestedObject1(76923);
        ComplexNestedObject1 o3 = new ComplexNestedObject1(-1100);
        ComplexNestedObject1 o4 = new ComplexNestedObject1(0);
        ComplexNestedObject1 o5 = new ComplexNestedObject1(44);
        this.runTests(o1, o2, o3, o4, o5);
    }

    @Test
    void testNestedObjects() {
        ComplexNestedObject2 o1 = new ComplexNestedObject2(this.rnd);
        ComplexNestedObject2 o2 = new ComplexNestedObject2();
        ComplexNestedObject2 o3 = new ComplexNestedObject2(this.rnd);
        ComplexNestedObject2 o4 = new ComplexNestedObject2(this.rnd);
        this.runTests(o1, o2, o3, o4);
    }

    @Test
    void testBeanStyleObjects() {
        Book b1 = new Book(976243875L, "The Serialization Odyssey", 42L);
        Book b2 = new Book(0L, "Debugging byte streams", 1337L);
        Book b3 = new Book(-1L, "Low level interfaces", 12648430L);
        this.runTests(b1, b2, b3);
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        BookAuthor b12 = new BookAuthor(976243875L, list, "Arno Nym");
        ArrayList<String> list2 = new ArrayList<String>();
        BookAuthor b22 = new BookAuthor(987654321L, list2, "The Saurus");
        this.runTests(b12, b22);
    }

    @Test
    void testNestedInterfaces() {
        SimpleWithNestedInterfaces s1 = new SimpleWithNestedInterfaces("Hello", 1);
        SimpleWithNestedInterfaces s2 = new SimpleWithNestedInterfaces("Ciao", 2);
        SimpleWithNestedInterfaces s3 = new SimpleWithNestedInterfaces("Foo", 3);
        this.runTests(s1, s2, s3);
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        BookAuthor b1 = new BookAuthor(976243875L, list, "Arno Nym");
        ArrayList<String> list2 = new ArrayList<String>();
        BookAuthor b2 = new BookAuthor(987654321L, list2, "The Saurus");
        this.runTests(b1, b2);
    }

    protected final <T> void runTests(T ... instances) {
        if (instances == null || instances.length == 0) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = instances[0].getClass();
        TypeSerializer<?> serializer = this.createSerializer(clazz);
        SerializerTestInstance test = new SerializerTestInstance<T>(serializer, clazz, -1, (Object[])instances){};
        test.testAll();
    }

    protected abstract <T> TypeSerializer<T> createSerializer(Class<T> var1);

    public static class BookAuthor {
        private long authorId;
        private List<String> bookTitles;
        private String authorName;

        public BookAuthor() {
        }

        public BookAuthor(long authorId, List<String> bookTitles, String authorName) {
            this.authorId = authorId;
            this.bookTitles = bookTitles;
            this.authorName = authorName;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == BookAuthor.class) {
                BookAuthor other = (BookAuthor)obj;
                return other.authorName.equals(this.authorName) && other.authorId == this.authorId && other.bookTitles.equals(this.bookTitles);
            }
            return false;
        }
    }

    public static class Book {
        private long bookId;
        private String title;
        private long authorId;

        public Book() {
        }

        public Book(long bookId, String title, long authorId) {
            this.bookId = bookId;
            this.title = title;
            this.authorId = authorId;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == Book.class) {
                Book other = (Book)obj;
                return other.bookId == this.bookId && other.authorId == this.authorId && this.title.equals(other.title);
            }
            return false;
        }
    }

    public static class ComplexNestedObject2 {
        private long longValue;
        private final Map<String, ComplexNestedObject1> theMap = new HashMap<String, ComplexNestedObject1>();

        public ComplexNestedObject2() {
        }

        public ComplexNestedObject2(Random rnd) {
            this.longValue = rnd.nextLong();
            this.theMap.put(String.valueOf(rnd.nextLong()), new ComplexNestedObject1(rnd.nextInt()));
            this.theMap.put(String.valueOf(rnd.nextLong()), new ComplexNestedObject1(rnd.nextInt()));
            this.theMap.put(String.valueOf(rnd.nextLong()), new ComplexNestedObject1(rnd.nextInt()));
            this.theMap.put(String.valueOf(rnd.nextLong()), new ComplexNestedObject1(rnd.nextInt()));
            this.theMap.put(String.valueOf(rnd.nextLong()), new ComplexNestedObject1(rnd.nextInt()));
            this.theMap.put(String.valueOf(rnd.nextLong()), new ComplexNestedObject1(rnd.nextInt()));
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == ComplexNestedObject2.class) {
                ComplexNestedObject2 other = (ComplexNestedObject2)obj;
                return other.longValue == this.longValue && this.theMap.equals(other.theMap);
            }
            return false;
        }
    }

    public static class ComplexNestedObject1 {
        private double doubleValue;
        private List<String> stringList;

        public ComplexNestedObject1() {
        }

        public ComplexNestedObject1(int offInit) {
            this.doubleValue = 6293485.6723 + (double)offInit;
            this.stringList = new ArrayList<String>();
            this.stringList.add("A" + offInit);
            this.stringList.add("somewhat" + offInit);
            this.stringList.add("random" + offInit);
            this.stringList.add("collection" + offInit);
            this.stringList.add("of" + offInit);
            this.stringList.add("strings" + offInit);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == ComplexNestedObject1.class) {
                ComplexNestedObject1 other = (ComplexNestedObject1)obj;
                return other.doubleValue == this.doubleValue && this.stringList.equals(other.stringList);
            }
            return false;
        }
    }

    public static final class SimpleTypes {
        private final int iVal;
        private final long lVal;
        private final byte bVal;
        private final String sVal;
        private final short rVal;
        private final double dVal;

        public SimpleTypes() {
            this(0, 0L, 0, "", 0, 0.0);
        }

        public SimpleTypes(int iVal, long lVal, byte bVal, String sVal, short rVal, double dVal) {
            this.iVal = iVal;
            this.lVal = lVal;
            this.bVal = bVal;
            this.sVal = sVal;
            this.rVal = rVal;
            this.dVal = dVal;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == SimpleTypes.class) {
                SimpleTypes other = (SimpleTypes)obj;
                return other.iVal == this.iVal && other.lVal == this.lVal && other.bVal == this.bVal && other.sVal.equals(this.sVal) && other.rVal == this.rVal && other.dVal == this.dVal;
            }
            return false;
        }

        public String toString() {
            return String.format("(%d, %d, %d, %s, %d, %f)", this.iVal, this.lVal, this.bVal, this.sVal, this.rVal, this.dVal);
        }
    }

    public static final class SimpleWithNestedInterfaces {
        Map<String, Integer> map1 = new HashMap<String, Integer>();
        List<String> list;

        public SimpleWithNestedInterfaces() {
            this.list = new ArrayList<String>();
        }

        public SimpleWithNestedInterfaces(String str, Integer i) {
            this.map1.put(str, i);
            this.list = new ArrayList<String>();
            this.list.add(str);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleWithNestedInterfaces that = (SimpleWithNestedInterfaces)o;
            if (!this.list.equals(that.list)) {
                return false;
            }
            return this.map1.equals(that.map1);
        }

        public int hashCode() {
            int result = this.map1.hashCode();
            result = 31 * result + this.list.hashCode();
            return result;
        }
    }
}

