/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.Objects;

public class KryoPojosForMigrationTests {

    public static class DogV2KryoSerializer
    extends Serializer<Dog>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, Dog object) {
            output.writeString(object.getName());
        }

        public Dog read(Kryo kryo, Input input, Class<? extends Dog> type) {
            return new Dog(input.readString());
        }
    }

    public static class DogKryoSerializer
    extends Serializer<Dog>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, Dog object) {
            output.writeString(object.getName());
        }

        public Dog read(Kryo kryo, Input input, Class<? extends Dog> type) {
            return new Dog(input.readString());
        }
    }

    public static class ParrotKryoSerializer
    extends Serializer<Parrot>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, Parrot object) {
            output.writeString(object.getAccent());
        }

        public Parrot read(Kryo kryo, Input input, Class<? extends Parrot> type) {
            return new Parrot(input.readString());
        }
    }

    public static class HousePets {
        private final Dog dog;
        private final Cat cat;

        public HousePets(Dog dog, Cat cat) {
            this.dog = dog;
            this.cat = cat;
        }

        public Dog getDog() {
            return this.dog;
        }

        public Cat getCat() {
            return this.cat;
        }
    }

    public static class Parrot
    extends Animal {
        private final String accent;

        public Parrot(String accent) {
            this.accent = accent;
        }

        public String getAccent() {
            return this.accent;
        }
    }

    public static class Cat
    extends Animal {
        private final String name;
        private final int age;

        public Cat(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }
    }

    public static class Dog
    extends Animal {
        private final String name;

        public Dog(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dog dog = (Dog)o;
            return Objects.equals(this.name, dog.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static abstract class Animal {
    }
}

