/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class ConfigurationConversionsTest {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final long TOO_LONG = 0x80000009L;
    private static final double TOO_LONG_DOUBLE = Double.MAX_VALUE;
    private Configuration pc;
    @Parameter
    private TestSpec testSpec;

    ConfigurationConversionsTest() {
    }

    @BeforeEach
    void init() {
        this.pc = new Configuration();
        this.pc.set(ConfigurationUtils.getIntConfigOption((String)"int"), (Object)5);
        this.pc.set(ConfigurationUtils.getLongConfigOption((String)"long"), (Object)15L);
        this.pc.set(ConfigurationUtils.getLongConfigOption((String)"too_long"), (Object)0x80000009L);
        this.pc.set(ConfigurationUtils.getFloatConfigOption((String)"float"), (Object)Float.valueOf(2.1456776f));
        this.pc.set(ConfigurationUtils.getDoubleConfigOption((String)"double"), (Object)Math.PI);
        this.pc.set(ConfigurationUtils.getDoubleConfigOption((String)"negative_double"), (Object)-1.0);
        this.pc.set(ConfigurationUtils.getDoubleConfigOption((String)"zero"), (Object)0.0);
        this.pc.set(ConfigurationUtils.getDoubleConfigOption((String)"too_long_double"), (Object)Double.MAX_VALUE);
        this.pc.setString("string", "42");
        this.pc.setString("non_convertible_string", "bcdefg&&");
        this.pc.set(ConfigurationUtils.getBooleanConfigOption((String)"boolean"), (Object)true);
    }

    @Parameters(name="testSpec={0}")
    private static Collection<TestSpec> getSpecs() {
        return Arrays.asList(TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"int"), (Object)0)).expect(5), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"int"), (Object)0L)).expect(5L), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"int"), (Object)Float.valueOf(0.0f))).expect(Float.valueOf(5.0f)), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"int"), (Object)0.0)).expect(5.0), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"int"), (Object)true)).expectException("Could not parse value '5' for key 'int'."), TestSpec.whenAccessed(conf -> conf.getString("int", "0")).expect("5"), TestSpec.whenAccessed(conf -> conf.getBytes("int", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 5 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"long"), (Object)0)).expect(15), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"long"), (Object)0L)).expect(15L), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"long"), (Object)Float.valueOf(0.0f))).expect(Float.valueOf(15.0f)), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"long"), (Object)0.0)).expect(15.0), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"long"), (Object)true)).expectException("Could not parse value '15' for key 'long'."), TestSpec.whenAccessed(conf -> conf.getString("long", "0")).expect("15"), TestSpec.whenAccessed(conf -> conf.getBytes("long", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 15 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"too_long"), (Object)0)).expectException("Could not parse value '2147483657' for key 'too_long'."), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"too_long"), (Object)0L)).expect(0x80000009L), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"too_long"), (Object)Float.valueOf(0.0f))).expect(Float.valueOf(2.1474836E9f)), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"too_long"), (Object)0.0)).expect(2.147483657E9), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"too_long"), (Object)true)).expectException("Could not parse value '2147483657' for key 'too_long'."), TestSpec.whenAccessed(conf -> conf.getString("too_long", "0")).expect(String.valueOf(0x80000009L)), TestSpec.whenAccessed(conf -> conf.getBytes("too_long", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 2147483657 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"float"), (Object)0)).expectException("Could not parse value '2.1456776' for key 'float'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"float"), (Object)0L)).expectException("Could not parse value '2.1456776' for key 'float'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"float"), (Object)Float.valueOf(0.0f))).expect(Float.valueOf(2.1456776f)), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"float"), (Object)0.0)).expect((Double)new Condition(d -> Math.abs(d - 2.1456775) < 1.0E-7, "Expected value", new Object[0])), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"float"), (Object)true)).expectException("Could not parse value '2.1456776' for key 'float'."), TestSpec.whenAccessed(conf -> conf.getString("float", "0")).expect((String)new Condition(s -> s.startsWith("2.145677"), "Expected value", new Object[0])), TestSpec.whenAccessed(conf -> conf.getBytes("float", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 2.1456776 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"double"), (Object)0)).expectException("Could not parse value '3.141592653589793' for key 'double'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"double"), (Object)0L)).expectException("Could not parse value '3.141592653589793' for key 'double'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"double"), (Object)Float.valueOf(0.0f))).expect((Float)((Object)new IsCloseTo(3.141592f, 1.0E-6f))), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"double"), (Object)0.0)).expect(Math.PI), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"double"), (Object)true)).expectException("Could not parse value '3.141592653589793' for key 'double'."), TestSpec.whenAccessed(conf -> conf.getString("double", "0")).expect((String)new Condition(s -> s.startsWith("3.141592"), "Expected value", new Object[0])), TestSpec.whenAccessed(conf -> conf.getBytes("double", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 3.141592653589793 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"negative_double"), (Object)0)).expectException("Could not parse value '-1.0' for key 'negative_double'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"negative_double"), (Object)0L)).expectException("Could not parse value '-1.0' for key 'negative_double'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"negative_double"), (Object)Float.valueOf(0.0f))).expect((Float)((Object)new IsCloseTo(-1.0f, 1.0E-6f))), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"negative_double"), (Object)0.0)).expect(-1.0), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"negative_double"), (Object)true)).expectException("Could not parse value '-1.0' for key 'negative_double'."), TestSpec.whenAccessed(conf -> conf.getString("negative_double", "0")).expect((String)new Condition(s -> s.startsWith("-1.0"), "Expected value", new Object[0])), TestSpec.whenAccessed(conf -> conf.getBytes("negative_double", EMPTY_BYTES)).expectException("Configuration cannot evaluate value -1.0 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"zero"), (Object)0)).expectException("Could not parse value '0.0' for key 'zero'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"zero"), (Object)0L)).expectException("Could not parse value '0.0' for key 'zero'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"zero"), (Object)Float.valueOf(0.0f))).expect((Float)((Object)new IsCloseTo(0.0f, 1.0E-6f))), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"zero"), (Object)0.0)).expect(0.0), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"zero"), (Object)true)).expectException("Could not parse value '0.0' for key 'zero'."), TestSpec.whenAccessed(conf -> conf.getString("zero", "0")).expect((String)new Condition(s -> s.startsWith("0"), "Expected value", new Object[0])), TestSpec.whenAccessed(conf -> conf.getBytes("zero", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 0.0 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"too_long_double"), (Object)0)).expectException("Could not parse value '1.7976931348623157E308' for key 'too_long_double'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"too_long_double"), (Object)0L)).expectException("Could not parse value '1.7976931348623157E308' for key 'too_long_double'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"too_long_double"), (Object)Float.valueOf(0.0f))).expectException("Could not parse value '1.7976931348623157E308' for key 'too_long_double'."), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"too_long_double"), (Object)0.0)).expect((Double)Double.MAX_VALUE), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"too_long_double"), (Object)true)).expectException("Could not parse value '1.7976931348623157E308' for key 'too_long_double'."), TestSpec.whenAccessed(conf -> conf.getString("too_long_double", "0")).expect(String.valueOf(Double.MAX_VALUE)), TestSpec.whenAccessed(conf -> conf.getBytes("too_long_double", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 1.7976931348623157E308 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"string"), (Object)0)).expect(42), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"string"), (Object)0L)).expect(42L), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"string"), (Object)Float.valueOf(0.0f))).expect(Float.valueOf(42.0f)), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"string"), (Object)0.0)).expect(42.0), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"string"), (Object)true)).expectException("Could not parse value '42' for key 'string'."), TestSpec.whenAccessed(conf -> conf.getString("string", "0")).expect("42"), TestSpec.whenAccessed(conf -> conf.getBytes("string", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 42 as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"non_convertible_string"), (Object)0)).expectException("Could not parse value 'bcdefg&&' for key 'non_convertible_string'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"non_convertible_string"), (Object)0L)).expectException("Could not parse value 'bcdefg&&' for key 'non_convertible_string'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"non_convertible_string"), (Object)Float.valueOf(0.0f))).expectException("Could not parse value 'bcdefg&&' for key 'non_convertible_string'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"non_convertible_string"), (Object)0.0)).expectException("Could not parse value 'bcdefg&&' for key 'non_convertible_string'.", IllegalArgumentException.class), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"non_convertible_string"), (Object)true)).expectException("Could not parse value 'bcdefg&&' for key 'non_convertible_string'."), TestSpec.whenAccessed(conf -> conf.getString("non_convertible_string", "0")).expect("bcdefg&&"), TestSpec.whenAccessed(conf -> conf.getBytes("non_convertible_string", EMPTY_BYTES)).expectException("Configuration cannot evaluate value bcdefg&& as a byte[] value"), TestSpec.whenAccessed(conf -> (Integer)conf.get(ConfigurationUtils.getIntConfigOption((String)"boolean"), (Object)0)).expectException("Could not parse value 'true' for key 'boolean'."), TestSpec.whenAccessed(conf -> (Long)conf.get(ConfigurationUtils.getLongConfigOption((String)"boolean"), (Object)0L)).expectException("Could not parse value 'true' for key 'boolean'."), TestSpec.whenAccessed(conf -> (Float)conf.get(ConfigurationUtils.getFloatConfigOption((String)"boolean"), (Object)Float.valueOf(0.0f))).expectException("Could not parse value 'true' for key 'boolean'."), TestSpec.whenAccessed(conf -> (Double)conf.get(ConfigurationUtils.getDoubleConfigOption((String)"boolean"), (Object)0.0)).expectException("Could not parse value 'true' for key 'boolean'."), TestSpec.whenAccessed(conf -> (Boolean)conf.get(ConfigurationUtils.getBooleanConfigOption((String)"boolean"), (Object)false)).expect(true), TestSpec.whenAccessed(conf -> conf.getString("boolean", "0")).expect("true"), TestSpec.whenAccessed(conf -> conf.getBytes("boolean", EMPTY_BYTES)).expectException("Configuration cannot evaluate value true as a byte[] value"));
    }

    @TestTemplate
    void testConversions() throws Exception {
        Optional<String> expectedException = this.testSpec.getExpectedException();
        if (expectedException.isPresent()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testSpec.assertConfiguration(this.pc)).isInstanceOf(this.testSpec.getExceptionClass())).hasMessageContaining(expectedException.get());
            return;
        }
        this.testSpec.assertConfiguration(this.pc);
    }

    private static class TestSpec<T> {
        private final ConfigurationAccessor<T> configurationAccessor;
        private Condition<T> condition;
        @Nullable
        private String expectedException = null;
        @Nullable
        private Class<? extends Exception> exceptionClass;

        private TestSpec(ConfigurationAccessor<T> configurationAccessor) {
            this.configurationAccessor = configurationAccessor;
        }

        public static <T> TestSpec<T> whenAccessed(ConfigurationAccessor<T> configurationAccessor) {
            return new TestSpec<T>(configurationAccessor);
        }

        public TestSpec<T> expect(Condition<T> expected) {
            this.condition = expected;
            return this;
        }

        public TestSpec<T> expect(T expected) {
            this.condition = new Condition(value -> Objects.equals(value, expected), "Expected value", new Object[0]);
            return this;
        }

        public TestSpec<T> expectException(String message) {
            this.expectedException = message;
            this.exceptionClass = IllegalArgumentException.class;
            return this;
        }

        public TestSpec<T> expectException(String message, Class<? extends Exception> exceptionClass) {
            this.expectedException = message;
            this.exceptionClass = exceptionClass;
            return this;
        }

        public Optional<String> getExpectedException() {
            return Optional.ofNullable(this.expectedException);
        }

        @Nullable
        public Class<? extends Exception> getExceptionClass() {
            return this.exceptionClass;
        }

        void assertConfiguration(Configuration conf) throws Exception {
            Assertions.assertThat(this.configurationAccessor.access(conf)).is(this.condition);
        }

        public String toString() {
            return String.format("accessor = %s, expected = %s", this.configurationAccessor, this.condition);
        }

        @FunctionalInterface
        private static interface ConfigurationAccessor<T> {
            public T access(Configuration var1) throws Exception;
        }
    }

    private static class IsCloseTo
    extends Condition<Float> {
        private final float delta;
        private final float value;

        public IsCloseTo(float value, float error) {
            this.delta = error;
            this.value = value;
        }

        public boolean matches(Float item) {
            return this.actualDelta(item) <= 0.0;
        }

        private double actualDelta(Float item) {
            return Math.abs(item.floatValue() - this.value) - this.delta;
        }
    }
}

