/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CoreOptionsTest {
    CoreOptionsTest() {
    }

    @Test
    void testGetParentFirstLoaderPatterns() {
        this.testParentFirst(CoreOptions::getParentFirstLoaderPatterns, (ConfigOption<List<String>>)CoreOptions.ALWAYS_PARENT_FIRST_LOADER_PATTERNS, (ConfigOption<List<String>>)CoreOptions.ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL);
    }

    @Test
    void testGetPluginParentFirstLoaderPatterns() {
        this.testParentFirst(CoreOptions::getPluginParentFirstLoaderPatterns, (ConfigOption<List<String>>)CoreOptions.PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS, (ConfigOption<List<String>>)CoreOptions.PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL);
    }

    private void testParentFirst(Function<Configuration, String[]> patternGetter, ConfigOption<List<String>> patternOption, ConfigOption<List<String>> additionalOption) {
        Configuration config = new Configuration();
        Assertions.assertThat((Object[])patternGetter.apply(config)).containsExactly((Object[])((List)patternOption.defaultValue()).toArray(new String[0]));
        config.set(patternOption, Arrays.asList("hello", "world"));
        Assertions.assertThat((Object[])patternGetter.apply(config)).containsExactly((Object[])new String[]{"hello", "world"});
        config.set(additionalOption, Arrays.asList("how", "are", "you"));
        Assertions.assertThat((Object[])patternGetter.apply(config)).containsExactly((Object[])new String[]{"hello", "world", "how", "are", "you"});
        config.set(patternOption, Collections.emptyList());
        Assertions.assertThat((Object[])patternGetter.apply(config)).containsExactly((Object[])new String[]{"how", "are", "you"});
    }
}

